/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.transforms.implementations;

import com.systinet.wasp.security.secext.c14n.CanonicalizationException;
import com.systinet.wasp.security.secext.c14n.InvalidCanonicalizerException;
import com.systinet.wasp.security.secext.signature.XMLSignatureInput;
import com.systinet.wasp.security.secext.transforms.TransformSpi;
import com.systinet.wasp.security.secext.transforms.TransformationException;
import com.systinet.wasp.security.secext.utils.XMLUtils;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class TransformEnvelopedSignature
extends TransformSpi {
    public static final String implementedTransformURI = "http://www.w3.org/2000/09/xmldsig#enveloped-signature";

    public boolean wantsOctetStream() {
        return true;
    }

    public boolean wantsNodeSet() {
        return true;
    }

    public boolean returnsOctetStream() {
        return true;
    }

    public boolean returnsNodeSet() {
        return false;
    }

    protected String engineGetURI() {
        return implementedTransformURI;
    }

    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput input) throws TransformationException {
        try {
            Document inputDoc;
            Element transformElement;
            Node signatureElement;
            Set inputSet = input.getNodeSet();
            if (inputSet.isEmpty()) {
                Object[] exArgs = new Object[]{"input node set contains no nodes"};
                throw new TransformationException("generic.EmptyMessage", exArgs);
            }
            boolean found = false;
            for (signatureElement = transformElement = this._transformObject.getElement(); signatureElement != null && signatureElement.getNodeType() != 9; signatureElement = signatureElement.getParentNode()) {
                if (!signatureElement.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#") || !signatureElement.getLocalName().equals("Signature")) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new TransformationException("envelopedSignatureTransformNotInSignatureElement");
            }
            Document transformDoc = transformElement.getOwnerDocument();
            if (transformDoc != (inputDoc = XMLUtils.getOwnerDocument((Node)inputSet.iterator().next()))) {
                throw new TransformationException("xpath.funcHere.documentsDiffer");
            }
            HashSet<Node> resultSet = new HashSet<Node>();
            Iterator iterator = inputSet.iterator();
            while (iterator.hasNext()) {
                Node inputNode = (Node)iterator.next();
                if (TransformEnvelopedSignature.isDescendantOrSelf(signatureElement, inputNode)) continue;
                resultSet.add(inputNode);
            }
            XMLSignatureInput result = new XMLSignatureInput(resultSet, input.getCachedXPathAPI());
            return result;
        }
        catch (IOException ex) {
            throw new TransformationException("empty", ex);
        }
        catch (SAXException ex) {
            throw new TransformationException("empty", ex);
        }
        catch (ParserConfigurationException ex) {
            throw new TransformationException("empty", ex);
        }
        catch (CanonicalizationException ex) {
            throw new TransformationException("empty", ex);
        }
        catch (InvalidCanonicalizerException ex) {
            throw new TransformationException("empty", ex);
        }
    }

    static boolean isDescendantOrSelf(Node ctx, Node descendantOrSelf) {
        if (ctx == descendantOrSelf) {
            return true;
        }
        Node parent = descendantOrSelf;
        while (parent != null) {
            if (parent == ctx) {
                return true;
            }
            if (parent.getNodeType() == 2) {
                parent = ((Attr)parent).getOwnerElement();
                continue;
            }
            parent = parent.getParentNode();
        }
        return false;
    }
}

