/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.transforms;

import com.idoox.debug.Category;
import com.systinet.wasp.security.secext.c14n.CanonicalizationException;
import com.systinet.wasp.security.secext.c14n.InvalidCanonicalizerException;
import com.systinet.wasp.security.secext.exceptions.XMLSecurityException;
import com.systinet.wasp.security.secext.signature.XMLSignatureException;
import com.systinet.wasp.security.secext.signature.XMLSignatureInput;
import com.systinet.wasp.security.secext.transforms.InvalidTransformException;
import com.systinet.wasp.security.secext.transforms.Transform;
import com.systinet.wasp.security.secext.transforms.TransformationException;
import com.systinet.wasp.security.secext.utils.SignatureElementProxy;
import com.systinet.wasp.security.secext.utils.XMLUtils;
import java.io.IOException;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Transforms
extends SignatureElementProxy {
    static Category cat = Category.getCategory((String)(class$com$systinet$wasp$security$secext$transforms$Transforms == null ? (class$com$systinet$wasp$security$secext$transforms$Transforms = Transforms.class$("com.systinet.wasp.security.secext.transforms.Transforms")) : class$com$systinet$wasp$security$secext$transforms$Transforms).getName());
    public static final String TRANSFORM_C14N_OMIT_COMMENTS = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    public static final String TRANSFORM_C14N_WITH_COMMENTS = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments";
    public static final String TRANSFORM_C14N_EXCL_OMIT_COMMENTS = "http://www.w3.org/2001/10/xml-exc-c14n#";
    public static final String TRANSFORM_C14N_EXCL_WITH_COMMENTS = "http://www.w3.org/2001/10/xml-exc-c14n#WithComments";
    public static final String TRANSFORM_XSLT = "http://www.w3.org/TR/1999/REC-xslt-19991116";
    public static final String TRANSFORM_BASE64_DECODE = "http://www.w3.org/2000/09/xmldsig#base64";
    public static final String TRANSFORM_XPATH = "http://www.w3.org/TR/1999/REC-xpath-19991116";
    public static final String TRANSFORM_ENVELOPED_SIGNATURE = "http://www.w3.org/2000/09/xmldsig#enveloped-signature";
    public static final String TRANSFORM_XPOINTER = "http://www.w3.org/TR/2001/WD-xptr-20010108";
    public static final String TRANSFORM_XPATH2FILTER04 = "http://www.w3.org/2002/04/xmldsig-filter2";
    public static final String TRANSFORM_XPATH2FILTER = "http://www.w3.org/2002/06/xmldsig-filter2";
    public static final String TRANSFORM_XPATHFILTERCHGP = "http://www.nue.et-inf.uni-siegen.de/~geuer-pollmann/#xpathFilter";
    static /* synthetic */ Class class$com$systinet$wasp$security$secext$transforms$Transforms;

    public Transforms(Document doc) {
        super(doc);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public Transforms(Element element, String BaseURI) throws DOMException, XMLSignatureException, InvalidTransformException, TransformationException, XMLSecurityException {
        super(element, BaseURI);
        int numberOfTransformElems = this.getLength();
        if (numberOfTransformElems == 0) {
            Object[] exArgs = new Object[]{"Transform", "Transforms"};
            throw new TransformationException("xml.WrongContent", exArgs);
        }
    }

    public void addTransform(String transformURI) throws TransformationException {
        try {
            Transform transform = Transform.getInstance(this._doc, transformURI);
            this.addTransform(transform);
        }
        catch (InvalidTransformException ex) {
            throw new TransformationException("empty", ex);
        }
    }

    public void addTransform(String transformURI, Element contextElement) throws TransformationException {
        try {
            Transform transform = Transform.getInstance(this._doc, transformURI, contextElement);
            this.addTransform(transform);
        }
        catch (InvalidTransformException ex) {
            throw new TransformationException("empty", ex);
        }
    }

    public void addTransform(String transformURI, NodeList contextNodes) throws TransformationException {
        try {
            Transform transform = Transform.getInstance(this._doc, transformURI, contextNodes);
            this.addTransform(transform);
        }
        catch (InvalidTransformException ex) {
            throw new TransformationException("empty", ex);
        }
    }

    private void addTransform(Transform transform) {
        Element transformElement = transform.getElement();
        this._constructionElement.appendChild(transformElement);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public XMLSignatureInput performTransforms(XMLSignatureInput xmlSignatureInput) throws TransformationException {
        try {
            Vector<Transform> transformSpis = new Vector<Transform>();
            int i = 0;
            while (i < this.getLength()) {
                Transform t = this.item(i);
                cat.debug("Preform the (" + i + ")th " + t.getURI() + " transform");
                xmlSignatureInput = t.performTransform(xmlSignatureInput);
                transformSpis.add(t);
                ++i;
            }
            int i2 = 0;
            while (i2 < transformSpis.size()) {
                Transform transform = (Transform)transformSpis.elementAt(i2);
                cat.debug("Cleaning the (" + i2 + ")th " + transform.getURI() + " transform");
                transform.clean();
                ++i2;
            }
            return xmlSignatureInput;
        }
        catch (IOException ex) {
            throw new TransformationException("empty", ex);
        }
        catch (CanonicalizationException ex) {
            throw new TransformationException("empty", ex);
        }
        catch (InvalidCanonicalizerException ex) {
            throw new TransformationException("empty", ex);
        }
    }

    public int getLength() throws TransformationException {
        try {
            Element nscontext = XMLUtils.createDSctx(this._doc, "ds", "http://www.w3.org/2000/09/xmldsig#");
            NodeList transformElems = XPathAPI.selectNodeList((Node)this._constructionElement, (String)"./ds:Transform", (Node)nscontext);
            return transformElems.getLength();
        }
        catch (TransformerException ex) {
            throw new TransformationException("empty", ex);
        }
    }

    public Transform item(int i) throws TransformationException {
        try {
            Element nscontext = XMLUtils.createDSctx(this._doc, "ds", "http://www.w3.org/2000/09/xmldsig#");
            Element transformElem = (Element)XPathAPI.selectSingleNode((Node)this._constructionElement, (String)("./ds:Transform[" + (i + 1) + "]"), (Node)nscontext);
            if (transformElem == null) {
                return null;
            }
            return new Transform(transformElem, this._baseURI);
        }
        catch (TransformerException ex) {
            throw new TransformationException("empty", ex);
        }
        catch (XMLSecurityException ex) {
            throw new TransformationException("empty", ex);
        }
    }

    public String getBaseLocalName() {
        return "Transforms";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

