/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.signature;

import com.systinet.wasp.security.secext.c14n.CanonicalizationException;
import com.systinet.wasp.security.secext.c14n.InvalidCanonicalizerException;
import com.systinet.wasp.security.secext.c14n.helper.C14nHelper;
import com.systinet.wasp.security.secext.c14n.implementations.Canonicalizer20010315OmitComments;
import com.systinet.wasp.security.secext.signature.XMLSignatureException;
import com.systinet.wasp.security.secext.utils.IgnoreAllErrorHandler;
import com.systinet.wasp.security.secext.utils.JavaUtils;
import com.systinet.wasp.security.secext.utils.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.xpath.CachedXPathAPI;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.SAXException;

public class XMLSignatureInput {
    InputStream _inputOctetStreamProxy = null;
    Set _inputNodeSet = null;
    CachedXPathAPI _cxpathAPI;
    private String _MIMEType = null;
    private String _SourceURI = null;

    public XMLSignatureInput(byte[] inputOctets) {
        byte[] copy = new byte[inputOctets.length];
        System.arraycopy(inputOctets, 0, copy, 0, inputOctets.length);
        this._inputOctetStreamProxy = new ByteArrayInputStream(copy);
        this._cxpathAPI = new CachedXPathAPI();
    }

    public XMLSignatureInput(InputStream inputOctetStream) throws IOException {
        this(JavaUtils.getBytesFromStream(inputOctetStream));
        inputOctetStream = null;
    }

    public XMLSignatureInput(String inputStr) {
        this(inputStr.getBytes());
    }

    public XMLSignatureInput(String inputStr, String encoding) throws UnsupportedEncodingException {
        this(inputStr.getBytes(encoding));
    }

    public XMLSignatureInput(Node rootNode, CachedXPathAPI usedXPathAPI) throws TransformerException {
        this._cxpathAPI = usedXPathAPI;
        Document doc = XMLUtils.getOwnerDocument(rootNode);
        XMLUtils.circumventBug2650(doc);
        NodeList result = this._cxpathAPI.selectNodeList(rootNode, "(.//. | .//@* | .//namespace::*)");
        this._inputNodeSet = XMLUtils.convertNodelistToSet(result);
    }

    public XMLSignatureInput(Node rootNode) throws TransformerException {
        this(rootNode, new CachedXPathAPI());
    }

    public XMLSignatureInput(Set inputNodeSet, CachedXPathAPI usedXPathAPI) {
        this._inputNodeSet = inputNodeSet;
        this._cxpathAPI = usedXPathAPI;
    }

    public XMLSignatureInput(Set inputNodeSet) {
        this(inputNodeSet, new CachedXPathAPI());
    }

    public XMLSignatureInput(NodeList inputNodeSet) {
        this(XMLUtils.convertNodelistToSet(inputNodeSet), new CachedXPathAPI());
    }

    public XMLSignatureInput(NodeList inputNodeSet, CachedXPathAPI usedXPathAPI) {
        this(XMLUtils.convertNodelistToSet(inputNodeSet), usedXPathAPI);
    }

    public Set getNodeSet() throws ParserConfigurationException, IOException, SAXException, CanonicalizationException, InvalidCanonicalizerException {
        if (this.isNodeSet()) {
            return this._inputNodeSet;
        }
        if (this.isOctetStream()) {
            DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
            dfactory.setValidating(false);
            dfactory.setNamespaceAware(true);
            DocumentBuilder db = dfactory.newDocumentBuilder();
            try {
                db.setErrorHandler(new IgnoreAllErrorHandler());
                Document doc = db.parse(this.getOctetStream());
                XMLUtils.circumventBug2650(doc);
                NodeList nodeList = this._cxpathAPI.selectNodeList((Node)doc, "(.//. | .//@* | .//namespace::*)");
                return XMLUtils.convertNodelistToSet(nodeList);
            }
            catch (TransformerException ex) {
                throw new CanonicalizationException("generic.EmptyMessage", ex);
            }
            catch (SAXException ex) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                baos.write("<container>".getBytes());
                baos.write(this.getBytes());
                baos.write("</container>".getBytes());
                byte[] result = baos.toByteArray();
                Document document = db.parse(new ByteArrayInputStream(result));
                XMLUtils.circumventBug2650(document);
                try {
                    NodeList nodeList = this._cxpathAPI.selectNodeList((Node)document, "(//. | //@* | //namespace::*)[not(self::node()=/) and not(self::node=/container)]");
                    return XMLUtils.convertNodelistToSet(nodeList);
                }
                catch (TransformerException ex2) {
                    throw new CanonicalizationException("generic.EmptyMessage", ex2);
                }
            }
        }
        throw new RuntimeException("getNodeSet() called but no input data present");
    }

    public InputStream getOctetStream() throws IOException, CanonicalizationException, InvalidCanonicalizerException {
        if (this.isOctetStream()) {
            this._inputOctetStreamProxy.reset();
            return this._inputOctetStreamProxy;
        }
        if (this.isNodeSet()) {
            Canonicalizer20010315OmitComments c14nizer = new Canonicalizer20010315OmitComments();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (this._inputNodeSet.size() == 0) {
                return new ByteArrayInputStream(baos.toByteArray());
            }
            try {
                Set nodes = this.getNodeSet();
                byte[] bytes = c14nizer.engineCanonicalizeXPathNodeSet(nodes);
                baos.write(bytes);
                return new ByteArrayInputStream(baos.toByteArray());
            }
            catch (SAXException ex) {
                throw new CanonicalizationException("empty", ex);
            }
            catch (ParserConfigurationException ex) {
                throw new CanonicalizationException("empty", ex);
            }
        }
        throw new RuntimeException("getOctetStream() called but no input data present");
    }

    public byte[] getBytes() throws IOException, CanonicalizationException, InvalidCanonicalizerException {
        InputStream is = this.getOctetStream();
        int available = is.available();
        byte[] data = new byte[available];
        is.read(data);
        if (available != data.length) {
            throw new IOException("Not enough bytes read");
        }
        return data;
    }

    public boolean isNodeSet() {
        return this._inputOctetStreamProxy == null && this._inputNodeSet != null;
    }

    public boolean isOctetStream() {
        return this._inputOctetStreamProxy != null && this._inputNodeSet == null;
    }

    public boolean isInitialized() {
        return this.isOctetStream() || this.isNodeSet();
    }

    public String getMIMEType() {
        return this._MIMEType;
    }

    public void setMIMEType(String MIMEType) {
        this._MIMEType = MIMEType;
    }

    public String getSourceURI() {
        return this._SourceURI;
    }

    public void setSourceURI(String SourceURI) {
        this._SourceURI = SourceURI;
    }

    public CachedXPathAPI getCachedXPathAPI() {
        return this._cxpathAPI;
    }

    public String toString() {
        if (this.isNodeSet()) {
            try {
                return "XMLSignatureInput/NodeSet/" + this._inputNodeSet.size() + " nodes/" + this.getSourceURI();
            }
            catch (Exception ex) {
                return "XMLSignatureInput/NodeSet//" + this.getSourceURI();
            }
        }
        try {
            return "XMLSignatureInput/OctetStream/" + this.getBytes().length + " octets/" + this.getSourceURI();
        }
        catch (Exception ex) {
            return "XMLSignatureInput/OctetStream//" + this.getSourceURI();
        }
    }

    public String getHTMLRepresentation() throws XMLSignatureException {
        XMLSignatureInputDebugger db = new XMLSignatureInputDebugger(this);
        return db.getHTMLRepresentation();
    }

    public String getHTMLRepresentation(Set inclusiveNamespaces) throws XMLSignatureException {
        XMLSignatureInputDebugger db = new XMLSignatureInputDebugger(this, inclusiveNamespaces);
        return db.getHTMLRepresentation();
    }

    public class XMLSignatureInputDebugger {
        private Set _xpathNodeSet;
        private Set _inclusiveNamespaces;
        private Document _doc = null;
        private Element _documentElement = null;
        private Writer _writer = null;
        public static final String HTMLPrefix = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n<html>\n<head>\n<title>Caninical XML node set</title>\n<style type=\"text/css\">\n<!-- \n.INCLUDED { \n   color: #000000; \n   background-color: \n   #FFFFFF; \n   font-weight: bold; } \n.EXCLUDED { \n   color: #666666; \n   background-color: \n   #999999; } \n.INCLUDEDINCLUSIVENAMESPACE { \n   color: #0000FF; \n   background-color: #FFFFFF; \n   font-weight: bold; \n   font-style: italic; } \n.EXCLUDEDINCLUSIVENAMESPACE { \n   color: #0000FF; \n   background-color: #999999; \n   font-style: italic; } \n--> \n</style> \n</head>\n<body bgcolor=\"#999999\">\n<h1>Explanation of the output</h1>\n<p>The following text contains the nodeset of the given Reference before it is canonicalized. There exist four different styles to indicate how a given node is treated.</p>\n<ul>\n<li class=\"INCLUDED\">A node which is in the node set is labeled using the INCLUDED style.</li>\n<li class=\"EXCLUDED\">A node which is <em>NOT</em> in the node set is labeled EXCLUDED style.</li>\n<li class=\"INCLUDEDINCLUSIVENAMESPACE\">A namespace which is in the node set AND in the InclusiveNamespaces PrefixList is labeled using the INCLUDEDINCLUSIVENAMESPACE style.</li>\n<li class=\"EXCLUDEDINCLUSIVENAMESPACE\">A namespace which is in NOT the node set AND in the InclusiveNamespaces PrefixList is labeled using the INCLUDEDINCLUSIVENAMESPACE style.</li>\n</ul>\n<h1>Output</h1>\n<pre>\n";
        public static final String HTMLSuffix = "</pre></body></html>";
        public static final String HTMLExcludePrefix = "<span class=\"EXCLUDED\">";
        public static final String HTMLExcludeSuffix = "</span>";
        public static final String HTMLIncludePrefix = "<span class=\"INCLUDED\">";
        public static final String HTMLIncludeSuffix = "</span>";
        public static final String HTMLIncludedInclusiveNamespacePrefix = "<span class=\"INCLUDEDINCLUSIVENAMESPACE\">";
        public static final String HTMLIncludedInclusiveNamespaceSuffix = "</span>";
        public static final String HTMLExcludedInclusiveNamespacePrefix = "<span class=\"EXCLUDEDINCLUSIVENAMESPACE\">";
        public static final String HTMLExcludedInclusiveNamespaceSuffix = "</span>";
        private static final int NODE_BEFORE_DOCUMENT_ELEMENT = -1;
        private static final int NODE_NOT_BEFORE_OR_AFTER_DOCUMENT_ELEMENT = 0;
        private static final int NODE_AFTER_DOCUMENT_ELEMENT = 1;

        private XMLSignatureInputDebugger() {
        }

        public XMLSignatureInputDebugger(XMLSignatureInput xmlSignatureInput) throws XMLSignatureException {
            this._xpathNodeSet = !xmlSignatureInput.isNodeSet() ? null : xmlSignatureInput._inputNodeSet;
        }

        public XMLSignatureInputDebugger(XMLSignatureInput xmlSignatureInput, Set inclusiveNamespace) throws XMLSignatureException {
            this(xmlSignatureInput);
            this._inclusiveNamespaces = inclusiveNamespace;
        }

        public String getHTMLRepresentation() throws XMLSignatureException {
            if (this._xpathNodeSet == null || this._xpathNodeSet.size() == 0) {
                return "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n<html>\n<head>\n<title>Caninical XML node set</title>\n<style type=\"text/css\">\n<!-- \n.INCLUDED { \n   color: #000000; \n   background-color: \n   #FFFFFF; \n   font-weight: bold; } \n.EXCLUDED { \n   color: #666666; \n   background-color: \n   #999999; } \n.INCLUDEDINCLUSIVENAMESPACE { \n   color: #0000FF; \n   background-color: #FFFFFF; \n   font-weight: bold; \n   font-style: italic; } \n.EXCLUDEDINCLUSIVENAMESPACE { \n   color: #0000FF; \n   background-color: #999999; \n   font-style: italic; } \n--> \n</style> \n</head>\n<body bgcolor=\"#999999\">\n<h1>Explanation of the output</h1>\n<p>The following text contains the nodeset of the given Reference before it is canonicalized. There exist four different styles to indicate how a given node is treated.</p>\n<ul>\n<li class=\"INCLUDED\">A node which is in the node set is labeled using the INCLUDED style.</li>\n<li class=\"EXCLUDED\">A node which is <em>NOT</em> in the node set is labeled EXCLUDED style.</li>\n<li class=\"INCLUDEDINCLUSIVENAMESPACE\">A namespace which is in the node set AND in the InclusiveNamespaces PrefixList is labeled using the INCLUDEDINCLUSIVENAMESPACE style.</li>\n<li class=\"EXCLUDEDINCLUSIVENAMESPACE\">A namespace which is in NOT the node set AND in the InclusiveNamespaces PrefixList is labeled using the INCLUDEDINCLUSIVENAMESPACE style.</li>\n</ul>\n<h1>Output</h1>\n<pre>\n<blink>no node set, sorry</blink></pre></body></html>";
            }
            Object n = (Node)this._xpathNodeSet.iterator().next();
            this._doc = XMLUtils.getOwnerDocument((Node)n);
            this._documentElement = this._doc.getDocumentElement();
            try {
                try {
                    this._writer = new StringWriter();
                    this.canonicalizeXPathNodeSet(this._doc);
                    this._writer.close();
                    n = this._writer.toString();
                    Object var3_3 = null;
                    this._xpathNodeSet = null;
                    this._doc = null;
                    this._documentElement = null;
                    this._writer = null;
                    return n;
                }
                catch (IOException ex) {
                    throw new XMLSignatureException("empty", ex);
                }
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this._xpathNodeSet = null;
                this._doc = null;
                this._documentElement = null;
                this._writer = null;
                throw throwable;
            }
        }

        private void canonicalizeXPathNodeSet(Node currentNode) throws XMLSignatureException, IOException {
            short currentNodeType = currentNode.getNodeType();
            boolean currentNodeIsVisible = this._xpathNodeSet.contains(currentNode);
            switch (currentNodeType) {
                default: {
                    break;
                }
                case 2: 
                case 6: 
                case 11: 
                case 12: {
                    throw new XMLSignatureException("empty", new Object[]{"Trying to canonicalizate attribute node"});
                }
                case 9: {
                    this._writer.write(HTMLPrefix);
                    Node currentChild = currentNode.getFirstChild();
                    while (currentChild != null) {
                        this.canonicalizeXPathNodeSet(currentChild);
                        currentChild = currentChild.getNextSibling();
                    }
                    this._writer.write(HTMLSuffix);
                    break;
                }
                case 8: {
                    if (this._xpathNodeSet.contains(currentNode)) {
                        this._writer.write(HTMLIncludePrefix);
                    } else {
                        this._writer.write(HTMLExcludePrefix);
                    }
                    int position = this.getPositionRelativeToDocumentElement(currentNode);
                    if (position == 1) {
                        this._writer.write("\n");
                    }
                    this.outputCommentToWriter((Comment)currentNode);
                    if (position == -1) {
                        this._writer.write("\n");
                    }
                    if (this._xpathNodeSet.contains(currentNode)) {
                        this._writer.write("</span>");
                        break;
                    }
                    this._writer.write("</span>");
                    break;
                }
                case 7: {
                    if (this._xpathNodeSet.contains(currentNode)) {
                        this._writer.write(HTMLIncludePrefix);
                    } else {
                        this._writer.write(HTMLExcludePrefix);
                    }
                    int position = this.getPositionRelativeToDocumentElement(currentNode);
                    if (position == 1) {
                        this._writer.write("\n");
                    }
                    this.outputPItoWriter((ProcessingInstruction)currentNode);
                    if (position == -1) {
                        this._writer.write("\n");
                    }
                    if (this._xpathNodeSet.contains(currentNode)) {
                        this._writer.write("</span>");
                        break;
                    }
                    this._writer.write("</span>");
                    break;
                }
                case 3: 
                case 4: {
                    if (this._xpathNodeSet.contains(currentNode)) {
                        this._writer.write(HTMLIncludePrefix);
                    } else {
                        this._writer.write(HTMLExcludePrefix);
                    }
                    this.outputTextToWriter(currentNode.getNodeValue());
                    Node nextSibling = currentNode.getNextSibling();
                    while (nextSibling != null && (nextSibling.getNodeType() == 3 || nextSibling.getNodeType() == 4)) {
                        this.outputTextToWriter(nextSibling.getNodeValue());
                        nextSibling = nextSibling.getNextSibling();
                    }
                    if (this._xpathNodeSet.contains(currentNode)) {
                        this._writer.write("</span>");
                        break;
                    }
                    this._writer.write("</span>");
                    break;
                }
                case 1: {
                    Element currentElement = (Element)currentNode;
                    if (this._xpathNodeSet.contains(currentNode)) {
                        this._writer.write(HTMLIncludePrefix);
                    } else {
                        this._writer.write(HTMLExcludePrefix);
                    }
                    this._writer.write("&lt;");
                    this._writer.write(currentElement.getTagName());
                    if (this._xpathNodeSet.contains(currentNode)) {
                        this._writer.write("</span>");
                    } else {
                        this._writer.write("</span>");
                    }
                    NamedNodeMap attrs = currentElement.getAttributes();
                    int attrsLength = attrs.getLength();
                    Object[] attrs2 = new Object[attrsLength];
                    int i = 0;
                    while (i < attrsLength) {
                        attrs2[i] = attrs.item(i);
                        ++i;
                    }
                    Object[] attrs3 = C14nHelper.sortAttributes(attrs2);
                    int i2 = 0;
                    while (i2 < attrsLength) {
                        Attr a = (Attr)attrs3[i2];
                        boolean included = this._xpathNodeSet.contains(a);
                        boolean inclusive = this._inclusiveNamespaces.contains(a.getName());
                        if (included) {
                            if (inclusive) {
                                this._writer.write(HTMLIncludedInclusiveNamespacePrefix);
                            } else {
                                this._writer.write(HTMLIncludePrefix);
                            }
                        } else if (inclusive) {
                            this._writer.write(HTMLExcludedInclusiveNamespacePrefix);
                        } else {
                            this._writer.write(HTMLExcludePrefix);
                        }
                        this.outputAttrToWriter(a.getNodeName(), a.getNodeValue());
                        if (included) {
                            if (inclusive) {
                                this._writer.write("</span>");
                            } else {
                                this._writer.write("</span>");
                            }
                        } else if (inclusive) {
                            this._writer.write("</span>");
                        } else {
                            this._writer.write("</span>");
                        }
                        ++i2;
                    }
                    if (this._xpathNodeSet.contains(currentNode)) {
                        this._writer.write(HTMLIncludePrefix);
                    } else {
                        this._writer.write(HTMLExcludePrefix);
                    }
                    this._writer.write("&gt;");
                    if (this._xpathNodeSet.contains(currentNode)) {
                        this._writer.write("</span>");
                    } else {
                        this._writer.write("</span>");
                    }
                    Node currentChild = currentNode.getFirstChild();
                    while (currentChild != null) {
                        this.canonicalizeXPathNodeSet(currentChild);
                        currentChild = currentChild.getNextSibling();
                    }
                    if (this._xpathNodeSet.contains(currentNode)) {
                        this._writer.write(HTMLIncludePrefix);
                    } else {
                        this._writer.write(HTMLExcludePrefix);
                    }
                    this._writer.write("&lt;/");
                    this._writer.write(currentElement.getTagName());
                    this._writer.write("&gt;");
                    if (this._xpathNodeSet.contains(currentNode)) {
                        this._writer.write("</span>");
                        break;
                    }
                    this._writer.write("</span>");
                }
            }
        }

        private int getPositionRelativeToDocumentElement(Node currentNode) {
            if (currentNode == null) {
                return 0;
            }
            Document doc = currentNode.getOwnerDocument();
            if (currentNode.getParentNode() != doc) {
                return 0;
            }
            Element documentElement = doc.getDocumentElement();
            if (documentElement == null) {
                return 0;
            }
            if (documentElement == currentNode) {
                return 0;
            }
            Node x = currentNode;
            while (x != null) {
                if (x == documentElement) {
                    return -1;
                }
                x = x.getNextSibling();
            }
            return 1;
        }

        private void outputAttrToWriter(String name, String value) throws IOException {
            this._writer.write(" ");
            this._writer.write(name);
            this._writer.write("=\"");
            int length = value.length();
            int i = 0;
            while (i < length) {
                char c = value.charAt(i);
                switch (c) {
                    case '&': {
                        this._writer.write("&amp;amp;");
                        break;
                    }
                    case '<': {
                        this._writer.write("&amp;lt;");
                        break;
                    }
                    case '\"': {
                        this._writer.write("&amp;quot;");
                        break;
                    }
                    case '\t': {
                        this._writer.write("&amp;#x9;");
                        break;
                    }
                    case '\n': {
                        this._writer.write("&amp;#xA;");
                        break;
                    }
                    case '\r': {
                        this._writer.write("&amp;#xD;");
                        break;
                    }
                    default: {
                        this._writer.write(c);
                    }
                }
                ++i;
            }
            this._writer.write("\"");
        }

        private void outputPItoWriter(ProcessingInstruction currentPI) throws IOException {
            if (currentPI == null) {
                return;
            }
            this._writer.write("&lt;?");
            String target = currentPI.getTarget();
            int length = target.length();
            int i = 0;
            while (i < length) {
                char c = target.charAt(i);
                switch (c) {
                    case '\r': {
                        this._writer.write("&amp;#xD;");
                        break;
                    }
                    case ' ': {
                        this._writer.write("&middot;");
                        break;
                    }
                    case '\n': {
                        this._writer.write("&para;\n");
                        break;
                    }
                    default: {
                        this._writer.write(c);
                    }
                }
                ++i;
            }
            String data = currentPI.getData();
            length = data.length();
            if (data != null && length > 0) {
                this._writer.write(" ");
                int i2 = 0;
                while (i2 < length) {
                    char c = data.charAt(i2);
                    switch (c) {
                        case '\r': {
                            this._writer.write("&amp;#xD;");
                            break;
                        }
                        default: {
                            this._writer.write(c);
                        }
                    }
                    ++i2;
                }
            }
            this._writer.write("?&gt;");
        }

        private void outputCommentToWriter(Comment currentComment) throws IOException {
            if (currentComment == null) {
                return;
            }
            this._writer.write("&lt;!--");
            String data = currentComment.getData();
            int length = data.length();
            int i = 0;
            while (i < length) {
                char c = data.charAt(i);
                switch (c) {
                    case '\r': {
                        this._writer.write("&amp;#xD;");
                        break;
                    }
                    case ' ': {
                        this._writer.write("&middot;");
                        break;
                    }
                    case '\n': {
                        this._writer.write("&para;\n");
                        break;
                    }
                    default: {
                        this._writer.write(c);
                    }
                }
                ++i;
            }
            this._writer.write("--&gt;");
        }

        private void outputTextToWriter(String text) throws IOException {
            if (text == null) {
                return;
            }
            int length = text.length();
            int i = 0;
            while (i < length) {
                char c = text.charAt(i);
                switch (c) {
                    case '&': {
                        this._writer.write("&amp;amp;");
                        break;
                    }
                    case '<': {
                        this._writer.write("&amp;lt;");
                        break;
                    }
                    case '>': {
                        this._writer.write("&amp;gt;");
                        break;
                    }
                    case '\r': {
                        this._writer.write("&amp;#xD;");
                        break;
                    }
                    case ' ': {
                        this._writer.write("&middot;");
                        break;
                    }
                    case '\n': {
                        this._writer.write("&para;\n");
                        break;
                    }
                    default: {
                        this._writer.write(c);
                    }
                }
                ++i;
            }
        }
    }
}

