/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.signature;

import com.systinet.wasp.security.secext.algorithms.SignatureAlgorithm;
import com.systinet.wasp.security.secext.c14n.CanonicalizationException;
import com.systinet.wasp.security.secext.c14n.Canonicalizer;
import com.systinet.wasp.security.secext.c14n.InvalidCanonicalizerException;
import com.systinet.wasp.security.secext.exceptions.XMLSecurityException;
import com.systinet.wasp.security.secext.signature.Manifest;
import com.systinet.wasp.security.secext.signature.MissingResourceFailureException;
import com.systinet.wasp.security.secext.utils.XMLUtils;
import java.io.IOException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SignedInfo
extends Manifest {
    private SignatureAlgorithm _signatureAlgorithm = null;
    private byte[] _c14nizedBytes = null;

    public SignedInfo(Document doc) throws XMLSecurityException {
        this(doc, "http://www.w3.org/2000/09/xmldsig#dsa-sha1", "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
    }

    public SignedInfo(Document doc, String SignatureMethodURI, String CanonicalizationMethodURI) throws XMLSecurityException {
        this(doc, SignatureMethodURI, 0, CanonicalizationMethodURI);
    }

    public SignedInfo(Document doc, String SignatureMethodURI, int HMACOutputLength, String CanonicalizationMethodURI) throws XMLSecurityException {
        super(doc);
        Element canonElem = XMLUtils.createElementInSignatureSpace(this._doc, "CanonicalizationMethod");
        canonElem.setAttributeNS(null, "Algorithm", CanonicalizationMethodURI);
        this._constructionElement.appendChild(canonElem);
        XMLUtils.addReturnToElement(this._constructionElement);
        this._signatureAlgorithm = HMACOutputLength > 0 ? new SignatureAlgorithm(this._doc, SignatureMethodURI, HMACOutputLength) : new SignatureAlgorithm(this._doc, SignatureMethodURI);
        this._constructionElement.appendChild(this._signatureAlgorithm.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public SignedInfo(Document doc, Element SignatureMethodElem, Element CanonicalizationMethodElem) throws XMLSecurityException {
        super(doc);
        this._constructionElement.appendChild(CanonicalizationMethodElem);
        XMLUtils.addReturnToElement(this._constructionElement);
        this._signatureAlgorithm = new SignatureAlgorithm(SignatureMethodElem, null);
        this._constructionElement.appendChild(this._signatureAlgorithm.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public SignedInfo(Element element, String BaseURI) throws XMLSecurityException {
        super(element, BaseURI);
        Canonicalizer c14nizer = Canonicalizer.getInstance(this.getCanonicalizationMethodURI());
        this._c14nizedBytes = c14nizer.canonicalizeSubtree(this._constructionElement);
        this._constructionElement = element;
        this._signatureAlgorithm = new SignatureAlgorithm(this.getSignatureMethodElement(), this.getBaseURI());
    }

    public boolean verify() throws MissingResourceFailureException, XMLSecurityException {
        return super.verifyReferences(false);
    }

    public boolean verify(boolean followManifests) throws MissingResourceFailureException, XMLSecurityException {
        return super.verifyReferences(followManifests);
    }

    public byte[] getCanonicalizedOctetStream() throws CanonicalizationException, InvalidCanonicalizerException, IOException, XMLSecurityException {
        if (this._c14nizedBytes == null && this._state == 0) {
            Canonicalizer c14nizer = Canonicalizer.getInstance(this.getCanonicalizationMethodURI());
            this._c14nizedBytes = c14nizer.canonicalizeSubtree(this._constructionElement);
        }
        byte[] output = new byte[this._c14nizedBytes.length];
        System.arraycopy(this._c14nizedBytes, 0, output, 0, output.length);
        return output;
    }

    public String getCanonicalizationMethodURI() {
        NodeList children = this._constructionElement.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node n = children.item(i);
            if (n.getNodeType() == 1) {
                boolean found = true;
                try {
                    XMLUtils.guaranteeThatElementInSignatureSpace((Element)n, "CanonicalizationMethod");
                }
                catch (XMLSecurityException ex) {
                    found = false;
                }
                if (found) {
                    return ((Element)n).getAttributeNS(null, "Algorithm");
                }
            }
            ++i;
        }
        return null;
    }

    public String getSignatureMethodURI() {
        Element signatureElement = this.getSignatureMethodElement();
        if (signatureElement != null) {
            return signatureElement.getAttributeNS(null, "Algorithm");
        }
        return null;
    }

    public Element getSignatureMethodElement() {
        NodeList children = this._constructionElement.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node n = children.item(i);
            if (n.getNodeType() == 1) {
                boolean found = true;
                try {
                    XMLUtils.guaranteeThatElementInSignatureSpace((Element)n, "SignatureMethod");
                }
                catch (XMLSecurityException ex) {
                    found = false;
                }
                if (found) {
                    return (Element)n;
                }
            }
            ++i;
        }
        return null;
    }

    public SecretKey createSecretKey(byte[] secretKeyBytes) throws XMLSecurityException {
        return new SecretKeySpec(secretKeyBytes, this._signatureAlgorithm.getJCEAlgorithmString());
    }

    public String getBaseLocalName() {
        return "SignedInfo";
    }
}

