/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.keys.storage.implementations;

import com.idoox.debug.Category;
import com.systinet.wasp.security.secext.keys.content.x509.XMLX509SKI;
import com.systinet.wasp.security.secext.keys.storage.StorageResolverException;
import com.systinet.wasp.security.secext.keys.storage.StorageResolverSpi;
import com.systinet.wasp.security.secext.utils.Base64;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

public class CertsInFilesystemDirectoryResolver
extends StorageResolverSpi {
    static Category cat = Category.getCategory((String)(class$com$systinet$wasp$security$secext$keys$storage$implementations$CertsInFilesystemDirectoryResolver == null ? (class$com$systinet$wasp$security$secext$keys$storage$implementations$CertsInFilesystemDirectoryResolver = CertsInFilesystemDirectoryResolver.class$("com.systinet.wasp.security.secext.keys.storage.implementations.CertsInFilesystemDirectoryResolver")) : class$com$systinet$wasp$security$secext$keys$storage$implementations$CertsInFilesystemDirectoryResolver).getName());
    String _merlinsCertificatesDir = null;
    private Vector _certs = new Vector();
    Iterator _iterator = null;
    static /* synthetic */ Class class$com$systinet$wasp$security$secext$keys$storage$implementations$CertsInFilesystemDirectoryResolver;

    public CertsInFilesystemDirectoryResolver(String directoryName) throws StorageResolverException {
        this._merlinsCertificatesDir = directoryName;
        this.readCertsFromHarddrive();
        this._iterator = new FilesystemIterator(this._certs);
    }

    private void readCertsFromHarddrive() throws StorageResolverException {
        File certDir = new File(this._merlinsCertificatesDir);
        ArrayList<String> al = new ArrayList<String>();
        String[] names = certDir.list();
        int i = 0;
        while (i < names.length) {
            String currentFileName = names[i];
            if (currentFileName.endsWith(".crt")) {
                al.add(names[i]);
            }
            ++i;
        }
        CertificateFactory cf = null;
        try {
            cf = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException ex) {
            throw new StorageResolverException("empty", ex);
        }
        if (cf == null) {
            throw new StorageResolverException("empty", new Object[]{"Cannot get certificate factory for X.509"});
        }
        int i2 = 0;
        while (i2 < al.size()) {
            String filename = certDir.getAbsolutePath() + File.separator + (String)al.get(i2);
            File file = new File(filename);
            boolean added = false;
            String dn = null;
            try {
                FileInputStream fis = new FileInputStream(file);
                X509Certificate cert = (X509Certificate)cf.generateCertificate(fis);
                fis.close();
                cert.checkValidity();
                this._certs.add(cert);
                dn = cert.getSubjectDN().getName();
                added = true;
            }
            catch (FileNotFoundException ex) {
            }
            catch (IOException ex) {
            }
            catch (CertificateNotYetValidException ex) {
            }
            catch (CertificateExpiredException ex) {
            }
            catch (CertificateException ex) {
                // empty catch block
            }
            if (added) {
                // empty if block
            }
            ++i2;
        }
    }

    public Iterator getIterator() {
        return this._iterator;
    }

    public static void main(String[] unused) throws Exception {
        CertsInFilesystemDirectoryResolver krs = new CertsInFilesystemDirectoryResolver("data/ie/baltimore/merlin-examples/merlin-xmldsig-eighteen/certs");
        Iterator i = krs.getIterator();
        while (i.hasNext()) {
            X509Certificate cert = (X509Certificate)i.next();
            byte[] ski = XMLX509SKI.getSKIBytesFromCert(cert);
            System.out.println();
            System.out.println("Base64(SKI())=                 \"" + Base64.encode(ski) + "\"");
            System.out.println("cert.getSerialNumber()=        \"" + cert.getSerialNumber().toString() + "\"");
            System.out.println("cert.getSubjectDN().getName()= \"" + cert.getSubjectDN().getName() + "\"");
            System.out.println("cert.getIssuerDN().getName()=  \"" + cert.getIssuerDN().getName() + "\"");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class FilesystemIterator
    implements Iterator {
        Vector _certs = null;
        int _i;

        public FilesystemIterator(Vector certs) throws StorageResolverException {
            this._certs = certs;
            this._i = 0;
        }

        public boolean hasNext() {
            return this._i < this._certs.size();
        }

        public Object next() {
            return this._certs.elementAt(this._i++);
        }

        public void remove() {
            throw new UnsupportedOperationException("Can't remove keys from KeyStore");
        }
    }
}

