/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.keys.keyresolver.implementations;

import com.idoox.debug.Category;
import com.systinet.wasp.security.secext.exceptions.XMLSecurityException;
import com.systinet.wasp.security.secext.keys.content.X509Data;
import com.systinet.wasp.security.secext.keys.content.x509.XMLX509IssuerSerial;
import com.systinet.wasp.security.secext.keys.keyresolver.KeyResolverException;
import com.systinet.wasp.security.secext.keys.keyresolver.KeyResolverSpi;
import com.systinet.wasp.security.secext.keys.storage.StorageResolver;
import com.systinet.wasp.security.secext.signature.XMLSignatureException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import org.w3c.dom.Element;

public class X509IssuerSerialResolver
extends KeyResolverSpi {
    static Category cat = Category.getCategory((String)(class$com$systinet$wasp$security$secext$keys$keyresolver$implementations$X509IssuerSerialResolver == null ? (class$com$systinet$wasp$security$secext$keys$keyresolver$implementations$X509IssuerSerialResolver = X509IssuerSerialResolver.class$("com.systinet.wasp.security.secext.keys.keyresolver.implementations.X509IssuerSerialResolver")) : class$com$systinet$wasp$security$secext$keys$keyresolver$implementations$X509IssuerSerialResolver).getName());
    static /* synthetic */ Class class$com$systinet$wasp$security$secext$keys$keyresolver$implementations$X509IssuerSerialResolver;

    public boolean engineCanResolve(Element element, String BaseURI, StorageResolver storage) {
        X509Data x509data = null;
        try {
            x509data = new X509Data(element, BaseURI);
        }
        catch (XMLSignatureException ex) {
            return false;
        }
        catch (XMLSecurityException ex) {
            return false;
        }
        if (x509data == null) {
            return false;
        }
        return x509data.containsIssuerSerial();
    }

    public PublicKey engineResolvePublicKey(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        X509Certificate cert = this.engineResolveX509Certificate(element, BaseURI, storage);
        if (cert != null) {
            return cert.getPublicKey();
        }
        return null;
    }

    public X509Certificate engineResolveX509Certificate(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        try {
            if (storage == null) {
                Object[] exArgs = new Object[]{"X509IssuerSerial"};
                KeyResolverException ex = new KeyResolverException("KeyResolver.needStorageResolver", exArgs);
                cat.info("", (Throwable)ex);
                throw ex;
            }
            X509Data x509data = new X509Data(element, BaseURI);
            int noOfISS = x509data.lengthIssuerSerial();
            while (storage.hasNext()) {
                X509Certificate cert = storage.next();
                XMLX509IssuerSerial certSerial = new XMLX509IssuerSerial(element.getOwnerDocument(), cert);
                int i = 0;
                while (i < noOfISS) {
                    XMLX509IssuerSerial xmliss = x509data.itemIssuerSerial(i);
                    if (certSerial.equals(xmliss)) {
                        return cert;
                    }
                    ++i;
                }
            }
            return null;
        }
        catch (XMLSecurityException ex) {
            throw new KeyResolverException("generic.EmptyMessage", ex);
        }
    }

    public SecretKey engineResolveSecretKey(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

