/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.keys.keyresolver.implementations;

import com.idoox.debug.Category;
import com.systinet.wasp.security.secext.exceptions.XMLSecurityException;
import com.systinet.wasp.security.secext.keys.content.RetrievalMethod;
import com.systinet.wasp.security.secext.keys.keyresolver.KeyResolver;
import com.systinet.wasp.security.secext.keys.keyresolver.KeyResolverException;
import com.systinet.wasp.security.secext.keys.keyresolver.KeyResolverSpi;
import com.systinet.wasp.security.secext.keys.storage.StorageResolver;
import com.systinet.wasp.security.secext.signature.XMLSignatureException;
import com.systinet.wasp.security.secext.signature.XMLSignatureInput;
import com.systinet.wasp.security.secext.transforms.Transforms;
import com.systinet.wasp.security.secext.utils.XMLUtils;
import com.systinet.wasp.security.secext.utils.resolver.ResourceResolver;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class RetrievalMethodResolver
extends KeyResolverSpi {
    static Category cat = Category.getCategory((String)(class$com$systinet$wasp$security$secext$keys$keyresolver$implementations$RetrievalMethodResolver == null ? (class$com$systinet$wasp$security$secext$keys$keyresolver$implementations$RetrievalMethodResolver = RetrievalMethodResolver.class$("com.systinet.wasp.security.secext.keys.keyresolver.implementations.RetrievalMethodResolver")) : class$com$systinet$wasp$security$secext$keys$keyresolver$implementations$RetrievalMethodResolver).getName());
    static /* synthetic */ Class class$com$systinet$wasp$security$secext$keys$keyresolver$implementations$RetrievalMethodResolver;

    public boolean engineCanResolve(Element element, String BaseURI, StorageResolver storage) {
        try {
            XMLUtils.guaranteeThatElementInSignatureSpace(element, "RetrievalMethod");
        }
        catch (XMLSignatureException ex) {
            return false;
        }
        return true;
    }

    public PublicKey engineResolvePublicKey(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        try {
            RetrievalMethod rm = new RetrievalMethod(element, BaseURI);
            Attr uri = rm.getURIAttr();
            String type = rm.getType();
            Transforms transforms = rm.getTransforms();
            ResourceResolver resRes = ResourceResolver.getInstance(uri, BaseURI);
            if (resRes != null) {
                XMLSignatureInput resource = resRes.resolve(uri, BaseURI);
                if (transforms != null) {
                    resource = transforms.performTransforms(resource);
                }
                byte[] inputBytes = resource.getBytes();
                if (type != null && type.equals("http://www.w3.org/2000/09/xmldsig#rawX509Certificate")) {
                    CertificateFactory certFact = CertificateFactory.getInstance("X.509");
                    X509Certificate cert = (X509Certificate)certFact.generateCertificate(new ByteArrayInputStream(inputBytes));
                    if (cert != null) {
                        return cert.getPublicKey();
                    }
                } else {
                    KeyResolver newKeyResolver;
                    Element e = this.getDocFromBytes(inputBytes);
                    if (e != null && (newKeyResolver = KeyResolver.getInstance(e, BaseURI, storage)) != null) {
                        return newKeyResolver.resolvePublicKey(e, BaseURI, storage);
                    }
                }
            }
        }
        catch (XMLSecurityException ex) {
        }
        catch (CertificateException ex) {
        }
        catch (IOException ex) {
            // empty catch block
        }
        return null;
    }

    public X509Certificate engineResolveX509Certificate(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        try {
            RetrievalMethod rm = new RetrievalMethod(element, BaseURI);
            Attr uri = rm.getURIAttr();
            String type = rm.getType();
            Transforms transforms = rm.getTransforms();
            ResourceResolver resRes = ResourceResolver.getInstance(uri, BaseURI);
            if (resRes != null) {
                XMLSignatureInput resource = resRes.resolve(uri, BaseURI);
                if (transforms != null) {
                    resource = transforms.performTransforms(resource);
                }
                byte[] inputBytes = resource.getBytes();
                if (rm.getType() != null && rm.getType().equals("http://www.w3.org/2000/09/xmldsig#rawX509Certificate")) {
                    CertificateFactory certFact = CertificateFactory.getInstance("X.509");
                    X509Certificate cert = (X509Certificate)certFact.generateCertificate(new ByteArrayInputStream(inputBytes));
                    if (cert != null) {
                        return cert;
                    }
                } else {
                    KeyResolver newKeyResolver;
                    Element e = this.getDocFromBytes(inputBytes);
                    if (e != null && (newKeyResolver = KeyResolver.getInstance(e, BaseURI, storage)) != null) {
                        return newKeyResolver.resolveX509Certificate(e, BaseURI, storage);
                    }
                }
            }
        }
        catch (XMLSecurityException ex) {
        }
        catch (CertificateException ex) {
        }
        catch (IOException ex) {
            // empty catch block
        }
        return null;
    }

    Element getDocFromBytes(byte[] bytes) throws KeyResolverException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new ByteArrayInputStream(bytes));
            return doc.getDocumentElement();
        }
        catch (SAXException ex) {
            throw new KeyResolverException("empty", ex);
        }
        catch (IOException ex) {
            throw new KeyResolverException("empty", ex);
        }
        catch (ParserConfigurationException ex) {
            throw new KeyResolverException("empty", ex);
        }
    }

    public SecretKey engineResolveSecretKey(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

