/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.encryption;

import com.idoox.debug.Category;
import com.systinet.wasp.security.secext.encryption.AgreementMethod;
import com.systinet.wasp.security.secext.encryption.CipherData;
import com.systinet.wasp.security.secext.encryption.CipherReference;
import com.systinet.wasp.security.secext.encryption.CipherValue;
import com.systinet.wasp.security.secext.encryption.EncryptedData;
import com.systinet.wasp.security.secext.encryption.EncryptedKey;
import com.systinet.wasp.security.secext.encryption.EncryptionMethod;
import com.systinet.wasp.security.secext.encryption.EncryptionProperties;
import com.systinet.wasp.security.secext.encryption.EncryptionProperty;
import com.systinet.wasp.security.secext.encryption.Reference;
import com.systinet.wasp.security.secext.encryption.ReferenceList;
import com.systinet.wasp.security.secext.encryption.Transforms;
import com.systinet.wasp.security.secext.encryption.XMLEncryptionException;
import com.systinet.wasp.security.secext.exceptions.XMLSecurityException;
import com.systinet.wasp.security.secext.keys.KeyInfo;
import com.systinet.wasp.security.secext.transforms.Transform;
import com.systinet.wasp.security.secext.utils.ElementProxy;
import com.systinet.wasp.security.secext.utils.XMLUtils;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.apache.xml.utils.URI;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class XMLCipher {
    private static final Category logger = Category.getCategory((String)(class$com$systinet$wasp$security$secext$encryption$XMLCipher == null ? (class$com$systinet$wasp$security$secext$encryption$XMLCipher = XMLCipher.class$("com.systinet.wasp.security.secext.encryption.XMLCipher")) : class$com$systinet$wasp$security$secext$encryption$XMLCipher).getName());
    public static final String TRIPLEDES = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
    public static final String AES_128 = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
    public static final String AES_256 = "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
    public static final String AES_192 = "http://www.w3.org/2001/04/xmlenc#aes192-cbc";
    public static final String RSA_v1dot5 = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
    public static final String RSA_OAEP = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
    public static final String DIFFIE_HELLMAN = "http://www.w3.org/2001/04/xmlenc#dh";
    public static final String TRIPLEDES_KeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-tripledes";
    public static final String AES_128_KeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes128";
    public static final String AES_256_KeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes256";
    public static final String AES_192_KeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes192";
    public static final String SHA1 = "http://www.w3.org/2000/09/xmldsig#sha1";
    public static final String SHA256 = "http://www.w3.org/2001/04/xmlenc#sha256";
    public static final String SHA512 = "http://www.w3.org/2001/04/xmlenc#sha512";
    public static final String RIPEMD_160 = "http://www.w3.org/2001/04/xmlenc#ripemd160";
    public static final String XML_DSIG = "http://www.w3.org/2000/09/xmldsig#";
    public static final String N14C_XML = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    public static final String N14C_XML_WITH_COMMENTS = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments";
    public static final String EXCL_XML_N14C = "http://www.w3.org/2001/10/xml-exc-c14n#";
    public static final String EXCL_XML_N14C_WITH_COMMENTS = "http://www.w3.org/2001/10/xml-exc-c14n#WithComments";
    public static final String BASE64_ENCODING = "http://www.w3.org/2000/09/xmldsig#base64";
    public static final int ENCRYPT_MODE = 1;
    public static final int DECRYPT_MODE = 2;
    public static final int UNWRAP_MODE = 4;
    public static final int WRAP_MODE = 3;
    private static XMLCipher instance = null;
    private static final String ENC_ALGORITHMS = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc\nhttp://www.w3.org/2001/04/xmlenc#aes128-cbc\nhttp://www.w3.org/2001/04/xmlenc#aes256-cbc\nhttp://www.w3.org/2001/04/xmlenc#aes192-cbc\nhttp://www.w3.org/2001/04/xmlenc#rsa-1_5\nhttp://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p\nhttp://www.w3.org/2001/04/xmlenc#kw-tripledes\nhttp://www.w3.org/2001/04/xmlenc#kw-aes128\nhttp://www.w3.org/2001/04/xmlenc#kw-aes256\nhttp://www.w3.org/2001/04/xmlenc#kw-aes192\n";
    private static final String ALGORITHMS = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc\nhttp://www.w3.org/2001/04/xmlenc#aes128-cbc\nhttp://www.w3.org/2001/04/xmlenc#aes256-cbc\nhttp://www.w3.org/2001/04/xmlenc#aes192-cbc\nhttp://www.w3.org/2001/04/xmlenc#rsa-1_5\nhttp://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p\nhttp://www.w3.org/2001/04/xmlenc#dh\nhttp://www.w3.org/2001/04/xmlenc#kw-tripledes\nhttp://www.w3.org/2001/04/xmlenc#kw-aes128\nhttp://www.w3.org/2001/04/xmlenc#kw-aes256\nhttp://www.w3.org/2001/04/xmlenc#kw-aes192\nhttp://www.w3.org/2000/09/xmldsig#sha1\nhttp://www.w3.org/2001/04/xmlenc#sha256\nhttp://www.w3.org/2001/04/xmlenc#sha512\nhttp://www.w3.org/2001/04/xmlenc#ripemd160\nhttp://www.w3.org/2000/09/xmldsig#\nhttp://www.w3.org/TR/2001/REC-xml-c14n-20010315\nhttp://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments\nhttp://www.w3.org/2001/10/xml-exc-c14n#\nhttp://www.w3.org/2001/10/xml-exc-c14n#WithComments";
    private Cipher contextCipher;
    private int cipherMode = Integer.MIN_VALUE;
    private String algorithm;
    private Document contextDocument;
    private Factory factory;
    private Serializer serializer;
    private Map enc2JCE;
    static /* synthetic */ Class class$com$systinet$wasp$security$secext$encryption$XMLCipher;

    private XMLCipher() {
        logger.debug("Constructing XMLCipher...");
        this.factory = new Factory();
        this.serializer = new Serializer();
        this.enc2JCE = new HashMap();
        this.enc2JCE.put(TRIPLEDES, "DESede");
        this.enc2JCE.put(AES_128, "AES");
        this.enc2JCE.put(AES_256, "AES");
        this.enc2JCE.put(AES_192, "AES");
        this.enc2JCE.put(RSA_v1dot5, "RSA/ECB/PKCS1Padding");
        this.enc2JCE.put(RSA_OAEP, "RSA/ECB/OAEPPadding");
        this.enc2JCE.put(TRIPLEDES_KeyWrap, "DESede");
        this.enc2JCE.put(AES_128_KeyWrap, "AES");
        this.enc2JCE.put(AES_256_KeyWrap, "AES");
        this.enc2JCE.put(AES_192_KeyWrap, "AES");
    }

    private static boolean isValidEncryptionAlgorithm(String algorithm) {
        boolean result = algorithm.equals(TRIPLEDES) || algorithm.equals(AES_128) || algorithm.equals(AES_256) || algorithm.equals(AES_192) || algorithm.equals(RSA_v1dot5) || algorithm.equals(RSA_OAEP) || algorithm.equals(TRIPLEDES_KeyWrap) || algorithm.equals(AES_128_KeyWrap) || algorithm.equals(AES_256_KeyWrap) || algorithm.equals(AES_192_KeyWrap);
        return result;
    }

    public static XMLCipher getInstance(String transformation) throws XMLEncryptionException {
        logger.debug("Getting XMLCipher...");
        logger.assertLog(null != transformation, "Transformation unexpectedly null...");
        logger.assertLog(XMLCipher.isValidEncryptionAlgorithm(transformation), "Alogorithm unvalid, expected one of http://www.w3.org/2001/04/xmlenc#tripledes-cbc\nhttp://www.w3.org/2001/04/xmlenc#aes128-cbc\nhttp://www.w3.org/2001/04/xmlenc#aes256-cbc\nhttp://www.w3.org/2001/04/xmlenc#aes192-cbc\nhttp://www.w3.org/2001/04/xmlenc#rsa-1_5\nhttp://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p\nhttp://www.w3.org/2001/04/xmlenc#kw-tripledes\nhttp://www.w3.org/2001/04/xmlenc#kw-aes128\nhttp://www.w3.org/2001/04/xmlenc#kw-aes256\nhttp://www.w3.org/2001/04/xmlenc#kw-aes192\n");
        if (null == instance) {
            instance = new XMLCipher();
        }
        XMLCipher.instance.algorithm = transformation;
        try {
            String jceAlgorithm = (String)XMLCipher.instance.enc2JCE.get(transformation);
            XMLCipher.instance.contextCipher = Cipher.getInstance(jceAlgorithm);
            logger.debug("cihper.algoritm = " + XMLCipher.instance.contextCipher.getAlgorithm());
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new XMLEncryptionException("empty", nsae);
        }
        catch (NoSuchPaddingException nspe) {
            throw new XMLEncryptionException("empty", nspe);
        }
        return instance;
    }

    public static XMLCipher getInstance(String transformation, String provider) throws XMLEncryptionException {
        logger.debug("Getting XMLCipher...");
        logger.assertLog(null != transformation, "Transformation unexpectedly null...");
        logger.assertLog(null != provider, "Provider unexpectedly null..");
        logger.assertLog("" != provider, "Provider's value unexpectedly not specified...");
        logger.assertLog(XMLCipher.isValidEncryptionAlgorithm(transformation), "Alogorithm unvalid, expected one of http://www.w3.org/2001/04/xmlenc#tripledes-cbc\nhttp://www.w3.org/2001/04/xmlenc#aes128-cbc\nhttp://www.w3.org/2001/04/xmlenc#aes256-cbc\nhttp://www.w3.org/2001/04/xmlenc#aes192-cbc\nhttp://www.w3.org/2001/04/xmlenc#rsa-1_5\nhttp://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p\nhttp://www.w3.org/2001/04/xmlenc#kw-tripledes\nhttp://www.w3.org/2001/04/xmlenc#kw-aes128\nhttp://www.w3.org/2001/04/xmlenc#kw-aes256\nhttp://www.w3.org/2001/04/xmlenc#kw-aes192\n");
        if (null == instance) {
            instance = new XMLCipher();
        }
        XMLCipher.instance.algorithm = transformation;
        try {
            String jceAlgorithm = (String)XMLCipher.instance.enc2JCE.get(transformation);
            XMLCipher.instance.contextCipher = Cipher.getInstance(jceAlgorithm, provider);
            logger.debug("cipher.algorithm = " + XMLCipher.instance.contextCipher.getAlgorithm());
            logger.debug("provider.name = " + provider);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new XMLEncryptionException("empty", nsae);
        }
        catch (NoSuchProviderException nspre) {
            throw new XMLEncryptionException("empty", nspre);
        }
        catch (NoSuchPaddingException nspe) {
            throw new XMLEncryptionException("empty", nspe);
        }
        return instance;
    }

    public void init(int opmode, Key key) throws XMLEncryptionException {
        logger.debug("Initializing XMLCipher...");
        logger.assertLog(opmode == 1 || opmode == 2, "Mode unexpectedly invalid...");
        logger.debug("opmode = " + (opmode == 1 ? "ENCRYPT_MODE" : "DECRYPT_MODE"));
        this.cipherMode = opmode;
        try {
            this.contextCipher.init(opmode, key);
        }
        catch (InvalidKeyException ike) {
            throw new XMLEncryptionException("empty", ike);
        }
    }

    private Document encryptElement(Element element) throws XMLEncryptionException {
        logger.debug("Encrypting element...");
        logger.assertLog(null != element, "Element unexpectedly null...");
        logger.assertLog(this.cipherMode == 1, "XMLCipher unexpectedly not in ENCRYPT_MODE...");
        String serializedOctets = this.serializer.serialize(element);
        logger.debug("Serialized octets:\n" + serializedOctets);
        byte[] encryptedBytes = null;
        try {
            encryptedBytes = this.contextCipher.doFinal(serializedOctets.getBytes());
            logger.debug("Expected cipher.outputSize = " + Integer.toString(this.contextCipher.getOutputSize(serializedOctets.getBytes().length)));
            logger.debug("Actual cipher.outputSize = " + Integer.toString(encryptedBytes.length));
        }
        catch (IllegalStateException ise) {
            throw new XMLEncryptionException("empty", ise);
        }
        catch (IllegalBlockSizeException ibse) {
            throw new XMLEncryptionException("empty", ibse);
        }
        catch (BadPaddingException bpe) {
            throw new XMLEncryptionException("empty", bpe);
        }
        String base64EncodedEncryptedOctets = new BASE64Encoder().encode(encryptedBytes);
        logger.debug("Encrypted octets:\n" + base64EncodedEncryptedOctets);
        logger.debug("Encrypted octets length = " + base64EncodedEncryptedOctets.length());
        EncryptedData data = this.createEncryptedData(1, base64EncodedEncryptedOctets);
        try {
            data.setType(new URI("http://www.w3.org/2001/04/xmlenc#Element").toString());
            EncryptionMethod method = this.factory.newEncryptionMethod(new URI(this.algorithm).toString());
            data.setEncryptionMethod(method);
        }
        catch (URI.MalformedURIException mfue) {
            throw new XMLEncryptionException("empty", (Exception)((Object)mfue));
        }
        Element encryptedElement = this.factory.toElement(data);
        Node sourceParent = element.getParentNode();
        sourceParent.replaceChild(encryptedElement, element);
        return this.contextDocument;
    }

    private Document encryptElementContent(Element element) throws XMLEncryptionException {
        logger.debug("Encrypting element content...");
        logger.assertLog(null != element, "Element unexpectedly null...");
        logger.assertLog(this.cipherMode == 1, "XMLCipher unexpectedly not in ENCRYPT_MODE...");
        NodeList children = element.getChildNodes();
        String serializedOctets = null;
        if (null == children) {
            Object[] exArgs = new Object[]{"Element has no content."};
            throw new XMLEncryptionException("empty", exArgs);
        }
        serializedOctets = this.serializer.serialize(children);
        logger.debug("Serialized octets:\n" + serializedOctets);
        byte[] encryptedBytes = null;
        try {
            encryptedBytes = this.contextCipher.doFinal(serializedOctets.getBytes());
            logger.debug("Expected cipher.outputSize = " + Integer.toString(this.contextCipher.getOutputSize(serializedOctets.getBytes().length)));
            logger.debug("Actual cipher.outputSize = " + Integer.toString(encryptedBytes.length));
        }
        catch (IllegalStateException ise) {
            throw new XMLEncryptionException("empty", ise);
        }
        catch (IllegalBlockSizeException ibse) {
            throw new XMLEncryptionException("empty", ibse);
        }
        catch (BadPaddingException bpe) {
            throw new XMLEncryptionException("empty", bpe);
        }
        String base64EncodedEncryptedOctets = new BASE64Encoder().encode(encryptedBytes);
        logger.debug("Encrypted octets:\n" + base64EncodedEncryptedOctets);
        logger.debug("Encrypted octets length = " + base64EncodedEncryptedOctets.length());
        EncryptedData data = this.createEncryptedData(1, base64EncodedEncryptedOctets);
        try {
            data.setType(new URI("http://www.w3.org/2001/04/xmlenc#Content").toString());
            EncryptionMethod method = this.factory.newEncryptionMethod(new URI(this.algorithm).toString());
            data.setEncryptionMethod(method);
        }
        catch (URI.MalformedURIException mfue) {
            throw new XMLEncryptionException("empty", (Exception)((Object)mfue));
        }
        Element encryptedElement = this.factory.toElement(data);
        this.removeContent(element);
        element.appendChild(encryptedElement);
        return this.contextDocument;
    }

    public Document doFinal(Document context, Document source) throws XMLEncryptionException {
        logger.debug("Processing source document...");
        logger.assertLog(null != context, "Context document unexpectedly null...");
        logger.assertLog(null != source, "Source document unexpectedly null...");
        XMLCipher.instance.contextDocument = context;
        Document result = null;
        switch (this.cipherMode) {
            case 2: {
                result = this.decryptElement(source.getDocumentElement());
                break;
            }
            case 1: {
                result = this.encryptElement(source.getDocumentElement());
                break;
            }
            case 4: {
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new XMLEncryptionException("empty", new IllegalStateException());
            }
        }
        return result;
    }

    public Document doFinal(Document context, Element element) throws XMLEncryptionException {
        logger.debug("Processing source element...");
        logger.assertLog(null != context, "Context document unexpectedly null...");
        logger.assertLog(null != element, "Source element unexpectedly null...");
        XMLCipher.instance.contextDocument = context;
        Document result = null;
        switch (this.cipherMode) {
            case 2: {
                result = this.decryptElement(element);
                break;
            }
            case 1: {
                result = this.encryptElement(element);
                break;
            }
            case 4: {
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new XMLEncryptionException("empty", new IllegalStateException());
            }
        }
        return result;
    }

    public Document doFinal(Document context, Element element, boolean content) throws XMLEncryptionException {
        logger.debug("Processing source element...");
        logger.assertLog(null != context, "Context document unexpectedly null...");
        logger.assertLog(null != element, "Source element unexpectedly null...");
        XMLCipher.instance.contextDocument = context;
        Document result = null;
        switch (this.cipherMode) {
            case 2: {
                if (content) break;
                result = this.decryptElement(element);
                break;
            }
            case 1: {
                if (content) {
                    result = this.encryptElementContent(element);
                    break;
                }
                result = this.encryptElement(element);
                break;
            }
            case 4: {
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new XMLEncryptionException("empty", new IllegalStateException());
            }
        }
        return null;
    }

    private Document doFinal(Document context, NodeList elements) throws XMLEncryptionException {
        return null;
    }

    private Document doFinal(String xpathExpression) throws XMLEncryptionException {
        return null;
    }

    private Document doFinal(Document context, Element element, EncryptedData data) throws XMLEncryptionException {
        return null;
    }

    private Document doFinal(Document context, Element element, EncryptedKey key) throws XMLEncryptionException {
        return null;
    }

    public EncryptedData encryptData(Document context, Element element) throws XMLEncryptionException {
        logger.debug("Encrypting element...");
        logger.assertLog(null != context, "Context document unexpectedly null...");
        logger.assertLog(null != element, "Element unexpectedly null...");
        logger.assertLog(this.cipherMode == 1, "XMLCipher unexpectedly not in ENCRYPT_MODE...");
        XMLCipher.instance.contextDocument = context;
        String serializedOctets = this.serializer.serialize(element);
        logger.debug("Serialized octets:\n" + serializedOctets);
        byte[] encryptedBytes = null;
        try {
            encryptedBytes = this.contextCipher.doFinal(serializedOctets.getBytes());
            logger.debug("Expected cipher.outputSize = " + Integer.toString(this.contextCipher.getOutputSize(serializedOctets.getBytes().length)));
            logger.debug("Actual cipher.outputSize = " + Integer.toString(encryptedBytes.length));
        }
        catch (IllegalStateException ise) {
            throw new XMLEncryptionException("empty", ise);
        }
        catch (IllegalBlockSizeException ibse) {
            throw new XMLEncryptionException("empty", ibse);
        }
        catch (BadPaddingException bpe) {
            throw new XMLEncryptionException("empty", bpe);
        }
        String base64EncodedEncryptedOctets = new BASE64Encoder().encode(encryptedBytes);
        logger.debug("Encrypted octets:\n" + base64EncodedEncryptedOctets);
        logger.debug("Encrypted octets length = " + base64EncodedEncryptedOctets.length());
        EncryptedData data = this.createEncryptedData(1, base64EncodedEncryptedOctets);
        try {
            data.setType(new URI("http://www.w3.org/2001/04/xmlenc#Element").toString());
            EncryptionMethod method = this.factory.newEncryptionMethod(new URI(this.algorithm).toString());
            data.setEncryptionMethod(method);
        }
        catch (URI.MalformedURIException mfue) {
            throw new XMLEncryptionException("empty", (Exception)((Object)mfue));
        }
        return data;
    }

    public EncryptedKey encryptKey(Document context, Element element) throws XMLEncryptionException {
        return null;
    }

    public static Factory getFactory(Document contextDocument) {
        XMLCipher cipher = new XMLCipher();
        cipher.contextDocument = contextDocument;
        return cipher.factory;
    }

    public static String serialize(Element element, boolean content) throws XMLEncryptionException {
        XMLCipher cipher = new XMLCipher();
        if (content) {
            Document doc = element.getOwnerDocument();
            DocumentFragment df = doc.createDocumentFragment();
            NodeList nl = element.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                Node n = nl.item(i).cloneNode(true);
                df.appendChild(n);
                ++i;
            }
            return cipher.serializer.serialize(df);
        }
        return cipher.serializer.serialize(element);
    }

    private void removeContent(Node node) {
        NodeList list = node.getChildNodes();
        if (list.getLength() > 0) {
            Node n = list.item(0);
            if (null != n) {
                n.getParentNode().removeChild(n);
            }
            this.removeContent(node);
        }
    }

    private Document decryptElement(Element element) throws XMLEncryptionException {
        logger.debug("Decrypting element...");
        logger.assertLog(this.cipherMode == 2, "XMLCipher unexpectedly not in DECRYPT_MODE...");
        EncryptedData encryptedData = this.factory.newEncryptedData(element);
        CipherData cipherData = encryptedData.getCipherData();
        String base64EncodedEncryptedOctets = null;
        if (cipherData.getDataType() != 2 && cipherData.getDataType() == 1) {
            CipherValue cipherValue = cipherData.getCipherValue();
            base64EncodedEncryptedOctets = new String(cipherValue.getValue());
        }
        logger.debug("Encrypted octets:\n" + base64EncodedEncryptedOctets);
        byte[] encryptedBytes = null;
        try {
            encryptedBytes = new BASE64Decoder().decodeBuffer(base64EncodedEncryptedOctets);
        }
        catch (IOException ioe) {
            throw new XMLEncryptionException("empty", ioe);
        }
        String octets = null;
        try {
            octets = new String(this.contextCipher.doFinal(encryptedBytes));
        }
        catch (IllegalBlockSizeException ibse) {
            throw new XMLEncryptionException("empty", ibse);
        }
        catch (BadPaddingException bpe) {
            throw new XMLEncryptionException("empty", bpe);
        }
        logger.debug("Decrypted octets:\n" + octets);
        Element decryptedElement = this.serializer.deserialize(octets);
        Node sourceParent = element.getParentNode();
        sourceParent.replaceChild(decryptedElement, element);
        return this.contextDocument;
    }

    private EncryptedData createEncryptedData(int type, String value) throws XMLEncryptionException {
        EncryptedData result = null;
        CipherData data = null;
        switch (type) {
            case 2: {
                String referenceUri = null;
                try {
                    referenceUri = new URI(value).toString();
                }
                catch (URI.MalformedURIException mfue) {
                    throw new XMLEncryptionException("empty", (Exception)((Object)mfue));
                }
                CipherReference cipherReference = this.factory.newCipherReference(referenceUri);
                data = this.factory.newCipherData(type);
                data.setCipherReference(cipherReference);
                result = this.factory.newEncryptedData(data);
            }
            case 1: {
                CipherValue cipherValue = this.factory.newCipherValue(value);
                data = this.factory.newCipherData(type);
                data.setCipherValue(cipherValue);
                result = this.factory.newEncryptedData(data);
            }
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class Factory {
        public AgreementMethod newAgreementMethod(String algorithm) throws XMLEncryptionException {
            return new AgreementMethodImpl(algorithm);
        }

        public CipherData newCipherData(int type) {
            return new CipherDataImpl(type);
        }

        public CipherReference newCipherReference(String uri) throws XMLEncryptionException {
            return new CipherReferenceImpl(uri);
        }

        public CipherValue newCipherValue(String value) {
            return new CipherValueImpl(value);
        }

        public CipherValue newCipherValue(byte[] value) {
            return new CipherValueImpl(value);
        }

        public EncryptedData newEncryptedData(CipherData data) {
            return new EncryptedDataImpl(data);
        }

        public EncryptedKey newEncryptedKey(CipherData data) {
            return new EncryptedKeyImpl(data);
        }

        public EncryptionMethod newEncryptionMethod(String algorithm) throws XMLEncryptionException {
            return new EncryptionMethodImpl(algorithm);
        }

        public EncryptionProperties newEncryptionProperties() {
            return new EncryptionPropertiesImpl();
        }

        public EncryptionProperty newEncryptionProperty() {
            return new EncryptionPropertyImpl();
        }

        public ReferenceList newReferenceList() {
            return new ReferenceList();
        }

        public Transforms newTransforms() {
            return new TransformsImpl();
        }

        public AgreementMethod newAgreementMethod(Element element) throws XMLEncryptionException {
            Element recipientKeyInfoElement;
            Element originatorKeyInfoElement;
            if (null == element) {
                // empty if block
            }
            String algorithm = element.getAttributeNS(null, "Algorithm");
            AgreementMethod result = this.newAgreementMethod(algorithm);
            Element kaNonceElement = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "KA-Nonce").item(0);
            if (null != kaNonceElement) {
                result.setKANonce(kaNonceElement.getNodeValue().getBytes());
            }
            if (null != (originatorKeyInfoElement = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "OriginatorKeyInfo").item(0))) {
                result.setOriginatorKeyInfo(null);
            }
            if (null != (recipientKeyInfoElement = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "RecipientKeyInfo").item(0))) {
                result.setRecipientKeyInfo(null);
            }
            return result;
        }

        public CipherData newCipherData(Element element) throws XMLEncryptionException {
            if (null == element) {
                // empty if block
            }
            int type = 0;
            Element e = null;
            if (element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherValue").getLength() > 0) {
                type = 1;
                e = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherValue").item(0);
            } else if (element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherReference").getLength() > 0) {
                type = 2;
                e = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherReference").item(0);
            }
            CipherData result = this.newCipherData(type);
            if (type == 1) {
                result.setCipherValue(this.newCipherValue(e));
            } else if (type == 2) {
                // empty if block
            }
            return result;
        }

        public CipherReference newCipherReference(Element element) throws XMLEncryptionException {
            String uo = "This operation is not implemented in this release.";
            throw new XMLEncryptionException("empty", new UnsupportedOperationException(uo));
        }

        public CipherValue newCipherValue(Element element) throws XMLEncryptionException {
            String value = element.getFirstChild().getNodeValue();
            CipherValue result = this.newCipherValue(value);
            return result;
        }

        public EncryptedData newEncryptedData(Element element) throws XMLEncryptionException {
            Element encryptionPropertiesElement;
            Element keyInfoElement;
            EncryptedData result = null;
            Element dataElement = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherData").item(0);
            CipherData data = this.newCipherData(dataElement);
            result = this.newEncryptedData(data);
            try {
                result.setId(element.getAttributeNS(null, "Id"));
                result.setType(new URI(element.getAttributeNS(null, "Type")).toString());
                result.setMimeType(element.getAttributeNS(null, "MimeType"));
                result.setEncoding(new URI(element.getAttributeNS(null, "Encoding")).toString());
            }
            catch (URI.MalformedURIException mfue) {
                // empty catch block
            }
            Element encryptionMethodElement = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptionMethod").item(0);
            if (null != encryptionMethodElement) {
                result.setEncryptionMethod(this.newEncryptionMethod(encryptionMethodElement));
            }
            if (null != (keyInfoElement = (Element)element.getElementsByTagNameNS(XMLCipher.XML_DSIG, "KeyInfo").item(0))) {
                try {
                    result.setKeyInfo(new KeyInfo(keyInfoElement, ""));
                }
                catch (XMLSecurityException e) {
                    // empty catch block
                }
            }
            if (null != (encryptionPropertiesElement = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptionProperties").item(0))) {
                result.setEncryptionProperties(this.newEncryptionProperties(encryptionPropertiesElement));
            }
            return result;
        }

        public EncryptedKey newEncryptedKey(Element element) throws XMLEncryptionException {
            Element carriedNameElement;
            Element referenceListElement;
            Element encryptionPropertiesElement;
            Element keyInfoElement;
            EncryptedKey result = null;
            Element dataElement = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherData").item(0);
            CipherData data = this.newCipherData(dataElement);
            result = this.newEncryptedKey(data);
            result.setId(element.getAttributeNS(null, "Id"));
            try {
                result.setType(new URI(element.getAttributeNS(null, "Type")).toString());
            }
            catch (URI.MalformedURIException mfue) {
                // empty catch block
            }
            result.setMimeType(element.getAttributeNS(null, "MimeType"));
            try {
                result.setEncoding(new URI(element.getAttributeNS(null, "Encoding")).toString());
            }
            catch (URI.MalformedURIException mfue) {
                // empty catch block
            }
            result.setRecipient(element.getAttributeNS(null, "Recipient"));
            Element encryptionMethodElement = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptionMethod").item(0);
            if (null != encryptionMethodElement) {
                result.setEncryptionMethod(this.newEncryptionMethod(encryptionMethodElement));
            }
            if (null != (keyInfoElement = (Element)element.getElementsByTagNameNS(XMLCipher.XML_DSIG, "KeyInfo").item(0))) {
                try {
                    result.setKeyInfo(new KeyInfo(keyInfoElement, ""));
                }
                catch (XMLSecurityException e) {
                    // empty catch block
                }
            }
            if (null != (encryptionPropertiesElement = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptionProperties").item(0))) {
                result.setEncryptionProperties(this.newEncryptionProperties(encryptionPropertiesElement));
            }
            if (null != (referenceListElement = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "ReferenceList").item(0))) {
                result.setReferenceList(this.newReferenceList(referenceListElement));
            }
            if (null != (carriedNameElement = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CarriedKeyName").item(0))) {
                result.setCarriedName(carriedNameElement.getNodeValue());
            }
            return result;
        }

        public EncryptionMethod newEncryptionMethod(Element element) throws XMLEncryptionException {
            Element oaepDigestElement;
            Element oaepParamsElement;
            String algorithm = element.getAttributeNS(null, "Algorithm");
            EncryptionMethod result = this.newEncryptionMethod(algorithm);
            Element keySizeElement = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "KeySize").item(0);
            if (null != keySizeElement) {
                result.setKeySize(Integer.valueOf(keySizeElement.getNodeValue()));
            }
            if (null != (oaepParamsElement = (Element)element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "OAEPparams").item(0))) {
                result.setOAEPparams(XMLUtils.getFullTextChildrenFromElement(oaepParamsElement).getBytes());
            }
            if ((oaepDigestElement = (Element)element.getElementsByTagNameNS(XMLCipher.XML_DSIG, "DigestMethod").item(0)) != null) {
                result.setOAEPDigestAlgorithm(oaepDigestElement.getAttributeNS(null, "Algorithm"));
            }
            return result;
        }

        public EncryptionProperties newEncryptionProperties(Element element) throws XMLEncryptionException {
            EncryptionProperties result = this.newEncryptionProperties();
            result.setId(element.getAttributeNS(null, "Id"));
            NodeList encryptionPropertyList = element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptionProperty");
            int i = 0;
            while (i < encryptionPropertyList.getLength()) {
                Node n = encryptionPropertyList.item(i);
                if (null != n) {
                    result.addEncryptionProperty(this.newEncryptionProperty((Element)n));
                }
                ++i;
            }
            return result;
        }

        public EncryptionProperty newEncryptionProperty(Element element) throws XMLEncryptionException {
            EncryptionProperty result = this.newEncryptionProperty();
            try {
                result.setTarget(new URI(element.getAttributeNS(null, "Target")).toString());
            }
            catch (URI.MalformedURIException malformedURIException) {
                // empty catch block
            }
            result.setId(element.getAttributeNS(null, "Id"));
            return result;
        }

        public ReferenceList newReferenceList(Element element) throws XMLEncryptionException {
            if (null == element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "DataReference").item(0) && null == element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "KeyReference").item(0)) {
                throw new XMLEncryptionException("unknown element reference type");
            }
            ReferenceList result = this.newReferenceList();
            NodeList list = element.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                Node child = list.item(i);
                if (child.getNodeType() == 1 && child.getNamespaceURI().equals("http://www.w3.org/2001/04/xmlenc#")) {
                    Element elchild = (Element)child;
                    if ("DataReference".equals(elchild.getLocalName())) {
                        result.add(ReferenceList.newDataReference(elchild.getAttributeNS(null, "URI")));
                    } else if ("KeyReference".equals(elchild.getLocalName())) {
                        result.add(ReferenceList.newKeyReference(elchild.getAttributeNS(null, "URI")));
                    } else {
                        throw new XMLEncryptionException("unknown element reference type");
                    }
                }
                ++i;
            }
            return result;
        }

        public Transforms newTransforms(Element element) {
            return null;
        }

        public Element toElement(AgreementMethod agreementMethod) {
            return ((AgreementMethodImpl)agreementMethod).toElement();
        }

        public Element toElement(CipherData cipherData) {
            return ((CipherDataImpl)cipherData).toElement();
        }

        public Element toElement(CipherReference cipherReference) {
            return ((CipherReferenceImpl)cipherReference).toElement();
        }

        public Element toElement(CipherValue cipherValue) {
            return ((CipherValueImpl)cipherValue).toElement();
        }

        public Element toElement(EncryptedData encryptedData) {
            return ((EncryptedDataImpl)encryptedData).toElement();
        }

        public Element toElement(EncryptedKey encryptedKey) {
            return ((EncryptedKeyImpl)encryptedKey).toElement();
        }

        public Element toElement(EncryptionMethod encryptionMethod) {
            return ((EncryptionMethodImpl)encryptionMethod).toElement();
        }

        public Element toElement(EncryptionProperties encryptionProperties) {
            return ((EncryptionPropertiesImpl)encryptionProperties).toElement();
        }

        public Element toElement(EncryptionProperty encryptionProperty) {
            return ((EncryptionPropertyImpl)encryptionProperty).toElement();
        }

        public Element toElement(ReferenceList referenceList) {
            Element result = ElementProxy.createElementForFamily(XMLCipher.this.contextDocument, "http://www.w3.org/2001/04/xmlenc#", "ReferenceList");
            if (referenceList != null && !referenceList.isEmpty()) {
                Iterator it = referenceList.getReferences();
                while (it.hasNext()) {
                    Reference ref = (Reference)it.next();
                    String elTagName = ref.getRefType() == 2 ? "DataReference" : "KeyReference";
                    Element refEl = ElementProxy.createElementForFamily(XMLCipher.this.contextDocument, "http://www.w3.org/2001/04/xmlenc#", elTagName);
                    refEl.setAttributeNS(null, "URI", ref.getURI());
                    result.appendChild(refEl);
                }
            }
            return result;
        }

        public Element toElement(Transforms transforms) {
            return ((TransformsImpl)transforms).toElement();
        }

        private class TransformsImpl
        implements Transforms {
            private List transforms = new LinkedList();

            public Iterator getTransforms() {
                return this.transforms.iterator();
            }

            public void addTransform(Transform transform) {
                this.transforms.add(transform);
            }

            public void removeTransform(Transform transform) {
                this.transforms.remove(transform);
            }

            Element toElement() {
                Element result = null;
                result = ElementProxy.createElementForFamily(XMLCipher.this.contextDocument, "http://www.w3.org/2001/04/xmlenc#", "Transforms");
                return result;
            }
        }

        private class EncryptionPropertyImpl
        implements EncryptionProperty {
            private String target = null;
            private String id = null;
            private String attributeName = null;
            private String attributeValue = null;
            private List encryptionInformation = new LinkedList();

            public String getTarget() {
                return this.target;
            }

            public void setTarget(String target) {
                URI tmpTarget = null;
                try {
                    tmpTarget = new URI(target);
                }
                catch (URI.MalformedURIException mfue) {
                    tmpTarget = null;
                    return;
                }
                this.target = tmpTarget.toString();
            }

            public String getId() {
                return this.id;
            }

            public void setId(String id) {
                this.id = id;
            }

            public String getAttribute(String attribute) {
                return this.attributeValue;
            }

            public void setAttribute(String attribute, String value) {
                this.attributeName = attribute;
                this.attributeValue = value;
            }

            public Iterator getEncryptionInformation() {
                return this.encryptionInformation.iterator();
            }

            public void addEncryptionInformation(Element info) {
                this.encryptionInformation.add(info);
            }

            public void removeEncryptionInformation(Element info) {
                this.encryptionInformation.remove(info);
            }

            Element toElement() {
                Element result = ElementProxy.createElementForFamily(XMLCipher.this.contextDocument, "http://www.w3.org/2001/04/xmlenc#", "EncryptionProperty");
                if (null != this.target) {
                    result.setAttributeNS(null, "Target", this.target.toString());
                }
                if (null != this.id) {
                    result.setAttributeNS(null, "Id", this.id);
                }
                return result;
            }
        }

        private class EncryptionPropertiesImpl
        implements EncryptionProperties {
            private String id = null;
            private List encryptionProperties = new LinkedList();

            public String getId() {
                return this.id;
            }

            public void setId(String id) {
                this.id = id;
            }

            public Iterator getEncryptionProperties() {
                return this.encryptionProperties.iterator();
            }

            public void addEncryptionProperty(EncryptionProperty property) {
                this.encryptionProperties.add(property);
            }

            public void removeEncryptionProperty(EncryptionProperty property) {
                this.encryptionProperties.remove(property);
            }

            Element toElement() {
                Element result = ElementProxy.createElementForFamily(XMLCipher.this.contextDocument, "http://www.w3.org/2001/04/xmlenc#", "EncryptionProperties");
                if (null != this.id) {
                    result.setAttributeNS(null, "Id", this.id);
                }
                Iterator itr = this.getEncryptionProperties();
                while (itr.hasNext()) {
                    result.appendChild(((EncryptionPropertyImpl)itr.next()).toElement());
                }
                return result;
            }
        }

        private class EncryptionMethodImpl
        implements EncryptionMethod {
            private String algorithm = null;
            private int keySize = Integer.MIN_VALUE;
            private byte[] oaepParams = null;
            private String oaepDigest = null;
            private List encryptionMethodInformation = new LinkedList();

            public EncryptionMethodImpl(String algorithm) {
                URI tmpAlgorithm = null;
                try {
                    tmpAlgorithm = new URI(algorithm);
                }
                catch (URI.MalformedURIException mfue) {
                    tmpAlgorithm = null;
                    return;
                }
                this.algorithm = tmpAlgorithm.toString();
            }

            public String getAlgorithm() {
                return this.algorithm;
            }

            public int getKeySize() {
                return this.keySize;
            }

            public void setKeySize(int size) {
                this.keySize = size;
            }

            public byte[] getOAEPparams() {
                return this.oaepParams;
            }

            public void setOAEPparams(byte[] params) {
                this.oaepParams = params;
            }

            public String getOAEPDigestAlgorithm() {
                return this.oaepDigest;
            }

            public void setOAEPDigestAlgorithm(String digestAlgorithm) {
                this.oaepDigest = digestAlgorithm;
            }

            public Iterator getEncryptionMethodInformation() {
                return this.encryptionMethodInformation.iterator();
            }

            public void addEncryptionMethodInformation(Element info) {
                this.encryptionMethodInformation.add(info);
            }

            public void removeEncryptionMethodInformation(Element info) {
                this.encryptionMethodInformation.remove(info);
            }

            Element toElement() {
                Element dummy;
                Element result = ElementProxy.createElementForFamily(XMLCipher.this.contextDocument, "http://www.w3.org/2001/04/xmlenc#", "EncryptionMethod");
                result.setAttributeNS(null, "Algorithm", this.algorithm.toString());
                if (this.keySize > 0) {
                    result.appendChild(ElementProxy.createElementForFamily(XMLCipher.this.contextDocument, "http://www.w3.org/2001/04/xmlenc#", "KeySize").appendChild(XMLCipher.this.contextDocument.createTextNode(String.valueOf(this.keySize))));
                }
                if (null != this.oaepParams) {
                    dummy = ElementProxy.createElementForFamily(XMLCipher.this.contextDocument, "http://www.w3.org/2001/04/xmlenc#", "OAEPparams");
                    dummy.appendChild(XMLCipher.this.contextDocument.createTextNode(new String(this.oaepParams)));
                    result.appendChild(dummy);
                }
                if (this.oaepDigest != null) {
                    dummy = ElementProxy.createElementForFamily(XMLCipher.this.contextDocument, XMLCipher.XML_DSIG, "DigestMethod");
                    dummy.setAttributeNS(null, "Algorithm", this.oaepDigest);
                    result.appendChild(dummy);
                }
                if (!this.encryptionMethodInformation.isEmpty()) {
                    Iterator itr = this.encryptionMethodInformation.iterator();
                    result.appendChild((Element)itr.next());
                }
                return result;
            }
        }

        private abstract class EncryptedTypeImpl {
            private String id = null;
            private String type = null;
            private String mimeType = null;
            private String encoding = null;
            private EncryptionMethod encryptionMethod = null;
            private KeyInfo keyInfo = null;
            private CipherData cipherData = null;
            private EncryptionProperties encryptionProperties = null;

            protected EncryptedTypeImpl(CipherData data) {
                this.cipherData = data;
            }

            public String getId() {
                return this.id;
            }

            public void setId(String id) {
                this.id = id;
            }

            public String getType() {
                return this.type;
            }

            public void setType(String type) {
                URI tmpType = null;
                try {
                    tmpType = new URI(type);
                }
                catch (URI.MalformedURIException mfue) {
                    this.type = null;
                    return;
                }
                this.type = tmpType.toString();
            }

            public String getMimeType() {
                return this.mimeType;
            }

            public void setMimeType(String type) {
                this.mimeType = type;
            }

            public String getEncoding() {
                return this.encoding;
            }

            public void setEncoding(String encoding) {
                URI tmpEncoding = null;
                try {
                    tmpEncoding = new URI(encoding);
                }
                catch (URI.MalformedURIException mfue) {
                    tmpEncoding = null;
                    return;
                }
                this.encoding = tmpEncoding.toString();
            }

            public EncryptionMethod getEncryptionMethod() {
                return this.encryptionMethod;
            }

            public void setEncryptionMethod(EncryptionMethod method) {
                this.encryptionMethod = method;
            }

            public KeyInfo getKeyInfo() {
                return this.keyInfo;
            }

            public void setKeyInfo(KeyInfo info) {
                this.keyInfo = info;
            }

            public CipherData getCipherData() {
                return this.cipherData;
            }

            public EncryptionProperties getEncryptionProperties() {
                return this.encryptionProperties;
            }

            public void setEncryptionProperties(EncryptionProperties properties) {
                this.encryptionProperties = properties;
            }
        }

        private class EncryptedKeyImpl
        extends EncryptedTypeImpl
        implements EncryptedKey {
            private String keyRecipient = null;
            private ReferenceList referenceList = null;
            private String carriedName = null;

            public EncryptedKeyImpl(CipherData data) {
                super(data);
            }

            public String getRecipient() {
                return this.keyRecipient;
            }

            public void setRecipient(String recipient) {
                this.keyRecipient = recipient;
            }

            public ReferenceList getReferenceList() {
                return this.referenceList;
            }

            public void setReferenceList(ReferenceList list) {
                this.referenceList = list;
            }

            public String getCarriedName() {
                return this.carriedName;
            }

            public void setCarriedName(String name) {
                this.carriedName = name;
            }

            Element toElement() {
                Element result = ElementProxy.createElementForFamily(XMLCipher.this.contextDocument, "http://www.w3.org/2001/04/xmlenc#", "EncryptedKey");
                if (null != super.getId()) {
                    result.setAttributeNS(null, "Id", super.getId());
                }
                if (null != super.getType()) {
                    result.setAttributeNS(null, "Type", super.getType().toString());
                }
                if (null != super.getMimeType()) {
                    result.setAttributeNS(null, "MimeType", super.getMimeType());
                }
                if (null != super.getEncoding()) {
                    result.setAttributeNS(null, "Encoding", super.getEncoding().toString());
                }
                if (null != this.getRecipient()) {
                    result.setAttributeNS(null, "Recipient", this.getRecipient());
                }
                if (null != super.getEncryptionMethod()) {
                    result.appendChild(((EncryptionMethodImpl)super.getEncryptionMethod()).toElement());
                }
                if (null != super.getKeyInfo()) {
                    Element keyInfo = (Element)XMLCipher.this.contextDocument.importNode(super.getKeyInfo().getElement(), true);
                    result.appendChild(keyInfo);
                }
                result.appendChild(((CipherDataImpl)super.getCipherData()).toElement());
                if (null != super.getEncryptionProperties()) {
                    result.appendChild(((EncryptionPropertiesImpl)super.getEncryptionProperties()).toElement());
                }
                if (this.referenceList != null && !this.referenceList.isEmpty()) {
                    ReferenceList rl = this.getReferenceList();
                    Element elementRl = ElementProxy.createElementForFamily(XMLCipher.this.contextDocument, "http://www.w3.org/2001/04/xmlenc#", "ReferenceList");
                    Iterator it = rl.getReferences();
                    while (it.hasNext()) {
                        Reference ref = (Reference)it.next();
                        String elTagName = ref.getRefType() == 2 ? "DataReference" : "KeyReference";
                        Element refEl = ElementProxy.createElementForFamily(XMLCipher.this.contextDocument, "http://www.w3.org/2001/04/xmlenc#", elTagName);
                        refEl.setAttributeNS(null, "URI", ref.getURI());
                        elementRl.appendChild(refEl);
                    }
                    result.appendChild(elementRl);
                }
                if (null != this.carriedName) {
                    result.appendChild(ElementProxy.createElementForFamily(XMLCipher.this.contextDocument, "http://www.w3.org/2001/04/xmlenc#", "CarriedKeyName").appendChild(XMLCipher.this.contextDocument.createTextNode(this.carriedName)));
                }
                return result;
            }
        }

        private class EncryptedDataImpl
        extends EncryptedTypeImpl
        implements EncryptedData {
            public EncryptedDataImpl(CipherData data) {
                super(data);
            }

            Element toElement() {
                Element result = ElementProxy.createElementForFamily(XMLCipher.this.contextDocument, "http://www.w3.org/2001/04/xmlenc#", "EncryptedData");
                if (null != super.getId()) {
                    result.setAttributeNS(null, "Id", super.getId());
                }
                if (null != super.getType()) {
                    result.setAttributeNS(null, "Type", super.getType().toString());
                }
                if (null != super.getMimeType()) {
                    result.setAttributeNS(null, "MimeType", super.getMimeType());
                }
                if (null != super.getEncoding()) {
                    result.setAttributeNS(null, "Encoding", super.getEncoding().toString());
                }
                if (null != super.getEncryptionMethod()) {
                    result.appendChild(((EncryptionMethodImpl)super.getEncryptionMethod()).toElement());
                }
                if (null != super.getKeyInfo()) {
                    Element keyInfo = (Element)XMLCipher.this.contextDocument.importNode(super.getKeyInfo().getElement(), true);
                    result.appendChild(keyInfo);
                }
                result.appendChild(((CipherDataImpl)super.getCipherData()).toElement());
                if (null != super.getEncryptionProperties()) {
                    result.appendChild(((EncryptionPropertiesImpl)super.getEncryptionProperties()).toElement());
                }
                return result;
            }
        }

        private class CipherValueImpl
        implements CipherValue {
            private byte[] cipherValue = null;

            public CipherValueImpl(byte[] value) {
                this.cipherValue = value;
            }

            public CipherValueImpl(String value) {
                this.cipherValue = value.getBytes();
            }

            public byte[] getValue() {
                return this.cipherValue;
            }

            public void setValue(byte[] value) {
                this.cipherValue = value;
            }

            public void setValue(String value) {
                this.cipherValue = value.getBytes();
            }

            Element toElement() {
                Element result = ElementProxy.createElementForFamily(XMLCipher.this.contextDocument, "http://www.w3.org/2001/04/xmlenc#", "CipherValue");
                result.appendChild(XMLCipher.this.contextDocument.createTextNode(new String(this.cipherValue)));
                return result;
            }
        }

        private class CipherReferenceImpl
        implements CipherReference {
            private String referenceURI = null;
            private Transforms referenceTransforms = null;

            public CipherReferenceImpl(String uri) {
                URI tmpReferenceURI = null;
                try {
                    tmpReferenceURI = new URI(uri);
                }
                catch (URI.MalformedURIException mfue) {
                    this.referenceURI = null;
                    return;
                }
                this.referenceURI = tmpReferenceURI.toString();
            }

            public String getURI() {
                return this.referenceURI;
            }

            public Transforms getTransforms() {
                return this.referenceTransforms;
            }

            public void setTransforms(Transforms transforms) {
                this.referenceTransforms = transforms;
            }

            Element toElement() {
                Element result = ElementProxy.createElementForFamily(XMLCipher.this.contextDocument, "http://www.w3.org/2001/04/xmlenc#", "CipherReference");
                result.setAttributeNS(null, "URI", this.referenceURI);
                if (null != this.referenceTransforms) {
                    result.appendChild(((TransformsImpl)this.referenceTransforms).toElement());
                }
                return result;
            }
        }

        private class CipherDataImpl
        implements CipherData {
            private static final String valueMessage = "Data type is reference type.";
            private static final String referenceMessage = "Data type is value type.";
            private CipherValue cipherValue = null;
            private CipherReference cipherReference = null;
            private int cipherType = Integer.MIN_VALUE;

            public CipherDataImpl(int type) {
                this.cipherType = type;
            }

            public CipherValue getCipherValue() {
                return this.cipherValue;
            }

            public void setCipherValue(CipherValue value) throws XMLEncryptionException {
                if (this.cipherType == 2) {
                    throw new XMLEncryptionException("empty", new UnsupportedOperationException(valueMessage));
                }
                this.cipherValue = value;
            }

            public CipherReference getCipherReference() {
                return this.cipherReference;
            }

            public void setCipherReference(CipherReference reference) throws XMLEncryptionException {
                if (this.cipherType == 1) {
                    throw new XMLEncryptionException("empty", new UnsupportedOperationException(referenceMessage));
                }
                this.cipherReference = reference;
            }

            public int getDataType() {
                return this.cipherType;
            }

            Element toElement() {
                Element result = ElementProxy.createElementForFamily(XMLCipher.this.contextDocument, "http://www.w3.org/2001/04/xmlenc#", "CipherData");
                if (this.cipherType == 1) {
                    result.appendChild(((CipherValueImpl)this.cipherValue).toElement());
                } else if (this.cipherType == 2) {
                    result.appendChild(((CipherReferenceImpl)this.cipherReference).toElement());
                }
                return result;
            }
        }

        private class AgreementMethodImpl
        implements AgreementMethod {
            private byte[] kaNonce = null;
            private List agreementMethodInformation = new LinkedList();
            private KeyInfo originatorKeyInfo = null;
            private KeyInfo recipientKeyInfo = null;
            private String algorithmURI = null;

            public AgreementMethodImpl(String algorithm) {
                URI tmpAlgorithm = null;
                try {
                    tmpAlgorithm = new URI(algorithm);
                }
                catch (URI.MalformedURIException fmue) {
                    this.algorithmURI = null;
                    return;
                }
                this.algorithmURI = tmpAlgorithm.toString();
            }

            public byte[] getKANonce() {
                return this.kaNonce;
            }

            public void setKANonce(byte[] kanonce) {
                this.kaNonce = kanonce;
            }

            public Iterator getAgreementMethodInformation() {
                return this.agreementMethodInformation.iterator();
            }

            public void addAgreementMethodInformation(Element info) {
                this.agreementMethodInformation.add(info);
            }

            public void revoveAgreementMethodInformation(Element info) {
                this.agreementMethodInformation.remove(info);
            }

            public KeyInfo getOriginatorKeyInfo() {
                return this.originatorKeyInfo;
            }

            public void setOriginatorKeyInfo(KeyInfo keyInfo) {
                this.originatorKeyInfo = keyInfo;
            }

            public KeyInfo getRecipientKeyInfo() {
                return this.recipientKeyInfo;
            }

            public void setRecipientKeyInfo(KeyInfo keyInfo) {
                this.recipientKeyInfo = keyInfo;
            }

            public String getAlgorithm() {
                return this.algorithmURI;
            }

            public void setAlgorithm(String algorithm) {
                URI tmpAlgorithm = null;
                try {
                    tmpAlgorithm = new URI(algorithm);
                }
                catch (URI.MalformedURIException mfue) {
                    this.algorithmURI = null;
                    return;
                }
                algorithm = tmpAlgorithm.toString();
            }

            Element toElement() {
                Element result = ElementProxy.createElementForFamily(XMLCipher.this.contextDocument, "http://www.w3.org/2001/04/xmlenc#", "AgreementMethod");
                result.setAttributeNS(null, "Algorithm", this.algorithmURI);
                if (null != this.kaNonce) {
                    result.appendChild(ElementProxy.createElementForFamily(XMLCipher.this.contextDocument, "http://www.w3.org/2001/04/xmlenc#", "KA-Nonce")).appendChild(XMLCipher.this.contextDocument.createTextNode(new String(this.kaNonce)));
                }
                if (!this.agreementMethodInformation.isEmpty()) {
                    Iterator itr = this.agreementMethodInformation.iterator();
                    while (itr.hasNext()) {
                        result.appendChild((Element)itr.next());
                    }
                }
                if (null != this.originatorKeyInfo) {
                    // empty if block
                }
                if (null != this.recipientKeyInfo) {
                    // empty if block
                }
                return result;
            }
        }
    }

    private class Serializer {
        private OutputFormat format = new OutputFormat();
        private XMLSerializer serializer;

        Serializer() {
            this.format.setEncoding("UTF-8");
            this.format.setOmitDocumentType(true);
            this.format.setOmitXMLDeclaration(true);
            this.format.setPreserveSpace(true);
        }

        String serialize(Document document) throws XMLEncryptionException {
            StringWriter output = new StringWriter();
            this.serializer = new XMLSerializer((Writer)output, this.format);
            try {
                this.serializer.serialize(document);
            }
            catch (IOException ioe) {
                throw new XMLEncryptionException("empty", ioe);
            }
            return output.toString();
        }

        String serialize(Element element) throws XMLEncryptionException {
            StringWriter output = new StringWriter();
            this.serializer = new XMLSerializer((Writer)output, this.format);
            try {
                this.serializer.serialize(element);
            }
            catch (IOException ioe) {
                throw new XMLEncryptionException("empty", ioe);
            }
            return output.toString();
        }

        String serialize(NodeList content) throws XMLEncryptionException {
            StringWriter output = new StringWriter();
            this.serializer = new XMLSerializer((Writer)output, this.format);
            try {
                int i = 0;
                while (i < content.getLength()) {
                    Node n = content.item(i);
                    if (null != n && n.getNodeType() == 1) {
                        this.serializer.serialize((Element)n);
                    }
                    ++i;
                }
            }
            catch (IOException ioe) {
                throw new XMLEncryptionException("empty", ioe);
            }
            return output.toString();
        }

        String serialize(DocumentFragment content) throws XMLEncryptionException {
            StringWriter output = new StringWriter();
            this.serializer = new XMLSerializer((Writer)output, this.format);
            try {
                this.serializer.serialize(content);
            }
            catch (IOException ioe) {
                throw new XMLEncryptionException("empty", ioe);
            }
            return output.toString();
        }

        Element deserialize(String source) throws XMLEncryptionException {
            Element result = null;
            String tagname = "fragment";
            String fragment = "<fragment>" + source + "</" + "fragment" + ">";
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document d = db.parse(new InputSource(new StringReader(fragment)));
                Node n = XMLCipher.this.contextDocument.importNode(d.getDocumentElement(), true);
                result = (Element)n.getFirstChild();
            }
            catch (SAXException se) {
                throw new XMLEncryptionException("empty", se);
            }
            catch (ParserConfigurationException pce) {
                throw new XMLEncryptionException("empty", pce);
            }
            catch (IOException ioe) {
                throw new XMLEncryptionException("empty", ioe);
            }
            return result;
        }
    }
}

