/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.encryption;

import com.systinet.wasp.security.secext.encryption.Reference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Element;

public class ReferenceList {
    private List references = new LinkedList();

    public void add(Reference reference) {
        this.references.add(reference);
    }

    public void remove(Reference reference) {
        this.references.remove(reference);
    }

    public int size() {
        return this.references.size();
    }

    public boolean isEmpty() {
        return this.references.isEmpty();
    }

    public Iterator getReferences() {
        return this.references.iterator();
    }

    public static Reference newDataReference(String uri) {
        return new DataReference(uri);
    }

    public static Reference newKeyReference(String uri) {
        return new KeyReference(uri);
    }

    private static class KeyReference
    extends ReferenceImpl {
        KeyReference(String uri) {
            super(uri);
        }

        public int getRefType() {
            return 1;
        }
    }

    private static class DataReference
    extends ReferenceImpl {
        DataReference(String uri) {
            super(uri);
        }

        public int getRefType() {
            return 2;
        }
    }

    private static abstract class ReferenceImpl
    implements Reference {
        private String uri;
        private List referenceInformation;

        ReferenceImpl(String uri) {
            this.uri = uri;
            this.referenceInformation = new LinkedList();
        }

        public String getURI() {
            return this.uri;
        }

        public Iterator getElementRetrievalInformation() {
            return this.referenceInformation.iterator();
        }

        public void setURI(String uri) {
            this.uri = uri;
        }

        public void removeElementRetrievalInformation(Element node) {
            this.referenceInformation.remove(node);
        }

        public void addElementRetrievalInformation(Element node) {
            this.referenceInformation.add(node);
        }

        public abstract int getRefType();
    }
}

