/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.c14n.implementations;

import com.systinet.wasp.security.secext.c14n.CanonicalizationException;
import com.systinet.wasp.security.secext.c14n.CanonicalizerSpi;
import com.systinet.wasp.security.secext.c14n.helper.C14nHelper;
import com.systinet.wasp.security.secext.utils.XMLUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public abstract class CanonicalizerBase
extends CanonicalizerSpi {
    boolean _includeComments = false;
    Set _xpathNodeSet = null;
    Document _doc = null;
    Element _documentElement = null;
    Node _rootNodeOfC14n = null;
    Writer _writer = null;
    Set _inclusiveNSSet = null;
    HashMap _renderedPrefixesForElement = null;
    static final int NODE_BEFORE_DOCUMENT_ELEMENT = -1;
    static final int NODE_NOT_BEFORE_OR_AFTER_DOCUMENT_ELEMENT = 0;
    static final int NODE_AFTER_DOCUMENT_ELEMENT = 1;

    public CanonicalizerBase(boolean includeComments) {
        this._includeComments = includeComments;
    }

    public byte[] engineCanonicalizeSubTree(Node rootNode) throws CanonicalizationException {
        this._rootNodeOfC14n = rootNode;
        this._doc = XMLUtils.getOwnerDocument(this._rootNodeOfC14n);
        this._documentElement = this._doc.getDocumentElement();
        XMLUtils.circumventBug2650(this._doc);
        try {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                this._writer = new OutputStreamWriter((OutputStream)baos, "UTF8");
                this.canonicalizeSubTree(this._rootNodeOfC14n);
                this._writer.close();
                byte[] byArray = baos.toByteArray();
                Object var5_6 = null;
                this._rootNodeOfC14n = null;
                this._doc = null;
                this._documentElement = null;
                this._writer = null;
                return byArray;
            }
            catch (UnsupportedEncodingException ex) {
                throw new CanonicalizationException("empty", ex);
            }
            catch (IOException ex) {
                throw new CanonicalizationException("empty", ex);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this._rootNodeOfC14n = null;
            this._doc = null;
            this._documentElement = null;
            this._writer = null;
            throw throwable;
        }
    }

    void canonicalizeSubTree(Node currentNode) throws CanonicalizationException, IOException {
        short currentNodeType = currentNode.getNodeType();
        switch (currentNodeType) {
            default: {
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 12: {
                throw new CanonicalizationException("empty", new Object[]{"Trying to canonicalizate attribute node"});
            }
            case 9: {
                Node currentChild = currentNode.getFirstChild();
                while (currentChild != null) {
                    this.canonicalizeSubTree(currentChild);
                    currentChild = currentChild.getNextSibling();
                }
                break;
            }
            case 8: {
                if (!this._includeComments) break;
                int position = CanonicalizerBase.getPositionRelativeToDocumentElement(currentNode);
                if (position == 1) {
                    this._writer.write("\n");
                }
                this.outputCommentToWriter((Comment)currentNode);
                if (position != -1) break;
                this._writer.write("\n");
                break;
            }
            case 7: {
                int position = CanonicalizerBase.getPositionRelativeToDocumentElement(currentNode);
                if (position == 1) {
                    this._writer.write("\n");
                }
                this.outputPItoWriter((ProcessingInstruction)currentNode);
                if (position != -1) break;
                this._writer.write("\n");
                break;
            }
            case 3: 
            case 4: {
                this.outputTextToWriter(currentNode.getNodeValue());
                break;
            }
            case 1: {
                Element currentElement = (Element)currentNode;
                this._writer.write("<");
                this._writer.write(currentElement.getTagName());
                Object[] attrs = this.handleAttributesSubtree(currentElement);
                int i = 0;
                while (i < attrs.length) {
                    this.outputAttrToWriter(((Attr)attrs[i]).getNodeName(), ((Attr)attrs[i]).getNodeValue());
                    ++i;
                }
                this._writer.write(">");
                Node currentChild = currentNode.getFirstChild();
                while (currentChild != null) {
                    this.canonicalizeSubTree(currentChild);
                    currentChild = currentChild.getNextSibling();
                }
                this._writer.write("</");
                this._writer.write(currentElement.getTagName());
                this._writer.write(">");
            }
        }
    }

    static int getPositionRelativeToDocumentElement(Node currentNode) {
        if (currentNode == null) {
            return 0;
        }
        Document doc = currentNode.getOwnerDocument();
        if (currentNode.getParentNode() != doc) {
            return 0;
        }
        Element documentElement = doc.getDocumentElement();
        if (documentElement == null) {
            return 0;
        }
        if (documentElement == currentNode) {
            return 0;
        }
        Node x = currentNode;
        while (x != null) {
            if (x == documentElement) {
                return -1;
            }
            x = x.getNextSibling();
        }
        return 1;
    }

    public byte[] engineCanonicalizeXPathNodeSet(Set xpathNodeSet, String inclusiveNamespaces) throws CanonicalizationException {
        this._xpathNodeSet = xpathNodeSet;
        if (this._xpathNodeSet.size() == 0) {
            return new byte[0];
        }
        Node n = (Node)this._xpathNodeSet.iterator().next();
        this._doc = XMLUtils.getOwnerDocument(n);
        this._documentElement = this._doc.getDocumentElement();
        try {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                this._writer = new OutputStreamWriter((OutputStream)baos, "UTF8");
                this.canonicalizeXPathNodeSet(this._doc);
                this._writer.close();
                byte[] byArray = baos.toByteArray();
                Object var6_7 = null;
                this._xpathNodeSet = null;
                this._rootNodeOfC14n = null;
                this._doc = null;
                this._documentElement = null;
                this._writer = null;
                return byArray;
            }
            catch (UnsupportedEncodingException ex) {
                throw new CanonicalizationException("empty", ex);
            }
            catch (IOException ex) {
                throw new CanonicalizationException("empty", ex);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this._xpathNodeSet = null;
            this._rootNodeOfC14n = null;
            this._doc = null;
            this._documentElement = null;
            this._writer = null;
            throw throwable;
        }
    }

    public byte[] engineCanonicalizeXPathNodeSet(Set xpathNodeSet) throws CanonicalizationException {
        this._xpathNodeSet = xpathNodeSet;
        if (this._xpathNodeSet.size() == 0) {
            return new byte[0];
        }
        if (this._doc == null) {
            Node n = (Node)this._xpathNodeSet.iterator().next();
            this._doc = XMLUtils.getOwnerDocument(n);
            this._documentElement = this._doc.getDocumentElement();
            this._rootNodeOfC14n = this._doc;
        }
        try {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                this._writer = new OutputStreamWriter((OutputStream)baos, "UTF8");
                this.canonicalizeXPathNodeSet(this._rootNodeOfC14n);
                this._writer.close();
                byte[] byArray = baos.toByteArray();
                Object var5_6 = null;
                this._xpathNodeSet = null;
                this._rootNodeOfC14n = null;
                this._doc = null;
                this._documentElement = null;
                this._writer = null;
                return byArray;
            }
            catch (UnsupportedEncodingException ex) {
                throw new CanonicalizationException("empty", ex);
            }
            catch (IOException ex) {
                throw new CanonicalizationException("empty", ex);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this._xpathNodeSet = null;
            this._rootNodeOfC14n = null;
            this._doc = null;
            this._documentElement = null;
            this._writer = null;
            throw throwable;
        }
    }

    void canonicalizeXPathNodeSet(Node currentNode) throws CanonicalizationException, IOException {
        short currentNodeType = currentNode.getNodeType();
        boolean currentNodeIsVisible = this._xpathNodeSet.contains(currentNode);
        switch (currentNodeType) {
            default: {
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 12: {
                throw new CanonicalizationException("empty", new Object[]{"Trying to canonicalizate attribute node"});
            }
            case 9: {
                Node currentChild = currentNode.getFirstChild();
                while (currentChild != null) {
                    this.canonicalizeXPathNodeSet(currentChild);
                    currentChild = currentChild.getNextSibling();
                }
                break;
            }
            case 8: {
                if (!this._includeComments || !this._xpathNodeSet.contains(currentNode)) break;
                int position = CanonicalizerBase.getPositionRelativeToDocumentElement(currentNode);
                if (position == 1) {
                    this._writer.write("\n");
                }
                this.outputCommentToWriter((Comment)currentNode);
                if (position != -1) break;
                this._writer.write("\n");
                break;
            }
            case 7: {
                if (!this._xpathNodeSet.contains(currentNode)) break;
                int position = CanonicalizerBase.getPositionRelativeToDocumentElement(currentNode);
                if (position == 1) {
                    this._writer.write("\n");
                }
                this.outputPItoWriter((ProcessingInstruction)currentNode);
                if (position != -1) break;
                this._writer.write("\n");
                break;
            }
            case 3: 
            case 4: {
                if (!this._xpathNodeSet.contains(currentNode)) break;
                this.outputTextToWriter(currentNode.getNodeValue());
                Node nextSibling = currentNode.getNextSibling();
                while (nextSibling != null && (nextSibling.getNodeType() == 3 || nextSibling.getNodeType() == 4)) {
                    this.outputTextToWriter(nextSibling.getNodeValue());
                    nextSibling = nextSibling.getNextSibling();
                }
                break;
            }
            case 1: {
                Element currentElement = (Element)currentNode;
                if (currentNodeIsVisible) {
                    this._writer.write("<");
                    this._writer.write(currentElement.getTagName());
                }
                Object[] attrs = this.handleAttributes(currentElement);
                attrs = C14nHelper.sortAttributes(attrs);
                int i = 0;
                while (i < attrs.length) {
                    Attr attr = (Attr)attrs[i];
                    this.outputAttrToWriter(attr.getNodeName(), attr.getNodeValue());
                    ++i;
                }
                if (currentNodeIsVisible) {
                    this._writer.write(">");
                }
                Node currentChild = currentNode.getFirstChild();
                while (currentChild != null) {
                    this.canonicalizeXPathNodeSet(currentChild);
                    currentChild = currentChild.getNextSibling();
                }
                if (!currentNodeIsVisible) break;
                this._writer.write("</");
                this._writer.write(currentElement.getTagName());
                this._writer.write(">");
            }
        }
    }

    void outputAttrToWriter(String name, String value) throws IOException {
        this._writer.write(" ");
        this._writer.write(name);
        this._writer.write("=\"");
        int length = value.length();
        int i = 0;
        while (i < length) {
            char c = value.charAt(i);
            switch (c) {
                case '&': {
                    this._writer.write("&amp;");
                    break;
                }
                case '<': {
                    this._writer.write("&lt;");
                    break;
                }
                case '\"': {
                    this._writer.write("&quot;");
                    break;
                }
                case '\t': {
                    this._writer.write("&#x9;");
                    break;
                }
                case '\n': {
                    this._writer.write("&#xA;");
                    break;
                }
                case '\r': {
                    this._writer.write("&#xD;");
                    break;
                }
                default: {
                    this._writer.write(c);
                }
            }
            ++i;
        }
        this._writer.write("\"");
    }

    void outputPItoWriter(ProcessingInstruction currentPI) throws IOException {
        this._writer.write("<?");
        String target = currentPI.getTarget();
        int length = target.length();
        int i = 0;
        while (i < length) {
            char c = target.charAt(i);
            switch (c) {
                case '\r': {
                    this._writer.write("&#xD;");
                    break;
                }
                default: {
                    this._writer.write(c);
                }
            }
            ++i;
        }
        String data = currentPI.getData();
        length = data.length();
        if (data != null && length > 0) {
            this._writer.write(" ");
            int i2 = 0;
            while (i2 < length) {
                char c = data.charAt(i2);
                switch (c) {
                    case '\r': {
                        this._writer.write("&#xD;");
                        break;
                    }
                    default: {
                        this._writer.write(c);
                    }
                }
                ++i2;
            }
        }
        this._writer.write("?>");
    }

    void outputCommentToWriter(Comment currentComment) throws IOException {
        this._writer.write("<!--");
        String data = currentComment.getData();
        int length = data.length();
        int i = 0;
        while (i < length) {
            char c = data.charAt(i);
            switch (c) {
                case '\r': {
                    this._writer.write("&#xD;");
                    break;
                }
                default: {
                    this._writer.write(c);
                }
            }
            ++i;
        }
        this._writer.write("-->");
    }

    void outputTextToWriter(String text) throws IOException {
        int length = text.length();
        int i = 0;
        while (i < length) {
            char c = text.charAt(i);
            switch (c) {
                case '&': {
                    this._writer.write("&amp;");
                    break;
                }
                case '<': {
                    this._writer.write("&lt;");
                    break;
                }
                case '>': {
                    this._writer.write("&gt;");
                    break;
                }
                case '\r': {
                    this._writer.write("&#xD;");
                    break;
                }
                default: {
                    this._writer.write(c);
                }
            }
            ++i;
        }
    }

    abstract Object[] handleAttributes(Element var1) throws CanonicalizationException;

    abstract Object[] handleAttributesSubtree(Element var1) throws CanonicalizationException;
}

