/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.c14n;

import com.systinet.wasp.security.secext.c14n.CanonicalizationException;
import com.systinet.wasp.security.secext.c14n.CanonicalizerSpi;
import com.systinet.wasp.security.secext.c14n.InvalidCanonicalizerException;
import com.systinet.wasp.security.secext.exceptions.AlgorithmAlreadyRegisteredException;
import com.systinet.wasp.security.secext.utils.IgnoreAllErrorHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Canonicalizer {
    public static final String ENCODING = "UTF8";
    private static final String XPATH_NO_COMMENTS = "[not(self::comment())]";
    public static final String XPATH_C14N_WITH_COMMENTS = "(//. | //@* | //namespace::*)";
    public static final String XPATH_C14N_OMIT_COMMENTS = "(//. | //@* | //namespace::*)[not(self::comment())]";
    public static final String XPATH_C14N_WITH_COMMENTS_SINGLE_NODE = "(.//. | .//@* | .//namespace::*)";
    public static final String XPATH_C14N_OMIT_COMMENTS_SINGLE_NODE = "(.//. | .//@* | .//namespace::*)[not(self::comment())]";
    public static final String ALGO_ID_C14N_OMIT_COMMENTS = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    public static final String ALGO_ID_C14N_WITH_COMMENTS = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments";
    public static final String ALGO_ID_C14N_EXCL_OMIT_COMMENTS = "http://www.w3.org/2001/10/xml-exc-c14n#";
    public static final String ALGO_ID_C14N_EXCL_WITH_COMMENTS = "http://www.w3.org/2001/10/xml-exc-c14n#WithComments";
    static boolean _alreadyInitialized = false;
    static Map _canonicalizerHash = null;
    protected CanonicalizerSpi canonicalizerSpi = null;

    public static void init() {
        if (!_alreadyInitialized) {
            _canonicalizerHash = new HashMap(10);
            _alreadyInitialized = true;
        }
    }

    private Canonicalizer(String algorithmURI) throws InvalidCanonicalizerException {
        try {
            String implementingClass = Canonicalizer.getImplementingClass(algorithmURI);
            this.canonicalizerSpi = (CanonicalizerSpi)Class.forName(implementingClass).newInstance();
        }
        catch (Exception e) {
            Object[] exArgs = new Object[]{algorithmURI};
            throw new InvalidCanonicalizerException("signature.Canonicalizer.UnknownCanonicalizer", exArgs);
        }
    }

    public static final Canonicalizer getInstance(String algorithmURI) throws InvalidCanonicalizerException {
        Canonicalizer c14nizer = new Canonicalizer(algorithmURI);
        return c14nizer;
    }

    public static void register(String algorithmURI, String implementingClass) throws AlgorithmAlreadyRegisteredException {
        String registeredClass = Canonicalizer.getImplementingClass(algorithmURI);
        if (registeredClass != null && registeredClass.length() != 0) {
            Object[] exArgs = new Object[]{algorithmURI, registeredClass};
            throw new AlgorithmAlreadyRegisteredException("algorithm.alreadyRegistered", exArgs);
        }
        _canonicalizerHash.put(algorithmURI, implementingClass);
    }

    public final String getURI() {
        return this.canonicalizerSpi.engineGetURI();
    }

    public boolean getIncludeComments() {
        return this.canonicalizerSpi.engineGetIncludeComments();
    }

    public byte[] canonicalize(byte[] inputBytes) throws ParserConfigurationException, IOException, SAXException, CanonicalizationException {
        ByteArrayInputStream bais = new ByteArrayInputStream(inputBytes);
        InputSource in = new InputSource(bais);
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        dfactory.setNamespaceAware(true);
        dfactory.setValidating(true);
        DocumentBuilder db = dfactory.newDocumentBuilder();
        db.setErrorHandler(new IgnoreAllErrorHandler());
        Document document = db.parse(in);
        byte[] result = this.canonicalizeSubtree(document);
        return result;
    }

    public byte[] canonicalizeSubtree(Node node) throws CanonicalizationException {
        return this.canonicalizerSpi.engineCanonicalizeSubTree(node);
    }

    public byte[] canonicalizeSubtree(Node node, String inclusiveNamespaces) throws CanonicalizationException {
        return this.canonicalizerSpi.engineCanonicalizeSubTree(node, inclusiveNamespaces);
    }

    public byte[] canonicalizeXPathNodeSet(NodeList xpathNodeSet) throws CanonicalizationException {
        return this.canonicalizerSpi.engineCanonicalizeXPathNodeSet(xpathNodeSet);
    }

    public byte[] canonicalizeXPathNodeSet(NodeList xpathNodeSet, String inclusiveNamespaces) throws CanonicalizationException {
        return this.canonicalizerSpi.engineCanonicalizeXPathNodeSet(xpathNodeSet, inclusiveNamespaces);
    }

    public byte[] canonicalizeXPathNodeSet(Set xpathNodeSet) throws CanonicalizationException {
        return this.canonicalizerSpi.engineCanonicalizeXPathNodeSet(xpathNodeSet);
    }

    public byte[] canonicalizeXPathNodeSet(Set xpathNodeSet, String inclusiveNamespaces) throws CanonicalizationException {
        return this.canonicalizerSpi.engineCanonicalizeXPathNodeSet(xpathNodeSet, inclusiveNamespaces);
    }

    public String getImplementingCanonicalizerClass() {
        return this.canonicalizerSpi.getClass().getName();
    }

    private static String getImplementingClass(String URI2) {
        Iterator i = _canonicalizerHash.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (!key.equals(URI2)) continue;
            return (String)_canonicalizerHash.get(key);
        }
        return null;
    }
}

