/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.algorithms.encryption.helper;

import com.systinet.wasp.security.secext.algorithms.encryption.helper.InvalidCipherTextException;
import com.systinet.wasp.security.secext.exceptions.XMLSecurityException;
import com.systinet.wasp.security.secext.utils.PRNG;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;

public class TripleDESWrapper {
    byte[] digest = new byte[20];
    byte[] iv;
    private static final byte[] IV2 = new byte[]{74, -35, -94, 44, 121, -24, 33, 5};
    Cipher _cipher;
    MessageDigest _digest;

    public TripleDESWrapper(Cipher tripleDesECBCipher, MessageDigest sha1) {
        this._cipher = tripleDesECBCipher;
        this._digest = sha1;
    }

    public byte[] wrap(byte[] keyToBeWrapped, Key wrapKey, byte[] IV) throws InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, XMLSecurityException {
        try {
            byte[] CKS = this.calculateCMSKeyChecksum(keyToBeWrapped);
            byte[] WKCKS = new byte[keyToBeWrapped.length + CKS.length];
            System.arraycopy(keyToBeWrapped, 0, WKCKS, 0, keyToBeWrapped.length);
            System.arraycopy(CKS, 0, WKCKS, keyToBeWrapped.length, CKS.length);
            byte[] TEMP1 = new byte[WKCKS.length];
            System.arraycopy(WKCKS, 0, TEMP1, 0, WKCKS.length);
            int extraBytes = WKCKS.length % this._cipher.getBlockSize();
            if (extraBytes != 0) {
                throw new IllegalStateException("Not multiple of block length: " + WKCKS.length + " % " + this._cipher.getBlockSize() + " = " + extraBytes);
            }
            if (IV == null) {
                IV = PRNG.createBytes(8);
            }
            IvParameterSpec ivParam = new IvParameterSpec(IV);
            this._cipher.init(1, wrapKey, ivParam);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] t = this._cipher.update(TEMP1);
            if (t != null) {
                baos.write(t);
            }
            if ((t = this._cipher.doFinal()) != null) {
                baos.write(t);
            }
            System.arraycopy(baos.toByteArray(), 0, TEMP1, 0, TEMP1.length);
            byte[] TEMP2 = new byte[IV.length + TEMP1.length];
            System.arraycopy(IV, 0, TEMP2, 0, IV.length);
            System.arraycopy(TEMP1, 0, TEMP2, IV.length, TEMP1.length);
            byte[] TEMP3 = new byte[TEMP2.length];
            int i = 0;
            while (i < TEMP2.length) {
                TEMP3[i] = TEMP2[TEMP2.length - (i + 1)];
                ++i;
            }
            IvParameterSpec iv2Param = new IvParameterSpec(IV2);
            this._cipher.init(1, wrapKey, iv2Param);
            ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
            byte[] t2 = this._cipher.update(TEMP3);
            if (t2 != null) {
                baos2.write(t2);
            }
            if ((t2 = this._cipher.doFinal()) != null) {
                baos2.write(t2);
            }
            System.arraycopy(baos2.toByteArray(), 0, TEMP3, 0, TEMP3.length);
            return TEMP3;
        }
        catch (IOException ex) {
            throw new XMLSecurityException("empty", ex);
        }
        catch (BadPaddingException ex) {
            throw new XMLSecurityException("empty", ex);
        }
    }

    public byte[] unwrap(byte[] wrappedKey, Key wrapKey) throws InvalidCipherTextException, XMLSecurityException {
        try {
            if (wrappedKey == null) {
                throw new InvalidCipherTextException("Null pointer as ciphertext");
            }
            if (wrappedKey.length % this._cipher.getBlockSize() != 0) {
                throw new InvalidCipherTextException("Ciphertext not multiple of " + this._cipher.getBlockSize());
            }
            IvParameterSpec iv2Param = new IvParameterSpec(IV2);
            this._cipher.init(2, wrapKey, iv2Param);
            byte[] TEMP3 = new byte[wrappedKey.length];
            System.arraycopy(wrappedKey, 0, TEMP3, 0, wrappedKey.length);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] t = this._cipher.update(TEMP3);
            if (t != null) {
                baos.write(t);
            }
            if ((t = this._cipher.doFinal()) != null) {
                baos.write(t);
            }
            System.arraycopy(baos.toByteArray(), 0, TEMP3, 0, TEMP3.length);
            byte[] TEMP2 = new byte[TEMP3.length];
            int i = 0;
            while (i < TEMP3.length) {
                TEMP2[i] = TEMP3[TEMP3.length - (i + 1)];
                ++i;
            }
            IvParameterSpec ivParam = new IvParameterSpec(TEMP2, 0, 8);
            byte[] TEMP1 = new byte[TEMP2.length - 8];
            System.arraycopy(TEMP2, 8, TEMP1, 0, TEMP2.length - 8);
            this._cipher.init(2, wrapKey, ivParam);
            byte[] WKCKS = new byte[TEMP1.length];
            System.arraycopy(TEMP1, 0, WKCKS, 0, TEMP1.length);
            ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
            byte[] t2 = this._cipher.update(WKCKS);
            if (t2 != null) {
                baos2.write(t2);
            }
            if ((t2 = this._cipher.doFinal()) != null) {
                baos2.write(t2);
            }
            System.arraycopy(baos2.toByteArray(), 0, WKCKS, 0, WKCKS.length);
            byte[] result = new byte[WKCKS.length - 8];
            byte[] CKStoBeVerified = new byte[8];
            System.arraycopy(WKCKS, 0, result, 0, WKCKS.length - 8);
            System.arraycopy(WKCKS, WKCKS.length - 8, CKStoBeVerified, 0, 8);
            if (!this.checkCMSKeyChecksum(result, CKStoBeVerified)) {
                throw new InvalidCipherTextException("Checksum inside ciphertext is corrupted");
            }
            return result;
        }
        catch (InvalidCipherTextException ex) {
            throw ex;
        }
        catch (XMLSecurityException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new XMLSecurityException("empty", ex);
        }
    }

    private byte[] calculateCMSKeyChecksum(byte[] key) {
        this._digest.reset();
        this._digest.update(key, 0, key.length);
        byte[] result = new byte[8];
        byte[] digest = this._digest.digest();
        System.arraycopy(digest, 0, result, 0, 8);
        return result;
    }

    private boolean checkCMSKeyChecksum(byte[] key, byte[] checksum) {
        byte[] calculatedChecksum = this.calculateCMSKeyChecksum(key);
        if (checksum.length != calculatedChecksum.length) {
            return false;
        }
        int i = 0;
        while (i != checksum.length) {
            if (checksum[i] != calculatedChecksum[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

