/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.algorithms.encryption.helper;

import com.systinet.wasp.security.secext.algorithms.encryption.helper.InvalidCipherTextException;
import com.systinet.wasp.security.secext.exceptions.XMLSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.ShortBufferException;

public class AESWrapper {
    static final byte[] DEFAULT_IV = new byte[]{-90, -90, -90, -90, -90, -90, -90, -90};
    Cipher _cipher;

    public AESWrapper(Cipher aesCipher) {
        this._cipher = aesCipher;
    }

    public byte[] wrap(Key keyToBeWrappedK, Key wrapKey, byte[] IV) throws XMLSecurityException {
        try {
            byte[] keyToBeWrapped = keyToBeWrappedK.getEncoded();
            if (IV == null) {
                IV = new byte[DEFAULT_IV.length];
                System.arraycopy(DEFAULT_IV, 0, IV, 0, DEFAULT_IV.length);
            }
            if (IV.length != 8) {
                throw new XMLSecurityException("empty", new Object[]{"Wrong size of IV"});
            }
            int inLen = keyToBeWrapped.length;
            int n = inLen / 8;
            if (keyToBeWrapped.length % 8 != 0) {
                throw new XMLSecurityException("wrap data must be a multiple of 8 bytes");
            }
            byte[] block = new byte[keyToBeWrapped.length + IV.length];
            byte[] buf = new byte[8 + IV.length];
            System.arraycopy(IV, 0, block, 0, IV.length);
            System.arraycopy(keyToBeWrapped, 0, block, IV.length, keyToBeWrapped.length);
            this._cipher.init(1, wrapKey);
            int j = 0;
            while (j != 6) {
                int i = 1;
                while (i <= n) {
                    System.arraycopy(block, 0, buf, 0, IV.length);
                    System.arraycopy(block, 8 * i, buf, IV.length, 8);
                    this._cipher.update(buf, 0, buf.length, buf, 0);
                    int t = n * j + i;
                    int k = 1;
                    while (t != 0) {
                        byte v = (byte)t;
                        int n2 = IV.length - k;
                        buf[n2] = (byte)(buf[n2] ^ v);
                        t >>>= 8;
                        ++k;
                    }
                    System.arraycopy(buf, 0, block, 0, 8);
                    System.arraycopy(buf, 8, block, 8 * i, 8);
                    ++i;
                }
                ++j;
            }
            return block;
        }
        catch (InvalidKeyException ex) {
            throw new XMLSecurityException("empty", ex);
        }
        catch (ShortBufferException ex) {
            throw new XMLSecurityException("empty", ex);
        }
    }

    public byte[] unwrap(byte[] wrappedKey, Key wrapKey) throws InvalidCipherTextException, XMLSecurityException {
        try {
            int i;
            int n = wrappedKey.length / 8;
            if (n * 8 != wrappedKey.length) {
                throw new InvalidCipherTextException("unwrap data must be a multiple of 8 bytes");
            }
            byte[] a = new byte[DEFAULT_IV.length];
            byte[] block = new byte[wrappedKey.length - a.length];
            byte[] buf = new byte[8 + a.length];
            System.arraycopy(wrappedKey, 0, a, 0, a.length);
            System.arraycopy(wrappedKey, a.length, block, 0, wrappedKey.length - a.length);
            this._cipher.init(2, wrapKey);
            --n;
            int j = 5;
            while (j >= 0) {
                i = n;
                while (i >= 1) {
                    System.arraycopy(a, 0, buf, 0, a.length);
                    System.arraycopy(block, 8 * (i - 1), buf, a.length, 8);
                    int t = n * j + i;
                    int k = 1;
                    while (t != 0) {
                        byte v = (byte)t;
                        int n2 = a.length - k;
                        buf[n2] = (byte)(buf[n2] ^ v);
                        t >>>= 8;
                        ++k;
                    }
                    this._cipher.update(buf, 0, buf.length, buf, 0);
                    System.arraycopy(buf, 0, a, 0, 8);
                    System.arraycopy(buf, 8, block, 8 * (i - 1), 8);
                    --i;
                }
                --j;
            }
            i = 0;
            while (i != a.length) {
                if (a[i] != DEFAULT_IV[i]) {
                    throw new InvalidCipherTextException("checksum failed");
                }
                ++i;
            }
            return block;
        }
        catch (InvalidKeyException ex) {
            throw new XMLSecurityException("empty", ex);
        }
        catch (ShortBufferException ex) {
            throw new XMLSecurityException("empty", ex);
        }
    }
}

