/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.algorithms.encryption;

import com.idoox.debug.Category;
import com.systinet.wasp.security.secext.algorithms.JCEMapper;
import com.systinet.wasp.security.secext.algorithms.encryption.params.EncryptionMethodParams;
import com.systinet.wasp.security.secext.exceptions.XMLSecurityException;
import java.security.Key;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class EncryptionMethodSpi {
    static Category cat = Category.getCategory((String)(class$com$systinet$wasp$security$secext$algorithms$encryption$EncryptionMethodSpi == null ? (class$com$systinet$wasp$security$secext$algorithms$encryption$EncryptionMethodSpi = EncryptionMethodSpi.class$("com.systinet.wasp.security.secext.algorithms.encryption.EncryptionMethodSpi")) : class$com$systinet$wasp$security$secext$algorithms$encryption$EncryptionMethodSpi).getName());
    public static final int ALGOTYPE_BLOCK_ENCRYPTION = 1;
    public static final int ALGOTYPE_STREAM_ENCRYPTION = 2;
    public static final int ALGOTYPE_KEY_TRANSPORT = 3;
    public static final int ALGOTYPE_SYMMETRIC_KEY_WRAP = 4;
    public static final int ALGOTYPE_KEY_AGREEMENT = 5;
    static /* synthetic */ Class class$com$systinet$wasp$security$secext$algorithms$encryption$EncryptionMethodSpi;

    public boolean getRequiredProviderAvailable() {
        String Id = this.getRequiredProviderName();
        if (JCEMapper.getProviderIsRegisteredAtSecurity(Id)) {
            return true;
        }
        if (JCEMapper.getProviderIsInClassPath(Id)) {
            return JCEMapper.addProvider(Id);
        }
        return false;
    }

    protected String getImplementedAlgorithmJCE() {
        JCEMapper.ProviderIdClass pic = JCEMapper.translateURItoJCEID(this.getImplementedAlgorithmURI(), this.getRequiredProviderName());
        return pic.getAlgorithmID();
    }

    public static final String getKeyTypeString(int keyType) {
        switch (keyType) {
            case 1: {
                return "PUBLIC_KEY";
            }
            case 2: {
                return "PRIVATE_KEY";
            }
            case 3: {
                return "SECRET_KEY";
            }
        }
        return "UNKNOWN_KEY";
    }

    public abstract int getImplementedAlgorithmType();

    public abstract String getImplementedAlgorithmURI();

    public abstract String getRequiredProviderName();

    public abstract int engineGetBlockSize();

    public abstract int engineGetIvLength();

    public abstract byte[] engineEncrypt(byte[] var1, Key var2) throws XMLSecurityException;

    public abstract byte[] engineEncrypt(byte[] var1, Key var2, byte[] var3) throws XMLSecurityException;

    public abstract byte[] engineDecrypt(byte[] var1, Key var2) throws XMLSecurityException;

    public abstract byte[] engineWrap(Key var1, Key var2) throws XMLSecurityException;

    public abstract byte[] engineWrap(Key var1, Key var2, byte[] var3) throws XMLSecurityException;

    public abstract Key engineUnwrap(byte[] var1, Key var2, String var3) throws XMLSecurityException;

    public abstract EncryptionMethodParams engineInit(Document var1, EncryptionMethodParams var2) throws XMLSecurityException;

    public abstract EncryptionMethodParams engineInit(Element var1) throws XMLSecurityException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

