/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.algorithms.encryption;

import com.idoox.debug.Category;
import com.systinet.wasp.security.secext.algorithms.Algorithm;
import com.systinet.wasp.security.secext.algorithms.JCEMapper;
import com.systinet.wasp.security.secext.algorithms.encryption.EncryptionMethodSpi;
import com.systinet.wasp.security.secext.algorithms.encryption.params.EncryptionMethodParams;
import com.systinet.wasp.security.secext.exceptions.XMLSecurityException;
import com.systinet.wasp.security.secext.utils.Base64;
import java.security.Key;
import java.util.HashMap;
import java.util.Vector;
import javax.crypto.spec.SecretKeySpec;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EncryptionMethod
extends Algorithm {
    static Category cat = Category.getCategory((String)(class$com$systinet$wasp$security$secext$algorithms$encryption$EncryptionMethod == null ? (class$com$systinet$wasp$security$secext$algorithms$encryption$EncryptionMethod = EncryptionMethod.class$("com.systinet.wasp.security.secext.algorithms.encryption.EncryptionMethod")) : class$com$systinet$wasp$security$secext$algorithms$encryption$EncryptionMethod).getName());
    EncryptionMethodSpi _emSpi = null;
    EncryptionMethodParams _encMethodParams = null;
    static boolean _alreadyInitialized = false;
    static HashMap _algorithmHash = null;
    static /* synthetic */ Class class$com$systinet$wasp$security$secext$algorithms$encryption$EncryptionMethod;

    public String getBaseNamespace() {
        return "http://www.w3.org/2001/04/xmlenc#";
    }

    public String getBaseLocalName() {
        return "EncryptionMethod";
    }

    public EncryptionMethod(Document doc, String algorithmURI) throws XMLSecurityException {
        this(doc, algorithmURI, null);
    }

    public boolean getUsableInEncryptedData() {
        int type = this._emSpi.getImplementedAlgorithmType();
        switch (type) {
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 4: {
                return false;
            }
            case 3: {
                return false;
            }
            case 5: {
                return false;
            }
        }
        return false;
    }

    public boolean getUsableInEncryptedKey() {
        int type = this._emSpi.getImplementedAlgorithmType();
        switch (type) {
            case 1: {
                return false;
            }
            case 2: {
                return false;
            }
            case 4: {
                return true;
            }
            case 3: {
                return true;
            }
            case 5: {
                return true;
            }
        }
        return false;
    }

    public EncryptionMethod(Document doc, String algorithmURI, EncryptionMethodParams params) throws XMLSecurityException {
        super(doc, algorithmURI);
        Vector v = (Vector)_algorithmHash.get(algorithmURI);
        if (v == null) {
            throw new XMLSecurityException("empty", new Object[]{"Unknown or unsupported encryption algorithm " + algorithmURI});
        }
        int i = 0;
        while (i < v.size()) {
            try {
                String implementingClass = (String)v.elementAt(i);
                this._emSpi = (EncryptionMethodSpi)Class.forName(implementingClass).newInstance();
                if (this._emSpi != null && this._emSpi.getRequiredProviderAvailable()) {
                    break;
                }
            }
            catch (ClassNotFoundException ex) {
                throw new XMLSecurityException("empty", ex);
            }
            catch (IllegalAccessException ex) {
                throw new XMLSecurityException("empty", ex);
            }
            catch (InstantiationException ex) {
                throw new XMLSecurityException("empty", ex);
            }
            ++i;
        }
        if (this._emSpi == null) {
            Object[] exArgs = new Object[]{"Could not find a registered Provider"};
            throw new XMLSecurityException("empty", exArgs);
        }
        this._encMethodParams = this._emSpi.engineInit(doc, params);
        if (this._encMethodParams != null) {
            this._constructionElement.appendChild(this._encMethodParams.createChildNodes(this._doc));
        }
    }

    public EncryptionMethod(Element element, String BaseURI) throws XMLSecurityException {
        super(element, BaseURI);
        String algorithmURI = this.getAlgorithmURI();
        Vector v = (Vector)_algorithmHash.get(algorithmURI);
        if (v == null) {
            throw new XMLSecurityException("empty");
        }
        int i = 0;
        while (i < v.size()) {
            try {
                String implementingClass = (String)v.elementAt(i);
                this._emSpi = (EncryptionMethodSpi)Class.forName(implementingClass).newInstance();
                if (this._emSpi != null && this._emSpi.getRequiredProviderAvailable()) {
                    break;
                }
            }
            catch (ClassNotFoundException ex) {
                throw new XMLSecurityException("empty", ex);
            }
            catch (IllegalAccessException ex) {
                throw new XMLSecurityException("empty", ex);
            }
            catch (InstantiationException ex) {
                throw new XMLSecurityException("empty", ex);
            }
            ++i;
        }
        if (this._emSpi == null) {
            throw new XMLSecurityException("empty");
        }
        this._encMethodParams = this._emSpi.engineInit(this._constructionElement);
    }

    public byte[] wrap(Key contentKey, Key wrapKey) throws XMLSecurityException {
        return this._emSpi.engineWrap(contentKey, wrapKey);
    }

    public byte[] wrap(Key contentKey, Key wrapKey, byte[] IV) throws XMLSecurityException {
        return this._emSpi.engineWrap(contentKey, wrapKey, IV);
    }

    public Key unwrap(byte[] wrappedKey, Key wrapKey, String wrappedKeyAlgoURI) throws XMLSecurityException {
        return this._emSpi.engineUnwrap(wrappedKey, wrapKey, wrappedKeyAlgoURI);
    }

    public byte[] encrypt(byte[] plaintextBytes, Key contentKey) throws XMLSecurityException {
        return this._emSpi.engineEncrypt(plaintextBytes, contentKey);
    }

    public byte[] encrypt(byte[] plaintextBytes, Key contentKey, byte[] IV) throws XMLSecurityException {
        return this._emSpi.engineEncrypt(plaintextBytes, contentKey, IV);
    }

    public byte[] decrypt(byte[] ciphertextBytes, Key contentKey) throws XMLSecurityException {
        return this._emSpi.engineDecrypt(ciphertextBytes, contentKey);
    }

    public EncryptionMethodParams getParams() {
        return this._encMethodParams;
    }

    public int getIvLength() {
        return this._emSpi.engineGetIvLength();
    }

    public int getBlockSize() {
        return this._emSpi.engineGetBlockSize();
    }

    public Key createSecretKeyFromBytes(byte[] encodedKey) throws XMLSecurityException {
        String JceAlgo = JCEMapper.getJCEKeyAlgorithmFromURI(this._emSpi.getImplementedAlgorithmURI(), this._emSpi.getRequiredProviderName());
        return new SecretKeySpec(encodedKey, JceAlgo);
    }

    public static void providerInit() {
        if (!_alreadyInitialized) {
            _algorithmHash = new HashMap(10);
            _alreadyInitialized = true;
        }
    }

    public static boolean register(String algorithmURI, String implementingClass) {
        Vector<String> v = (Vector<String>)_algorithmHash.get(algorithmURI);
        if (v == null) {
            v = new Vector<String>();
            _algorithmHash.put(algorithmURI, v);
        }
        try {
            EncryptionMethodSpi emSpi;
            Class<?> c = Class.forName(implementingClass);
            if (c != null && (emSpi = (EncryptionMethodSpi)c.newInstance()).getRequiredProviderAvailable()) {
                v.add(implementingClass);
                return true;
            }
        }
        catch (ClassNotFoundException ex) {
        }
        catch (IllegalAccessException ex) {
        }
        catch (InstantiationException ex) {
            // empty catch block
        }
        return false;
    }

    public String encryptB64(byte[] plaintextBytes, Key contentKey, byte[] IV) throws XMLSecurityException {
        byte[] ciphertextBytes = this.encrypt(plaintextBytes, contentKey, IV);
        return Base64.encode(ciphertextBytes);
    }

    public String encryptB64(byte[] plaintextBytes, Key contentKey) throws XMLSecurityException {
        byte[] ciphertextBytes = this.encrypt(plaintextBytes, contentKey);
        return Base64.encode(ciphertextBytes);
    }

    public byte[] decryptB64(String ciphertext, Key contentKey) throws XMLSecurityException {
        byte[] ciphertextBytes = Base64.decode(ciphertext);
        return this.decrypt(ciphertextBytes, contentKey);
    }

    public String wrapB64(Key contentKey, Key wrapKey) throws XMLSecurityException {
        byte[] wrappedKeyBytes = this.wrap(contentKey, wrapKey);
        return Base64.encode(wrappedKeyBytes);
    }

    public String wrapB64(Key contentKey, Key wrapKey, byte[] IV) throws XMLSecurityException {
        byte[] wrappedKeyBytes = this.wrap(contentKey, wrapKey, IV);
        return Base64.encode(wrappedKeyBytes);
    }

    public Key unwrapB64(String wrappedKey, Key wrapKey, String wrappedKeyAlgoURI) throws XMLSecurityException {
        byte[] wrappedKeyBytes = Base64.decode(wrappedKey);
        return this.unwrap(wrappedKeyBytes, wrapKey, wrappedKeyAlgoURI);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

