/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.algorithms;

import com.idoox.debug.Category;
import com.systinet.wasp.security.secext.algorithms.Algorithm;
import com.systinet.wasp.security.secext.algorithms.JCEMapper;
import com.systinet.wasp.security.secext.signature.XMLSignatureException;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import org.w3c.dom.Document;

public class MessageDigestAlgorithm
extends Algorithm {
    static Category cat = Category.getCategory((String)(class$com$systinet$wasp$security$secext$algorithms$MessageDigestAlgorithm == null ? (class$com$systinet$wasp$security$secext$algorithms$MessageDigestAlgorithm = MessageDigestAlgorithm.class$("com.systinet.wasp.security.secext.algorithms.MessageDigestAlgorithm")) : class$com$systinet$wasp$security$secext$algorithms$MessageDigestAlgorithm).getName());
    public static final String ALGO_ID_DIGEST_NOT_RECOMMENDED_MD5 = "http://www.w3.org/2001/04/xmldsig-more#md5";
    public static final String ALGO_ID_DIGEST_SHA1 = "http://www.w3.org/2000/09/xmldsig#sha1";
    public static final String ALGO_ID_DIGEST_SHA256 = "http://www.w3.org/2001/04/xmlenc#sha256";
    public static final String ALGO_ID_DIGEST_SHA384 = "http://www.w3.org/2001/04/xmldsig-more#sha384";
    public static final String ALGO_ID_DIGEST_SHA512 = "http://www.w3.org/2001/04/xmlenc#sha512";
    public static final String ALGO_ID_DIGEST_RIPEMD160 = "http://www.w3.org/2001/04/xmlenc#ripemd160";
    MessageDigest algorithm = null;
    static /* synthetic */ Class class$com$systinet$wasp$security$secext$algorithms$MessageDigestAlgorithm;

    private MessageDigestAlgorithm(Document doc, MessageDigest messageDigest, String algorithmURI) {
        super(doc, algorithmURI);
        this.algorithm = messageDigest;
    }

    public static MessageDigestAlgorithm getInstance(Document doc, String algorithmURI) throws XMLSignatureException {
        MessageDigest md;
        JCEMapper.ProviderIdClass algorithmID = JCEMapper.translateURItoJCEID(algorithmURI);
        try {
            md = MessageDigest.getInstance(algorithmID.getAlgorithmID(), algorithmID.getProviderId());
        }
        catch (NoSuchAlgorithmException ex) {
            Object[] exArgs = new Object[]{algorithmID.getAlgorithmID(), ex.getLocalizedMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", exArgs);
        }
        catch (NoSuchProviderException ex) {
            Object[] exArgs = new Object[]{algorithmID.getProviderId(), ex.getLocalizedMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", exArgs);
        }
        return new MessageDigestAlgorithm(doc, md, algorithmURI);
    }

    public MessageDigest getAlgorithm() {
        return this.algorithm;
    }

    public static boolean isEqual(byte[] digesta, byte[] digestb) {
        return MessageDigest.isEqual(digesta, digestb);
    }

    public byte[] digest() {
        return this.algorithm.digest();
    }

    public byte[] digest(byte[] input) {
        return this.algorithm.digest(input);
    }

    public int digest(byte[] buf, int offset, int len) throws DigestException {
        return this.algorithm.digest(buf, offset, len);
    }

    public String getJCEAlgorithmString() {
        return this.algorithm.getAlgorithm();
    }

    public Provider getJCEProvider() {
        return this.algorithm.getProvider();
    }

    public int getDigestLength() {
        return this.algorithm.getDigestLength();
    }

    public void reset() {
        this.algorithm.reset();
    }

    public void update(byte[] input) {
        this.algorithm.update(input);
    }

    public void update(byte input) {
        this.algorithm.update(input);
    }

    public void update(byte[] buf, int offset, int len) {
        this.algorithm.update(buf, offset, len);
    }

    public String getBaseNamespace() {
        return "http://www.w3.org/2000/09/xmldsig#";
    }

    public String getBaseLocalName() {
        return "DigestMethod";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

