/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.algorithms;

import com.idoox.debug.Category;
import com.systinet.wasp.security.secext.utils.XMLUtils;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import javax.xml.transform.TransformerException;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JCEMapper {
    static Category cat = Category.getCategory((String)(class$com$systinet$wasp$security$secext$algorithms$JCEMapper == null ? (class$com$systinet$wasp$security$secext$algorithms$JCEMapper = JCEMapper.class$("com.systinet.wasp.security.secext.algorithms.JCEMapper")) : class$com$systinet$wasp$security$secext$algorithms$JCEMapper).getName());
    private static Element _providerList = null;
    private static Element _nscontext = null;
    public static final String KEYTYPE_SYMMETRIC_KEY_WRAP = "SymmetricKeyWrap";
    public static final String KEYTYPE_BLOCK_ENCRYPTION = "BlockEncryption";
    public static final String KEYTYPE_KEY_TRANSPORT = "KeyTransport";
    static /* synthetic */ Class class$com$systinet$wasp$security$secext$algorithms$JCEMapper;

    public static void init(Element mappingElement) throws Exception {
        _providerList = mappingElement;
        Document doc = mappingElement.getOwnerDocument();
        _nscontext = XMLUtils.createDSctx(doc, "x", "http://www.xmlsecurity.org/NS/#configuration");
    }

    public static boolean addProvider(String Id) {
        try {
            if (Security.getProvider(Id) == null) {
                Element providerElem = (Element)XPathAPI.selectSingleNode((Node)_providerList, (String)("./x:Providers/x:Provider[@Id='" + Id + "']"), (Node)_nscontext);
                String providerClass = providerElem.getAttributeNS(null, "Class");
                Provider prov = (Provider)Class.forName(providerClass).newInstance();
                if (Security.getProvider(Id) == null) {
                    Security.addProvider(prov);
                    Provider registeredProvider = Security.getProvider(Id);
                    if (registeredProvider != null) {
                        return true;
                    }
                }
            }
        }
        catch (TransformerException ex) {
        }
        catch (ClassNotFoundException ex) {
        }
        catch (IllegalAccessException ex) {
        }
        catch (InstantiationException ex) {
            // empty catch block
        }
        return false;
    }

    public static boolean getProviderIsInClassPath(String providerId) {
        boolean available = false;
        try {
            Element pro = (Element)XPathAPI.selectSingleNode((Node)_providerList, (String)("./x:Providers/x:Provider[@Id='" + providerId + "']"), (Node)_nscontext);
            String providerClass = pro.getAttributeNS(null, "Class");
            Provider prov = (Provider)Class.forName(providerClass).newInstance();
            if (prov != null) {
                available = true;
            }
        }
        catch (TransformerException ex) {
        }
        catch (ClassNotFoundException ex) {
        }
        catch (IllegalAccessException ex) {
        }
        catch (InstantiationException ex) {
            // empty catch block
        }
        return available;
    }

    public static boolean getProviderIsRegisteredAtSecurity(String providerId) {
        Provider prov = Security.getProvider(providerId);
        return prov != null;
    }

    public static ProviderIdClass translateURItoJCEID(String AlgorithmURI) {
        try {
            NodeList providers = XPathAPI.selectNodeList((Node)_providerList, (String)("./x:Algorithms/x:Algorithm[@URI='" + AlgorithmURI + "']/x:ProviderAlgo"), (Node)_nscontext);
            int i = 0;
            while (i < providers.getLength()) {
                Element pro = (Element)providers.item(i);
                String jceName = pro.getAttributeNS(null, "JCEName");
                String providerId = pro.getAttributeNS(null, "ProviderId");
                if (JCEMapper.getProviderIsInClassPath(providerId)) {
                    JCEMapper.addProvider(providerId);
                    ProviderIdClass result = new ProviderIdClass(jceName, providerId);
                    return result;
                }
                ++i;
            }
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
        return null;
    }

    public static ProviderIdClass translateURItoJCEID(String AlgorithmURI, String requestedProviderId) {
        if (!JCEMapper.getProviderIsInClassPath(requestedProviderId)) {
            return null;
        }
        try {
            Element pro = (Element)XPathAPI.selectSingleNode((Node)_providerList, (String)("./x:Algorithms/x:Algorithm[@URI='" + AlgorithmURI + "']/x:ProviderAlgo[@ProviderId='" + requestedProviderId + "']"), (Node)_nscontext);
            String jceName = pro.getAttributeNS(null, "JCEName");
            JCEMapper.addProvider(requestedProviderId);
            ProviderIdClass result = new ProviderIdClass(jceName, requestedProviderId);
            return result;
        }
        catch (TransformerException transformerException) {
            return null;
        }
    }

    public static String getAlgorithmClassFromURI(String AlgorithmURI) {
        try {
            NodeList providers = XPathAPI.selectNodeList((Node)_providerList, (String)("./x:Algorithms/x:Algorithm[@URI='" + AlgorithmURI + "']/x:ProviderAlgo"), (Node)_nscontext);
            int i = 0;
            while (i < providers.getLength()) {
                Element pro = (Element)providers.item(i);
                Attr jceName = pro.getAttributeNodeNS(null, "JCEName");
                ++i;
            }
            return ((Element)providers.item(0)).getAttributeNS(null, "JCEName");
        }
        catch (TransformerException ex) {
            return "";
        }
    }

    public static int getKeyTypeFromURI(String AlgorithmURI) {
        try {
            Attr algoclassAttr = (Attr)XPathAPI.selectSingleNode((Node)_providerList, (String)("./x:Algorithms/x:Algorithm[@URI='" + AlgorithmURI + "']/@AlgorithmClass"), (Node)_nscontext);
            if (algoclassAttr == null) {
                return -1;
            }
            String algoclass = algoclassAttr.getNodeValue();
            if (algoclass.equals(KEYTYPE_BLOCK_ENCRYPTION)) {
                return 3;
            }
            if (algoclass.equals("Mac")) {
                return 3;
            }
            if (algoclass.equals(KEYTYPE_SYMMETRIC_KEY_WRAP)) {
                return 3;
            }
            if (algoclass.equals(KEYTYPE_KEY_TRANSPORT)) {
                return 3;
            }
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
        return -1;
    }

    public static int getKeyLengthFromURI(String AlgorithmURI) {
        try {
            Attr algoclassAttr = (Attr)XPathAPI.selectSingleNode((Node)_providerList, (String)("./x:Algorithms/x:Algorithm[@URI='" + AlgorithmURI + "']/@KeyLength"), (Node)_nscontext);
            if (algoclassAttr != null) {
                return Integer.parseInt(algoclassAttr.getNodeValue());
            }
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
        return 0;
    }

    public static String getJCEKeyAlgorithmFromURI(String AlgorithmURI, String ProviderId) {
        try {
            Attr algoclassAttr = (Attr)XPathAPI.selectSingleNode((Node)_providerList, (String)("./x:Algorithms/x:Algorithm[@URI='" + AlgorithmURI + "']/x:ProviderAlgo[@ProviderId='" + ProviderId + "']/@RequiredKey"), (Node)_nscontext);
            if (algoclassAttr != null) {
                return algoclassAttr.getNodeValue();
            }
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
        return null;
    }

    public static String getJCEIVAlgorithmFromURI(String AlgorithmURI, String ProviderId) {
        try {
            Attr algoclassAttr = (Attr)XPathAPI.selectSingleNode((Node)_providerList, (String)("./x:Algorithms/x:Algorithm[@URI='" + AlgorithmURI + "']/x:ProviderAlgo[@ProviderId='" + ProviderId + "']/@IVJCEName"), (Node)_nscontext);
            if (algoclassAttr != null) {
                return algoclassAttr.getNodeValue();
            }
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
        return null;
    }

    public static String getURIfromKey(Key key, String type) {
        String JCEalgo = key.getAlgorithm();
        String keyLength = new Integer(key.getEncoded().length * 8).toString();
        try {
            Attr URI = (Attr)XPathAPI.selectSingleNode((Node)_providerList, (String)("./x:Algorithms/x:Algorithm[@KeyLength='" + keyLength + "' and @AlgorithmClass='" + type + "']/x:ProviderAlgo[@RequiredKey='" + JCEalgo + "']/../@URI"), (Node)_nscontext);
            if (URI != null) {
                return URI.getNodeValue();
            }
        }
        catch (TransformerException ex) {
            // empty catch block
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class ProviderIdClass {
        private String _algorithmId;
        private String _providerId;

        protected ProviderIdClass(String AlgorithmID, String ProviderId) {
            this._algorithmId = AlgorithmID;
            this._providerId = ProviderId;
        }

        public String getAlgorithmID() {
            return this._algorithmId;
        }

        public String getProviderId() {
            return this._providerId;
        }
    }
}

