/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.xml.security;

import com.idoox.security.util.CertUtil;
import com.idoox.wasp.Constants;
import com.idoox.xml.security.TokenizerProcessor;
import com.idoox.xml.security.TokenizerUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.idoox.util.Base64;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.security.CertificateContent;
import org.idoox.xml.security.KeyContent;
import org.idoox.xml.security.SignatureException;

public class X509CertificateContent
extends KeyContent
implements TokenizerProcessor,
CertificateContent {
    private X509Certificate certificate = null;

    public X509CertificateContent() {
        this.qname = KeyContent.X509CERTIFICATE_KEYCONTENT;
    }

    public void construct(Tokenizer tokenizedKeyContent) throws SignatureException {
        try {
            TokenizerUtil.constructChildrenElements(this, tokenizedKeyContent);
        }
        catch (Exception e) {
            throw new SignatureException("Error creating X509Certificate. " + (e.getMessage() != null ? e.getMessage() : ""), e);
        }
    }

    public KeyContent newInstance() {
        return new X509CertificateContent();
    }

    public void construct(Object keyData) throws SignatureException {
        if (!(keyData instanceof X509Certificate)) {
            throw new SignatureException("The given keyData is not instanceof X509Certificate.");
        }
        this.certificate = (X509Certificate)keyData;
    }

    public boolean constructElement(Tokenizer tokenizer) throws SignatureException {
        try {
            String name = tokenizer.getLocalName();
            if (name.equals("X509Certificate")) {
                String checkCert;
                tokenizer.next();
                String content = tokenizer.readContent();
                ByteArrayInputStream stream = new ByteArrayInputStream(Base64.decode((byte[])content.getBytes(Constants.UTF_8)));
                this.certificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(stream);
                ((InputStream)stream).close();
                tokenizer.next();
                if (this.contentData != null && (checkCert = (String)this.contentData.get("NO_CHECK_TRUSTED_CERTIFICATE")) != null && checkCert.equals("true")) {
                    return true;
                }
                boolean ret = CertUtil.IsCertTrusted((X509Certificate)this.certificate);
                if (!ret) {
                    throw new SignatureException("Certificate is not trusted.");
                }
                return true;
            }
        }
        catch (Exception e) {
            throw new SignatureException("Error creating SignatureCertificate. " + (e.getMessage() != null ? e.getMessage() : ""), e);
        }
        return false;
    }

    public String toCanonicalXMLString(String signaturePrefix) throws SignatureException {
        try {
            byte[] encoded = this.certificate.getEncoded();
            String encodedBase64 = new String(Base64.encode((byte[])encoded, (boolean)false), Constants.UTF_8);
            StringBuffer sb = new StringBuffer();
            String startTag = "";
            String endTag = "";
            if (!signaturePrefix.equals("")) {
                startTag = "<" + signaturePrefix + ":";
                endTag = "</" + signaturePrefix + ":";
            } else {
                startTag = "<";
                endTag = "</";
            }
            sb.append(startTag).append("X509Data>\n");
            sb.append(startTag).append("X509Certificate>");
            sb.append(encodedBase64);
            sb.append(endTag).append("X509Certificate>\n");
            sb.append(endTag).append("X509Data>");
            return sb.toString();
        }
        catch (Exception e) {
            throw new SignatureException("Error creating KeyInfo. " + (e.getMessage() != null ? e.getMessage() : ""), e);
        }
    }

    public PublicKey getPublicKey() throws SignatureException {
        return this.certificate.getPublicKey();
    }

    public Certificate[] getCertificates() {
        return new Certificate[]{this.certificate};
    }
}

