/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.xml.security;

import com.idoox.wasp.Constants;
import com.idoox.xml.security.MessageDigest;
import com.idoox.xml.security.SignatureBase;
import com.idoox.xml.security.TokenizerUtil;
import java.io.UnsupportedEncodingException;
import org.idoox.util.Base64;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.xml.Token;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.security.ReferencedData;
import org.idoox.xml.security.SignatureException;
import org.idoox.xml.security.Transform;

public class Reference
extends SignatureBase {
    private String uri;
    private String id;
    private String digestMethod;
    private String digestValue;
    private Transform[] transforms;
    private ReferencedData dataSource;
    String signaturePrefix = "";

    public Reference(String uri, String id, String digestMethod, Transform[] transforms, ReferencedData dataSource, String signaturePrefix) throws SignatureException {
        this.uri = uri;
        this.id = id;
        this.digestMethod = digestMethod;
        this.transforms = transforms;
        this.dataSource = dataSource;
        this.signaturePrefix = signaturePrefix;
        this.process();
    }

    public Reference(ReferencedData dataSource, Tokenizer tokenizedReference) throws SignatureException {
        this.dataSource = dataSource;
        Token token = new Token();
        try {
            tokenizedReference.readToken(token);
            if (token.prefix != null) {
                this.signaturePrefix = token.prefix;
            }
        }
        catch (Exception e) {
            throw new SignatureException("error constructing Reference", e);
        }
        this.uri = token.getAttributeValue(null, "URI");
        this.id = token.getAttributeValue(null, "ID");
        TokenizerUtil.constructChildrenElements(this, tokenizedReference);
    }

    public boolean constructElement(Tokenizer tokenizer) throws SignatureException {
        try {
            String name = tokenizer.getLocalName();
            Token token = new Token();
            if (name.equals("DigestMethod")) {
                tokenizer.readToken(token);
                this.digestMethod = token.getAttributeValue(null, "Algorithm");
                tokenizer.next();
                return true;
            }
            if (name.equals("DigestValue")) {
                tokenizer.next();
                this.digestValue = tokenizer.readContent();
                tokenizer.next();
                return true;
            }
            if (name.equals("Transforms")) {
                this.createTransforms(tokenizer);
                return true;
            }
        }
        catch (Exception e) {
            throw new SignatureException("Error creating Reference. " + (e.getMessage() != null ? e.getMessage() : ""), e);
        }
        return false;
    }

    private void createTransforms(Tokenizer tokenizedTransforms) throws SignatureException {
        int[] depth = new int[]{0};
        try {
            byte currentState = TokenizerUtil.tokenizerNext(tokenizedTransforms, depth);
            if (currentState == 4) {
                currentState = TokenizerUtil.tokenizerNext(tokenizedTransforms, depth);
            }
            if (currentState != 2) {
                throw new SignatureException("Error creating Transform. Invalid data.");
            }
            int depthCycle = depth[0];
            while (currentState == 2) {
                Token token = new Token();
                String localName = tokenizedTransforms.getLocalName();
                if (!localName.equals("Transform")) {
                    throw new SignatureException("Error creating Transforms. Tag '" + localName + "' not allowed.");
                }
                tokenizedTransforms.readToken(token);
                String transformStr = token.getAttributeValue(null, "Algorithm");
                Transform transform = Transform.getInstance(transformStr);
                this.addTransform(transform);
                currentState = TokenizerUtil.tokenizerNext(tokenizedTransforms, depth);
                currentState = TokenizerUtil.tokenizerNext(tokenizedTransforms, depth);
                while (depth[0] > depthCycle || depth[0] == depthCycle && currentState == 4) {
                    currentState = TokenizerUtil.tokenizerNext(tokenizedTransforms, depth);
                }
            }
        }
        catch (Exception e) {
            throw new SignatureException("Error creating Reference. " + (e.getMessage() != null ? e.getMessage() : ""), e);
        }
    }

    private void process() throws SignatureException {
        if (this.transforms != null) {
            int i = 0;
            while (i < this.transforms.length) {
                this.dataSource = this.transforms[i].transform(this.dataSource);
                ++i;
            }
        }
        try {
            byte[] digestValueBytes = MessageDigest.getInstance(this.digestMethod).digest(this.dataSource.getBytes());
            byte[] digestValueBytes64 = Base64.encode((byte[])digestValueBytes, (boolean)false);
            this.digestValue = new String(digestValueBytes64, Constants.UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
    }

    public String toCanonicalXMLString() throws SignatureException {
        StringBuffer sb = new StringBuffer();
        String startTag = "";
        String endTag = "";
        if (!this.signaturePrefix.equals("")) {
            startTag = "<" + this.signaturePrefix + ":";
            endTag = "</" + this.signaturePrefix + ":";
        } else {
            startTag = "<";
            endTag = "</";
        }
        sb.append(startTag).append("Reference");
        if (this.uri != null) {
            sb.append(" URI=\"" + this.uri + "\"");
        }
        if (this.id != null) {
            sb.append(" Id=\"" + this.id + "\"");
        }
        sb.append(">\n");
        if (this.transforms != null && this.transforms.length > 0) {
            sb.append(startTag).append("Transforms>\n");
            int i = 0;
            while (i < this.transforms.length) {
                sb.append(this.transforms[i].toCanonicalXMLString(this.signaturePrefix));
                ++i;
            }
            sb.append(endTag).append("Transforms>\n");
        }
        sb.append(startTag).append("DigestMethod Algorithm=\"" + this.digestMethod + "\">");
        sb.append(endTag).append("DigestMethod>\n");
        sb.append(startTag).append("DigestValue>" + this.digestValue);
        sb.append(endTag).append("DigestValue>\n");
        sb.append(endTag).append("Reference>\n");
        return sb.toString();
    }

    private void addTransform(Transform trans) {
        if (this.transforms == null || this.transforms.length == 0) {
            this.transforms = new Transform[1];
            this.transforms[0] = trans;
            return;
        }
        Transform[] newTransforms = new Transform[this.transforms.length + 1];
        System.arraycopy(this.transforms, 0, newTransforms, 0, this.transforms.length);
        newTransforms[this.transforms.length] = trans;
        this.transforms = newTransforms;
    }

    public boolean verify() {
        try {
            String orgDigestValue = this.digestValue;
            this.process();
            return orgDigestValue.equals(this.digestValue);
        }
        catch (SignatureException e) {
            return false;
        }
    }
}

