/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.xml.security;

import com.idoox.xml.security.KeyValue;
import com.idoox.xml.security.SignatureBase;
import com.idoox.xml.security.TokenizerUtil;
import java.io.Serializable;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.security.CertificateContent;
import org.idoox.xml.security.KeyContent;
import org.idoox.xml.security.KeyContentFactory;
import org.idoox.xml.security.SignatureException;

public class KeyInfo
extends SignatureBase {
    private String keyName = null;
    KeyContent[] keyContents = null;
    Map keyContentsMap = null;
    String signaturePrefix = "";

    public KeyInfo(String keyName, PublicKey publicKey, X509Certificate certificate, Map keyContentsMap, String signaturePrefix) throws SignatureException {
        this.keyName = keyName;
        this.signaturePrefix = signaturePrefix;
        this.initKeyContents(publicKey, certificate, keyContentsMap);
    }

    private void initKeyContents(PublicKey publicKey, X509Certificate certificate, Map keyContentsMap) throws SignatureException {
        Map propertiesForAll = null;
        if (keyContentsMap != null && keyContentsMap.size() > 0) {
            propertiesForAll = (Map)keyContentsMap.get(KeyContent.ALL_KEYCONTENTS);
            int keyContentsLen = keyContentsMap.size() - (propertiesForAll == null ? 0 : 1);
            if (keyContentsLen > 0) {
                this.keyContents = new KeyContent[keyContentsLen];
                int i = 0;
                Iterator it = keyContentsMap.keySet().iterator();
                while (it.hasNext()) {
                    QName qName = (QName)it.next();
                    if (qName.equals(KeyContent.ALL_KEYCONTENTS)) continue;
                    KeyContent keyContent = KeyContentFactory.getKeyContent(qName);
                    Map keyContentData = (Map)keyContentsMap.get(qName);
                    keyContent.setContentData(keyContentData);
                    Serializable keyData = null;
                    if (certificate != null) {
                        keyData = certificate;
                    } else if (publicKey != null) {
                        keyData = publicKey;
                    }
                    keyContent.construct(keyData);
                    this.keyContents[i++] = keyContent;
                }
            }
        }
        if (this.keyContents == null) {
            if (publicKey != null && publicKey instanceof RSAPublicKey) {
                this.keyContents = new KeyContent[1];
                this.keyContents[0] = KeyContentFactory.getKeyContent(KeyContent.RSA_KEYCONTENT);
                this.keyContents[0].construct(publicKey);
            } else if (publicKey != null && publicKey instanceof DSAPublicKey) {
                this.keyContents = new KeyContent[1];
                this.keyContents[0] = KeyContentFactory.getKeyContent(KeyContent.DSA_KEYCONTENT);
                this.keyContents[0].construct(publicKey);
            } else if (certificate != null) {
                this.keyContents = new KeyContent[1];
                this.keyContents[0] = KeyContentFactory.getKeyContent(KeyContent.X509CERTIFICATE_KEYCONTENT);
                this.keyContents[0].construct(certificate);
            }
        }
        if (propertiesForAll != null && this.keyContents != null) {
            int i = 0;
            while (i < this.keyContents.length) {
                HashMap keyContentData = new HashMap(propertiesForAll);
                if (this.keyContents[i].getContentData() != null) {
                    keyContentData.putAll(this.keyContents[i].getContentData());
                }
                this.keyContents[i].setContentData(keyContentData);
                ++i;
            }
        }
    }

    public KeyInfo(Tokenizer tokenizedKeyInfo, Map keyContentsMap) throws SignatureException {
        this.keyContentsMap = keyContentsMap;
        try {
            TokenizerUtil.constructChildrenElements(this, tokenizedKeyInfo);
        }
        catch (Exception e) {
            throw new SignatureException("Error creating KeyInfo. " + (e.getMessage() != null ? e.getMessage() : ""), e);
        }
    }

    public boolean constructElement(Tokenizer tokenizer) throws SignatureException {
        try {
            String name = tokenizer.getLocalName();
            if (name.equals("KeyValue")) {
                KeyContent[] keyValueContents = KeyValue.getKeyValueContents(tokenizer, this.keyContentsMap);
                this.addKeyContents(keyValueContents);
                return true;
            }
            if (name.equals("KeyName")) {
                tokenizer.next();
                this.keyName = tokenizer.readContent();
                tokenizer.next();
                return true;
            }
            QName qName = new QName(tokenizer.getNamespace(), tokenizer.getLocalName());
            KeyContent keyContent = KeyContentFactory.getKeyContent(qName);
            if (this.keyContentsMap != null) {
                Map contentData = null;
                if (this.keyContentsMap.containsKey(KeyContent.ALL_KEYCONTENTS)) {
                    contentData = (Map)this.keyContentsMap.get(KeyContent.ALL_KEYCONTENTS);
                }
                if (this.keyContentsMap.containsKey(qName)) {
                    if (contentData == null) {
                        contentData = (Map)this.keyContentsMap.get(qName);
                    } else {
                        contentData.putAll((Map)this.keyContentsMap.get(qName));
                    }
                }
                if (contentData != null) {
                    keyContent.setContentData(contentData);
                }
            }
            keyContent.construct(tokenizer);
            KeyContent[] contents = new KeyContent[]{keyContent};
            this.addKeyContents(contents);
            return true;
        }
        catch (Exception e) {
            throw new SignatureException("Error creating KeyInfo. " + (e.getMessage() != null ? e.getMessage() : ""), e);
        }
    }

    public PublicKey getPublicKey() throws SignatureException {
        if (this.keyContents == null || this.keyContents.length == 0) {
            throw new SignatureException("PublicKey cannot be generated.");
        }
        return this.keyContents[0].getPublicKey();
    }

    private void addKeyContents(KeyContent[] contents) {
        if (contents == null || contents.length == 0) {
            return;
        }
        if (this.keyContents == null || this.keyContents.length == 0) {
            this.keyContents = contents;
            return;
        }
        KeyContent[] newKeyContents = new KeyContent[this.keyContents.length + contents.length];
        System.arraycopy(this.keyContents, 0, newKeyContents, 0, this.keyContents.length);
        System.arraycopy(contents, 0, newKeyContents, this.keyContents.length, contents.length);
        this.keyContents = newKeyContents;
    }

    public String toCanonicalXMLString() throws SignatureException {
        if ((this.keyContents == null || this.keyContents.length == 0) && this.keyName == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        String startTag = "";
        String endTag = "";
        if (!this.signaturePrefix.equals("")) {
            startTag = "<" + this.signaturePrefix + ":";
            endTag = "</" + this.signaturePrefix + ":";
        } else {
            startTag = "<";
            endTag = "</";
        }
        sb.append(startTag).append("KeyInfo>\n");
        if (this.keyName != null) {
            sb.append(startTag).append("KeyName>").append(this.keyName).append(endTag).append("KeyName>\n");
        }
        if (this.keyContents != null) {
            int i = 0;
            while (i < this.keyContents.length) {
                sb.append(this.keyContents[i].toCanonicalXMLString(this.signaturePrefix)).append("\n");
                ++i;
            }
        }
        sb.append(endTag).append("KeyInfo>");
        return sb.toString();
    }

    public Certificate[] getCertificates() {
        if (this.keyContents == null || this.keyContents.length == 0) {
            return null;
        }
        ArrayList<Certificate> certs = new ArrayList<Certificate>();
        int i = 0;
        while (i < this.keyContents.length) {
            Certificate[] newCerts;
            if (this.keyContents[i] instanceof CertificateContent && (newCerts = ((CertificateContent)((Object)this.keyContents[i])).getCertificates()) != null && newCerts.length != 0) {
                int j = 0;
                while (j < newCerts.length) {
                    if (newCerts[j] != null) {
                        certs.add(newCerts[j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (certs.size() != 0) {
            return certs.toArray(new Certificate[0]);
        }
        return null;
    }
}

