/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.xml.security;

import com.idoox.wasp.Constants;
import com.idoox.xml.security.SignatureValue;
import com.idoox.xml.security.SignedInfo;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import org.idoox.util.Base64;
import org.idoox.xml.security.SignatureException;

public class HmacSignatureValue
extends SignatureValue {
    public HmacSignatureValue() {
        this.signatureAlgorithmId = "HmacSHA1";
    }

    public String getSignatureValue(SignedInfo signedInfo, SecretKey secretKey) throws SignatureException {
        try {
            Mac mac = Mac.getInstance(this.signatureAlgorithmId);
            mac.init(secretKey);
            mac.update(signedInfo.getBytes());
            byte[] bytesValue = mac.doFinal();
            return new String(Base64.encode((byte[])bytesValue, (boolean)false), Constants.UTF_8);
        }
        catch (Exception e) {
            throw new SignatureException("Error creating Signature. " + (e.getMessage() != null ? e.getMessage() : ""), e);
        }
    }
}

