/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.xml.security;

import com.idoox.wasp.Constants;
import com.idoox.xml.security.TokenizerProcessor;
import com.idoox.xml.security.TokenizerUtil;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import org.idoox.util.Base64;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.security.KeyContent;
import org.idoox.xml.security.KeyValueContent;
import org.idoox.xml.security.SignatureException;

public class DSAKeyContent
extends KeyValueContent
implements TokenizerProcessor {
    private BigInteger P;
    private BigInteger Q;
    private BigInteger G;
    private BigInteger Y;

    public DSAKeyContent() {
        this.qname = KeyContent.DSA_KEYCONTENT;
    }

    public void construct(Tokenizer tokenizedKeyContent) throws SignatureException {
        TokenizerUtil.constructChildrenElements(this, tokenizedKeyContent);
    }

    public void construct(Object keyData) throws SignatureException {
        if (!(keyData instanceof DSAPublicKey)) {
            throw new SignatureException("the given key is not DSAPublicKey");
        }
        DSAPublicKey dsaPublicKey = (DSAPublicKey)keyData;
        this.P = dsaPublicKey.getParams().getP();
        this.Q = dsaPublicKey.getParams().getQ();
        this.G = dsaPublicKey.getParams().getG();
        this.Y = dsaPublicKey.getY();
    }

    public boolean constructElement(Tokenizer tokenizer) throws SignatureException {
        try {
            String name = tokenizer.getLocalName();
            if (name.equals("P")) {
                tokenizer.next();
                String PStr = tokenizer.readContent();
                this.P = new BigInteger(1, Base64.decode((byte[])PStr.getBytes(Constants.UTF_8)));
                tokenizer.next();
                return true;
            }
            if (name.equals("Q")) {
                tokenizer.next();
                String QStr = tokenizer.readContent();
                this.Q = new BigInteger(1, Base64.decode((byte[])QStr.getBytes(Constants.UTF_8)));
                tokenizer.next();
                return true;
            }
            if (name.equals("G")) {
                tokenizer.next();
                String GStr = tokenizer.readContent();
                this.G = new BigInteger(1, Base64.decode((byte[])GStr.getBytes(Constants.UTF_8)));
                tokenizer.next();
                return true;
            }
            if (name.equals("Y")) {
                tokenizer.next();
                String YStr = tokenizer.readContent();
                this.Y = new BigInteger(1, Base64.decode((byte[])YStr.getBytes(Constants.UTF_8)));
                tokenizer.next();
                return true;
            }
        }
        catch (Exception e) {
            throw new SignatureException("Error creating DSAKezValue. " + (e.getMessage() != null ? e.getMessage() : ""), e);
        }
        return false;
    }

    public String toCanonicalXMLString(String signaturePrefix) throws SignatureException {
        try {
            byte[] encodedByteArray = null;
            StringBuffer sb = new StringBuffer();
            String startTag = "";
            String endTag = "";
            if (!signaturePrefix.equals("")) {
                startTag = "<" + signaturePrefix + ":";
                endTag = "</" + signaturePrefix + ":";
            } else {
                startTag = "<";
                endTag = "</";
            }
            sb.append(startTag).append("KeyValue>\n");
            sb.append(startTag).append("DSAKeyValue>\n");
            if (this.P != null) {
                sb.append(startTag).append("P>");
                encodedByteArray = Base64.encode((byte[])this.P.toByteArray(), (boolean)false);
                sb.append(new String(encodedByteArray, Constants.UTF_8));
                sb.append(endTag).append("P>\n");
            }
            if (this.Q != null) {
                sb.append(startTag).append("Q>");
                encodedByteArray = Base64.encode((byte[])this.Q.toByteArray(), (boolean)false);
                sb.append(new String(encodedByteArray, Constants.UTF_8));
                sb.append(endTag).append("Q>\n");
            }
            if (this.G != null) {
                sb.append(startTag).append("G>");
                encodedByteArray = Base64.encode((byte[])this.G.toByteArray(), (boolean)false);
                sb.append(new String(encodedByteArray, Constants.UTF_8));
                sb.append(endTag).append("G>\n");
            }
            if (this.Y != null) {
                sb.append(startTag).append("Y>");
                encodedByteArray = Base64.encode((byte[])this.Y.toByteArray(), (boolean)false);
                sb.append(new String(encodedByteArray, Constants.UTF_8));
                sb.append(endTag).append("Y>\n");
            }
            sb.append(endTag).append("DSAKeyValue>\n");
            sb.append(endTag).append("KeyValue>");
            return sb.toString();
        }
        catch (Exception e) {
            throw new SignatureException("Error creating DSAKezValue. " + (e.getMessage() != null ? e.getMessage() : ""), e);
        }
    }

    public PublicKey getPublicKey() throws SignatureException {
        try {
            DSAPublicKeySpec pkspec = new DSAPublicKeySpec(this.Y, this.P, this.Q, this.G);
            KeyFactory dsaFactory = KeyFactory.getInstance("DSA");
            PublicKey pk = dsaFactory.generatePublic(pkspec);
            return pk;
        }
        catch (Exception e) {
            throw new SignatureException("Error getPublicKey DSAKeyValue. " + (e.getMessage() != null ? e.getMessage() : ""), e);
        }
    }

    public KeyContent newInstance() {
        return new DSAKeyContent();
    }
}

