/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.security.soapauth;

import com.idoox.wasp.security.soapauth.AuthenticationHelper;
import com.idoox.wasp.security.soapauth.BasicAuthData;
import com.idoox.wasp.security.soapauth.BasicAuthHeaderElement;
import com.idoox.wasp.security.soapauth.BasicChallengeHeaderElement;
import java.io.IOException;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.idoox.security.pstore.BadPasswordException;
import org.idoox.security.pstore.PStore;
import org.idoox.security.pstore.UserStore;
import org.idoox.wasp.SoapFaultException;
import org.idoox.xml.TokenizerException;
import org.idoox.xmlrpc.Message;
import org.idoox.xmlrpc.MessageProcessingException;
import org.idoox.xmlrpc.MultipleHeadersException;

public class ServerBasicAuthentication {
    public static void processInput(Message message) throws BadPasswordException, TokenizerException, IOException, MessageProcessingException, MultipleHeadersException {
        BasicAuthHeaderElement authEl = BasicAuthHeaderElement.getBasicAuthHeaderElement(message);
        if (authEl != null) {
            ServerBasicAuthentication.replyChallenge(message, authEl);
            return;
        }
        ServerBasicAuthentication.sendChallenge(message);
    }

    private static void sendChallenge(Message message) throws IOException, TokenizerException, MessageProcessingException {
        BasicAuthData authData = (BasicAuthData)AuthenticationHelper.getServerAuthData();
        BasicChallengeHeaderElement chall = new BasicChallengeHeaderElement(authData.getRealm());
        message.addHeader(chall.getTokenizer());
        QName faultCode = new QName("http://schemas.xmlsoap.org/soap/encoding/", "Client");
        String faultString = "Authentication failed: missing, malformed, or invalid credentials";
        throw new SoapFaultException(faultCode, null, faultString, null, null, null);
    }

    private static void replyChallenge(Message message, BasicAuthHeaderElement authEl) throws BadPasswordException, TokenizerException, IOException, MessageProcessingException {
        PStore pstore = PStore.getInstance(null);
        UserStore userStore = pstore.getUserStore();
        HashMap<String, String> prop = new HashMap<String, String>(1);
        prop.put("password", authEl.getPassword());
        if (userStore.hasUser(authEl.getUserName(), prop)) {
            return;
        }
        ServerBasicAuthentication.sendChallenge(message);
    }
}

