/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.security.soapauth;

import com.idoox.wasp.security.soapauth.AuthData;
import com.idoox.wasp.security.soapauth.AuthErrorCode;
import com.idoox.wasp.security.soapauth.BasicAuthData;
import com.idoox.wasp.security.soapauth.DigestAuthData;

public class AuthenticationHelper {
    private static ThreadLocal clientAuthData = new ThreadLocal();
    public static final String AUTH_DATA = "SOAP_AUTH_DATA";

    public static boolean startClientAuthSession(Object service, String userName, String password, AuthErrorCode[] errorCodeHolder, byte authType) {
        if (authType == 0) {
            return AuthenticationHelper.startClientDigestAuthSession(service, userName, password, errorCodeHolder);
        }
        if (authType == 1) {
            return AuthenticationHelper.startClientBasicAuthSession(service, userName, password, errorCodeHolder);
        }
        return authType == 2;
    }

    public static void endClientAuthSession(Object service) {
        AuthenticationHelper.setClientAuthData(service, null);
    }

    static AuthData getClientAuthData(Object service) {
        return (AuthData)clientAuthData.get();
    }

    public static void setServerAuthType(byte authType) {
    }

    static AuthData getServerAuthData() {
        return new BasicAuthData();
    }

    private static void setClientAuthData(Object service, AuthData authData) {
        clientAuthData.set(authData);
    }

    private static boolean startClientBasicAuthSession(Object service, String userName, String password, AuthErrorCode[] errorCodeHolder) {
        BasicAuthData authData = new BasicAuthData();
        authData.setAuthType((byte)1);
        authData.setUserName(userName);
        authData.setPassword(password);
        AuthenticationHelper.setClientAuthData(service, authData);
        return true;
    }

    private static boolean startClientDigestAuthSession(Object service, String userName, String password, AuthErrorCode[] errorCodeHolder) {
        DigestAuthData authData = new DigestAuthData();
        try {
            authData.setNextAction((byte)1);
            authData.setAuthType((byte)0);
            AuthenticationHelper.setClientAuthData(service, authData);
            Object message = null;
            message.send();
            return true;
        }
        catch (Exception e) {
            if (errorCodeHolder != null && errorCodeHolder.length > 0) {
                errorCodeHolder[0] = authData.getErrorCode();
            }
            AuthenticationHelper.setClientAuthData(service, null);
            return false;
        }
    }
}

