/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.security.server;

import com.idoox.debug.Category;
import com.idoox.wasp.Constants;
import com.idoox.wasp.config.SecurityModuleConfig;
import com.idoox.wasp.security.SecurityProvidersConfigs;
import com.idoox.wasp.server.config.ServiceBindingConfig;
import java.security.NoSuchProviderException;
import org.idoox.config.Configurable;
import org.idoox.config.Configurator;
import org.idoox.security.Credentials;
import org.idoox.wasp.Context;
import org.idoox.wasp.WaspSecurity;
import org.systinet.wasp.webservice.PublishException;
import org.systinet.wasp.webservice.ServiceEndpoint;
import org.systinet.wasp.webservice.ServiceEndpointContext;
import org.systinet.wasp.webservice.ServiceEndpointListener;

public class InitializeSecurityListener
implements ServiceEndpointListener {
    private static final String NO_DEFAULT = "no";
    private static final Category log = Category.getCategory((String)"com.idoox.wasp.security.server.InitializeSecurityListener");
    static /* synthetic */ Class class$com$idoox$wasp$server$config$ServiceBindingConfig;
    static /* synthetic */ Class class$com$idoox$wasp$security$SecurityProvidersConfigs;
    static /* synthetic */ Class class$com$idoox$wasp$config$SecurityModuleConfig;

    public void onUnpublish(ServiceEndpoint serviceEndpoint) throws PublishException {
    }

    public void onPublish(ServiceEndpoint endpoint) throws PublishException {
        if (this.configureSecurity(endpoint)) {
            return;
        }
        this.defaultConfig(endpoint);
    }

    private boolean configureSecurity(ServiceEndpoint endpoint) {
        boolean mediatorRequired;
        ServiceBindingConfig.IdentityAssociation[] iasocs;
        ServiceEndpointContext wsC = endpoint.getContext();
        String uri = endpoint.getPath();
        Configurator configurator = (Configurator)Context.getInstance((String)"org.idoox.config.Configurator");
        Configurable conf = null;
        switch (endpoint.getServiceType()) {
            case 0: 
            case 1: {
                conf = Configurator.getConfigurable((String)"ServiceBinding", (String)uri);
                break;
            }
            case 2: {
                conf = Configurator.getConfigurable((String)"GetServiceBinding", (String)uri);
                break;
            }
            default: {
                conf = Configurator.getConfigurable((String)"ServiceBinding", (String)uri);
                if (conf == null) break;
                conf = Configurator.getConfigurable((String)"GetServiceBinding", (String)uri);
            }
        }
        if (conf == null) {
            return false;
        }
        ServiceBindingConfig siCfg = (ServiceBindingConfig)conf.narrow(class$com$idoox$wasp$server$config$ServiceBindingConfig == null ? (class$com$idoox$wasp$server$config$ServiceBindingConfig = InitializeSecurityListener.class$("com.idoox.wasp.server.config.ServiceBindingConfig")) : class$com$idoox$wasp$server$config$ServiceBindingConfig);
        String initSecProvider = WaspSecurity.getInitiatingProvider((ServiceEndpointContext)wsC);
        if (initSecProvider == null) {
            initSecProvider = siCfg.getInitiatingSecurityProvider();
            if (initSecProvider != null) {
                if (initSecProvider.length() > 0 && !initSecProvider.equals(NO_DEFAULT)) {
                    try {
                        WaspSecurity.setInitiatingProvider((ServiceEndpointContext)wsC, (String)initSecProvider);
                    }
                    catch (NoSuchProviderException e) {
                        throw new RuntimeException("security provider " + initSecProvider + " not found");
                    }
                }
            } else {
                this.defaultInitiatingConfig(wsC);
            }
        }
        String[] providers = WaspSecurity.getAcceptingProviders((ServiceEndpointContext)wsC);
        providers = siCfg.getAcceptingSecurityProviders();
        if (providers.length != 0) {
            if (providers.length != 1 || providers[0] != null && providers[0].length() != 0 && !providers[0].equals(NO_DEFAULT)) {
                try {
                    WaspSecurity.setAcceptingProviders((ServiceEndpointContext)wsC, (String[])providers);
                }
                catch (NoSuchProviderException e) {
                    throw new RuntimeException("security provider not found " + (e.getMessage() != null ? e.getMessage() : ""));
                }
            }
        } else {
            this.defaultAcceptingConfig(wsC);
        }
        if ((iasocs = siCfg.getIdentityAssociations()) != null) {
            int numCreds = 0;
            Credentials[] toSet = new Credentials[1];
            int i = 0;
            while (i < iasocs.length) {
                String providerName = iasocs[i].getProviderName();
                String name = iasocs[i].getIdentityName();
                byte[] password = iasocs[i].getPassword();
                if (providerName != null && name != null) {
                    Credentials creds = null;
                    try {
                        creds = WaspSecurity.acquireServerCredentials((String)name, (String)new String(password, Constants.UTF_8), (String)providerName);
                    }
                    catch (Exception e) {
                        log.error("Unable to associate identity with a web service - authentication failure, endpoint " + endpoint.getPath() + " ,providerName: " + iasocs[i].getProviderName());
                    }
                    if (toSet.length == numCreds) {
                        Credentials[] newSet = new Credentials[numCreds * 2];
                        System.arraycopy(toSet, 0, newSet, 0, numCreds);
                        toSet = newSet;
                    }
                    toSet[numCreds] = creds;
                    ++numCreds;
                } else {
                    log.error("Unable to associate identity with a web service endpoint- required parameters are missing, endpoint path: " + endpoint.getPath() + " ,providerName: " + iasocs[i].getProviderName());
                }
                ++i;
            }
            if (numCreds > 0) {
                if (toSet.length != numCreds) {
                    Credentials[] newSet = new Credentials[numCreds];
                    System.arraycopy(toSet, 0, newSet, 0, numCreds);
                    toSet = newSet;
                }
                WaspSecurity.setCredentials((ServiceEndpointContext)wsC, (Credentials[])toSet);
            }
        }
        try {
            mediatorRequired = siCfg.isAuthorizationRequired();
        }
        catch (Exception e) {
            mediatorRequired = false;
        }
        try {
            WaspSecurity.setAuthorizationRequired((ServiceEndpointContext)wsC, (boolean)mediatorRequired);
        }
        catch (NoSuchProviderException e) {
            log.error("Unable to set authorization required for endpoint path: " + endpoint.getPath(), (Throwable)e);
        }
        SecurityProvidersConfigs providersConfigs = (SecurityProvidersConfigs)conf.narrow(class$com$idoox$wasp$security$SecurityProvidersConfigs == null ? (class$com$idoox$wasp$security$SecurityProvidersConfigs = InitializeSecurityListener.class$("com.idoox.wasp.security.SecurityProvidersConfigs")) : class$com$idoox$wasp$security$SecurityProvidersConfigs);
        SecurityProvidersConfigs.ProviderConfigBase[] providersBases = null;
        try {
            providersBases = providersConfigs.getSecurityProviderPreferences();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (providersBases != null && providersBases.length > 0) {
            int i = 0;
            while (i < providersBases.length) {
                block37: {
                    String providerName = null;
                    try {
                        providerName = providersBases[i].getLocalName();
                    }
                    catch (Exception e) {
                        break block37;
                    }
                    Configurable providerConfigurable = Configurator.getConfigurable((Object)providersBases[i]);
                    try {
                        WaspSecurity.setProviderProperties((ServiceEndpointContext)wsC, (Configurable)providerConfigurable, (String)providerName);
                    }
                    catch (NoSuchProviderException e) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        return true;
    }

    private void defaultInitiatingConfig(ServiceEndpointContext endpointContext) {
        Configurator configurator = (Configurator)Context.getInstance((String)"org.idoox.config.Configurator");
        Configurable c = Configurator.getConfigurable((String)"securityPreferences", (String)"main");
        if (c == null) {
            return;
        }
        SecurityModuleConfig config = (SecurityModuleConfig)c.narrow(class$com$idoox$wasp$config$SecurityModuleConfig == null ? (class$com$idoox$wasp$config$SecurityModuleConfig = InitializeSecurityListener.class$("com.idoox.wasp.config.SecurityModuleConfig")) : class$com$idoox$wasp$config$SecurityModuleConfig);
        String initSecProvider = null;
        try {
            initSecProvider = config.getInitiatingSecurityProvider();
            if (initSecProvider != null) {
                WaspSecurity.setInitiatingProvider((ServiceEndpointContext)endpointContext, (String)initSecProvider);
            }
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeException("security provider " + initSecProvider + " not found");
        }
    }

    private void defaultAcceptingConfig(ServiceEndpointContext endpointContext) {
        Configurator configurator = (Configurator)Context.getInstance((String)"org.idoox.config.Configurator");
        Configurable c = Configurator.getConfigurable((String)"securityPreferences", (String)"main");
        if (c == null) {
            return;
        }
        SecurityModuleConfig config = (SecurityModuleConfig)c.narrow(class$com$idoox$wasp$config$SecurityModuleConfig == null ? (class$com$idoox$wasp$config$SecurityModuleConfig = InitializeSecurityListener.class$("com.idoox.wasp.config.SecurityModuleConfig")) : class$com$idoox$wasp$config$SecurityModuleConfig);
        try {
            String[] providers = config.getAcceptingSecurityProviders();
            if (providers != null && providers.length > 0 && providers[0] != null && !providers[0].equals(NO_DEFAULT)) {
                WaspSecurity.setAcceptingProviders((ServiceEndpointContext)endpointContext, (String[])providers);
            }
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeException("security provider not found " + (e.getMessage() != null ? e.getMessage() : ""));
        }
    }

    private void defaultConfig(ServiceEndpoint endpoint) {
        String[] providers;
        Configurator configurator = (Configurator)Context.getInstance((String)"org.idoox.config.Configurator");
        Configurable c = Configurator.getConfigurable((String)"securityPreferences", (String)"main");
        if (c == null) {
            return;
        }
        SecurityModuleConfig config = (SecurityModuleConfig)c.narrow(class$com$idoox$wasp$config$SecurityModuleConfig == null ? (class$com$idoox$wasp$config$SecurityModuleConfig = InitializeSecurityListener.class$("com.idoox.wasp.config.SecurityModuleConfig")) : class$com$idoox$wasp$config$SecurityModuleConfig);
        String iniProvider = WaspSecurity.getInitiatingProvider((ServiceEndpointContext)endpoint.getContext());
        if (iniProvider == null) {
            try {
                iniProvider = config.getInitiatingSecurityProvider();
                if (iniProvider != null && !iniProvider.equals(NO_DEFAULT)) {
                    WaspSecurity.setInitiatingProvider((ServiceEndpointContext)endpoint.getContext(), (String)iniProvider);
                }
            }
            catch (NoSuchProviderException e) {
                throw new RuntimeException("security provider " + iniProvider + " not found");
            }
        }
        if ((providers = WaspSecurity.getAcceptingProviders((ServiceEndpointContext)endpoint.getContext())) != null && providers.length <= 0) {
            try {
                providers = config.getAcceptingSecurityProviders();
                if (providers.length != 0 && providers[0] != null && providers[0].length() != 0 && !providers[0].equals(NO_DEFAULT)) {
                    WaspSecurity.setAcceptingProviders((ServiceEndpointContext)endpoint.getContext(), (String[])providers);
                }
            }
            catch (NoSuchProviderException e) {
                throw new RuntimeException("security provider not found " + (e.getMessage() != null ? e.getMessage() : ""));
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

