/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.security.kerberos.utils.asn1;

import com.idoox.wasp.security.kerberos.utils.asn1.BigInt;
import com.idoox.wasp.security.kerberos.utils.asn1.BitArray;
import com.idoox.wasp.security.kerberos.utils.asn1.DerIndefLenConverter;
import com.idoox.wasp.security.kerberos.utils.asn1.DerInputBuffer;
import com.idoox.wasp.security.kerberos.utils.asn1.DerInputStream;
import com.idoox.wasp.security.kerberos.utils.asn1.DerOutputStream;
import com.idoox.wasp.security.kerberos.utils.asn1.ObjectIdentifier;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public class DerValue {
    public static final byte TAG_UNIVERSAL = 0;
    public static final byte TAG_APPLICATION = 64;
    public static final byte TAG_CONTEXT = -128;
    public static final byte TAG_PRIVATE = -64;
    public byte tag;
    protected DerInputBuffer buffer;
    public DerInputStream data;
    private int length;
    public static final byte tag_Boolean = 1;
    public static final byte tag_Integer = 2;
    public static final byte tag_BitString = 3;
    public static final byte tag_OctetString = 4;
    public static final byte tag_Null = 5;
    public static final byte tag_ObjectId = 6;
    public static final byte tag_Enumerated = 10;
    public static final byte tag_UTF8String = 12;
    public static final byte tag_PrintableString = 19;
    public static final byte tag_T61String = 20;
    public static final byte tag_IA5String = 22;
    public static final byte tag_UtcTime = 23;
    public static final byte tag_GeneralizedTime = 24;
    public static final byte tag_GeneralString = 27;
    public static final byte tag_UniversalString = 28;
    public static final byte tag_BMPString = 30;
    public static final byte tag_Sequence = 48;
    public static final byte tag_SequenceOf = 48;
    public static final byte tag_Set = 49;
    public static final byte tag_SetOf = 49;

    public boolean isUniversal() {
        return (this.tag & 0xC0) == 0;
    }

    public boolean isApplication() {
        return (this.tag & 0xC0) == 64;
    }

    public boolean isContextSpecific() {
        return (this.tag & 0xC0) == 128;
    }

    public boolean isContextSpecific(byte byte0) {
        if (!this.isContextSpecific()) {
            return false;
        }
        return (this.tag & 0x1F) == byte0;
    }

    boolean isPrivate() {
        return (this.tag & 0xC0) == 192;
    }

    public boolean isConstructed() {
        return (this.tag & 0x20) == 32;
    }

    public boolean isConstructed(byte byte0) {
        if (!this.isConstructed()) {
            return false;
        }
        return (this.tag & 0x1F) == byte0;
    }

    public DerValue(String s) throws IOException {
        boolean flag = true;
        int i = 0;
        while (i < s.length()) {
            if (!DerValue.isPrintableStringChar(s.charAt(i))) {
                flag = false;
                break;
            }
            ++i;
        }
        this.init(flag ? (byte)19 : 12, s);
    }

    public DerValue(byte byte0, String s) throws IOException {
        this.init(byte0, s);
    }

    public DerValue(byte byte0, byte[] abyte0) {
        this.tag = byte0;
        this.buffer = new DerInputBuffer((byte[])abyte0.clone());
        this.length = abyte0.length;
        this.data = new DerInputStream(this.buffer);
        this.data.mark(Integer.MAX_VALUE);
    }

    DerValue(DerInputBuffer derinputbuffer) throws IOException {
        this.tag = (byte)derinputbuffer.read();
        this.length = DerInputStream.getLength(derinputbuffer);
        if (this.length == -1) {
            derinputbuffer.reset();
            byte[] abyte0 = new byte[derinputbuffer.available()];
            DataInputStream datainputstream = new DataInputStream(derinputbuffer);
            datainputstream.readFully(abyte0);
            datainputstream.close();
            DerIndefLenConverter derindeflenconverter = new DerIndefLenConverter();
            derinputbuffer = new DerInputBuffer(derindeflenconverter.convert(abyte0));
            if (this.tag != derinputbuffer.read()) {
                throw new IOException("Indefinite length encoding not supported");
            }
            this.length = DerInputStream.getLength(derinputbuffer);
        }
        this.buffer = derinputbuffer.dup();
        this.buffer.truncate(this.length);
        this.data = new DerInputStream(this.buffer);
        derinputbuffer.skip(this.length);
    }

    public DerValue(byte[] abyte0) throws IOException {
        this.init(true, new ByteArrayInputStream(abyte0));
    }

    public DerValue(byte[] abyte0, int i, int j) throws IOException {
        this.init(true, new ByteArrayInputStream(abyte0, i, j));
    }

    public DerValue(InputStream inputstream) throws IOException {
        this.init(false, inputstream);
    }

    private void init(byte byte0, String s) throws IOException {
        String s1 = null;
        this.tag = byte0;
        switch (byte0) {
            case 19: 
            case 22: 
            case 27: {
                s1 = "ASCII";
                break;
            }
            case 20: {
                s1 = "ISO-8859-1";
                break;
            }
            case 30: {
                s1 = "UnicodeBigUnmarked";
                break;
            }
            case 12: {
                s1 = "UTF8";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported DER string type");
            }
        }
        byte[] abyte0 = s.getBytes(s1);
        this.length = abyte0.length;
        this.buffer = new DerInputBuffer(abyte0);
        this.data = new DerInputStream(this.buffer);
        this.data.mark(Integer.MAX_VALUE);
    }

    private void init(boolean flag, InputStream inputstream) throws IOException {
        this.tag = (byte)inputstream.read();
        byte byte0 = (byte)inputstream.read();
        this.length = DerInputStream.getLength(byte0 & 0xFF, inputstream);
        if (this.length == -1) {
            int i = inputstream.available();
            int byte1 = 2;
            byte[] abyte1 = new byte[i + byte1];
            abyte1[0] = this.tag;
            abyte1[1] = byte0;
            DataInputStream datainputstream1 = new DataInputStream(inputstream);
            datainputstream1.readFully(abyte1, byte1, i);
            datainputstream1.close();
            DerIndefLenConverter derindeflenconverter = new DerIndefLenConverter();
            inputstream = new ByteArrayInputStream(derindeflenconverter.convert(abyte1));
            if (this.tag != inputstream.read()) {
                throw new IOException("Indefinite length encoding not supported");
            }
            this.length = DerInputStream.getLength(inputstream);
        }
        if (this.length == 0) {
            return;
        }
        if (flag && inputstream.available() != this.length) {
            throw new IOException("extra data given to DerValue constructor");
        }
        byte[] abyte0 = new byte[this.length];
        DataInputStream datainputstream = new DataInputStream(inputstream);
        datainputstream.readFully(abyte0);
        this.buffer = new DerInputBuffer(abyte0);
        this.data = new DerInputStream(this.buffer);
    }

    public void encode(DerOutputStream deroutputstream) throws IOException {
        deroutputstream.write(this.tag);
        deroutputstream.putLength(this.length);
        if (this.length > 0) {
            byte[] abyte0 = new byte[this.length];
            DerInputBuffer derInputBuffer = this.buffer;
            synchronized (derInputBuffer) {
                this.buffer.reset();
                if (this.buffer.read(abyte0) != this.length) {
                    throw new IOException("short DER value read (encode)");
                }
                deroutputstream.write(abyte0);
            }
        }
    }

    public final DerInputStream getData() {
        return this.data;
    }

    public final byte getTag() {
        return this.tag;
    }

    public boolean getBoolean() throws IOException {
        if (this.tag != 1) {
            throw new IOException("DerValue.getBoolean, not a BOOLEAN " + this.tag);
        }
        if (this.length != 1) {
            throw new IOException("DerValue.getBoolean, invalid length " + this.length);
        }
        return this.buffer.read() != 0;
    }

    public ObjectIdentifier getOID() throws IOException {
        if (this.tag != 6) {
            throw new IOException("DerValue.getOID, not an OID " + this.tag);
        }
        return new ObjectIdentifier(this.buffer);
    }

    private byte[] append(byte[] abyte0, byte[] abyte1) {
        if (abyte0 == null) {
            return abyte1;
        }
        byte[] abyte2 = new byte[abyte0.length + abyte1.length];
        System.arraycopy(abyte0, 0, abyte2, 0, abyte0.length);
        System.arraycopy(abyte1, 0, abyte2, abyte0.length, abyte1.length);
        return abyte2;
    }

    public byte[] getOctetString() throws IOException {
        if (this.tag != 4 && !this.isConstructed((byte)4)) {
            throw new IOException("DerValue.getOctetString, not an Octet String: " + this.tag);
        }
        byte[] abyte0 = new byte[this.length];
        if (this.buffer.read(abyte0) != this.length) {
            throw new IOException("short read on DerValue buffer");
        }
        if (this.isConstructed()) {
            DerInputStream derinputstream = new DerInputStream(abyte0);
            abyte0 = null;
            while (derinputstream.available() != 0) {
                abyte0 = this.append(abyte0, derinputstream.getOctetString());
            }
        }
        return abyte0;
    }

    public BigInt getInteger() throws IOException {
        if (this.tag != 2) {
            throw new IOException("DerValue.getInteger, not an int " + this.tag);
        }
        return this.buffer.getUnsigned(this.data.available());
    }

    public BigInteger getBigInteger() throws IOException {
        if (this.tag != 2) {
            throw new IOException("DerValue.getInteger, not an int " + this.tag);
        }
        return this.buffer.getBigInteger(this.data.available());
    }

    public BigInt getInteger(boolean flag) throws IOException {
        if (!flag && this.tag != 2) {
            throw new IOException("DerValue.getInteger, not an int " + this.tag);
        }
        return this.buffer.getUnsigned(this.data.available());
    }

    public BigInt getEnumerated() throws IOException {
        if (this.tag != 10) {
            throw new IOException("DerValue.getEnumerated, incorrect tag: " + this.tag);
        }
        return this.buffer.getUnsigned(this.data.available());
    }

    public byte[] getBitString() throws IOException {
        if (this.tag != 3) {
            throw new IOException("DerValue.getBitString, not a bit string " + this.tag);
        }
        return this.buffer.getBitString();
    }

    public BitArray getUnalignedBitString() throws IOException {
        if (this.tag != 3) {
            throw new IOException("DerValue.getBitString, not a bit string " + this.tag);
        }
        return this.buffer.getUnalignedBitString();
    }

    public String getAsString() throws IOException {
        if (this.tag == 12) {
            return this.getUTF8String();
        }
        if (this.tag == 19) {
            return this.getPrintableString();
        }
        if (this.tag == 20) {
            return this.getT61String();
        }
        if (this.tag == 22) {
            return this.getIA5String();
        }
        if (this.tag == 30) {
            return this.getBMPString();
        }
        if (this.tag == 27) {
            return this.getGeneralString();
        }
        return null;
    }

    public byte[] getBitString(boolean flag) throws IOException {
        if (!flag && this.tag != 3) {
            throw new IOException("DerValue.getBitString, not a bit string " + this.tag);
        }
        return this.buffer.getBitString();
    }

    public BitArray getUnalignedBitString(boolean flag) throws IOException {
        if (!flag && this.tag != 3) {
            throw new IOException("DerValue.getBitString, not a bit string " + this.tag);
        }
        return this.buffer.getUnalignedBitString();
    }

    public byte[] getDataBytes() throws IOException {
        byte[] abyte0 = new byte[this.length];
        DerInputStream derInputStream = this.data;
        synchronized (derInputStream) {
            this.data.reset();
            this.data.getBytes(abyte0);
        }
        return abyte0;
    }

    public String getPrintableString() throws IOException {
        if (this.tag != 19) {
            throw new IOException("DerValue.getPrintableString, not a string " + this.tag);
        }
        return new String(this.getDataBytes(), "ASCII");
    }

    public String getT61String() throws IOException {
        if (this.tag != 20) {
            throw new IOException("DerValue.getT61String, not T61 " + this.tag);
        }
        return new String(this.getDataBytes(), "ISO-8859-1");
    }

    public String getIA5String() throws IOException {
        if (this.tag != 22) {
            throw new IOException("DerValue.getIA5String, not IA5 " + this.tag);
        }
        return new String(this.getDataBytes(), "ASCII");
    }

    public String getBMPString() throws IOException {
        if (this.tag != 30) {
            throw new IOException("DerValue.getBMPString, not BMP " + this.tag);
        }
        return new String(this.getDataBytes(), "UnicodeBigUnmarked");
    }

    public String getUTF8String() throws IOException {
        if (this.tag != 12) {
            throw new IOException("DerValue.getUTF8String, not UTF-8 " + this.tag);
        }
        return new String(this.getDataBytes(), "UTF8");
    }

    public String getGeneralString() throws IOException {
        if (this.tag != 27) {
            throw new IOException("DerValue.getGeneralString, not GeneralString " + this.tag);
        }
        return new String(this.getDataBytes(), "ASCII");
    }

    public boolean equals(Object obj) {
        if (obj instanceof DerValue) {
            return this.equals((DerValue)obj);
        }
        return false;
    }

    public boolean equals(DerValue dervalue) {
        this.data.reset();
        dervalue.data.reset();
        if (this == dervalue) {
            return true;
        }
        if (this.tag != dervalue.tag) {
            return false;
        }
        return this.buffer.equals(dervalue.buffer);
    }

    public String toString() {
        try {
            String s = this.getAsString();
            if (s != null) {
                return "\"" + s + "\"";
            }
            if (this.tag == 5) {
                return "[DerValue, null]";
            }
            if (this.tag == 6) {
                return "OID." + this.getOID();
            }
            return "[DerValue, tag = " + this.tag + ", length = " + this.length + "]";
        }
        catch (IOException ioexception) {
            throw new IllegalArgumentException("misformatted DER value");
        }
    }

    public byte[] toByteArray() throws IOException {
        DerOutputStream deroutputstream = new DerOutputStream();
        this.encode(deroutputstream);
        this.data.reset();
        return deroutputstream.toByteArray();
    }

    public DerInputStream toDerInputStream() throws IOException {
        if (this.tag == 48 || this.tag == 49) {
            return new DerInputStream(this.buffer);
        }
        throw new IOException("toDerInputStream rejects tag type " + this.tag);
    }

    public int length() {
        return this.length;
    }

    public static boolean isPrintableStringChar(char c) {
        if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
            return true;
        }
        switch (c) {
            case ' ': 
            case '\'': 
            case '(': 
            case ')': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case '/': 
            case ':': 
            case '=': 
            case '?': {
                return true;
            }
        }
        return false;
    }

    public static byte createTag(byte byte0, boolean flag, byte byte1) {
        byte byte2 = (byte)(byte0 | byte1);
        if (flag) {
            byte2 = (byte)(byte2 | 0x20);
        }
        return byte2;
    }

    public void resetTag(byte byte0) {
        this.tag = byte0;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

