/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.security.kerberos.utils.asn1;

import java.io.ByteArrayOutputStream;

public class BitArray {
    private byte[] repn;
    private int length;
    private static final int BITS_PER_UNIT = 8;
    private static final byte[][] NYBBLE = new byte[][]{{48, 48, 48, 48}, {48, 48, 48, 49}, {48, 48, 49, 48}, {48, 48, 49, 49}, {48, 49, 48, 48}, {48, 49, 48, 49}, {48, 49, 49, 48}, {48, 49, 49, 49}, {49, 48, 48, 48}, {49, 48, 48, 49}, {49, 48, 49, 48}, {49, 48, 49, 49}, {49, 49, 48, 48}, {49, 49, 48, 49}, {49, 49, 49, 48}, {49, 49, 49, 49}};
    private static final int BYTES_PER_LINE = 8;

    private static int subscript(int i) {
        return i / 8;
    }

    private static int position(int i) {
        return 1 << 7 - i % 8;
    }

    public BitArray(int i) throws IllegalArgumentException {
        if (i < 0) {
            throw new IllegalArgumentException("Negative length for BitArray");
        }
        this.length = i;
        this.repn = new byte[(i + 8 - 1) / 8];
    }

    public BitArray(int i, byte[] abyte0) throws IllegalArgumentException {
        if (i < 0) {
            throw new IllegalArgumentException("Negative length for BitArray");
        }
        if (abyte0.length * 8 < i) {
            throw new IllegalArgumentException("Byte array too short to represent bit array of given length");
        }
        this.length = i;
        int j = (i + 8 - 1) / 8;
        int k = j * 8 - i;
        byte byte0 = (byte)(255 << k);
        this.repn = new byte[j];
        System.arraycopy(abyte0, 0, this.repn, 0, j);
        this.repn[this.repn.length - 1] = (byte)(this.repn[this.repn.length - 1] & byte0);
    }

    public BitArray(boolean[] aflag) {
        this.length = aflag.length;
        this.repn = new byte[(this.length + 7) / 8];
        int i = 0;
        while (i < this.length) {
            this.set(i, aflag[i]);
            ++i;
        }
    }

    private BitArray(BitArray bitarray) {
        this.length = bitarray.length;
        this.repn = (byte[])bitarray.repn.clone();
    }

    public boolean get(int i) throws ArrayIndexOutOfBoundsException {
        if (i < 0 || i >= this.length) {
            throw new ArrayIndexOutOfBoundsException(Integer.toString(i));
        }
        return (this.repn[BitArray.subscript(i)] & BitArray.position(i)) != 0;
    }

    public void set(int i, boolean flag) throws ArrayIndexOutOfBoundsException {
        if (i < 0 || i >= this.length) {
            throw new ArrayIndexOutOfBoundsException(Integer.toString(i));
        }
        int j = BitArray.subscript(i);
        int k = BitArray.position(i);
        if (flag) {
            int n = j;
            this.repn[n] = (byte)(this.repn[n] | k);
        } else {
            int n = j;
            this.repn[n] = (byte)(this.repn[n] & ~k);
        }
    }

    public int length() {
        return this.length;
    }

    public byte[] toByteArray() {
        return (byte[])this.repn.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof BitArray)) {
            return false;
        }
        BitArray bitarray = (BitArray)obj;
        if (bitarray.length != this.length) {
            return false;
        }
        int i = 0;
        while (i < this.repn.length) {
            if (this.repn[i] != bitarray.repn[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean[] toBooleanArray() {
        boolean[] aflag = new boolean[this.length];
        int i = 0;
        while (i < this.length) {
            aflag[i] = this.get(i);
            ++i;
        }
        return aflag;
    }

    public int hashCode() {
        int i = 0;
        int j = 0;
        while (j < this.repn.length) {
            i = 31 * i + this.repn[j];
            ++j;
        }
        return i ^ this.length;
    }

    public Object clone() {
        return new BitArray(this);
    }

    public String toString() {
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        int i = 0;
        while (i < this.repn.length - 1) {
            bytearrayoutputstream.write(NYBBLE[this.repn[i] >> 4 & 0xF], 0, 4);
            bytearrayoutputstream.write(NYBBLE[this.repn[i] & 0xF], 0, 4);
            if (i % 8 == 7) {
                bytearrayoutputstream.write(10);
            } else {
                bytearrayoutputstream.write(32);
            }
            ++i;
        }
        int j = 8 * (this.repn.length - 1);
        while (j < this.length) {
            bytearrayoutputstream.write(this.get(j) ? 49 : 48);
            ++j;
        }
        return new String(bytearrayoutputstream.toByteArray());
    }
}

