/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.security.kerberos;

import com.idoox.security.CredentialsImpl;
import com.idoox.security.jaas.WaspCallbackHandler;
import com.idoox.wasp.Constants;
import java.io.UnsupportedEncodingException;
import javax.security.auth.callback.CallbackHandler;
import org.idoox.security.AuthResult;
import org.idoox.security.Config;
import org.idoox.security.Credentials;
import org.idoox.security.PrincipalAuthenticator;
import org.idoox.security.pstore.BadPasswordException;
import org.idoox.security.pstore.PStore;
import org.idoox.security.util.RuntimeWrappedException;

public class KrbPrincipalAuthenticator
implements PrincipalAuthenticator {
    public AuthResult authenticate(String securityName, byte[] authData) {
        AuthResult retval = new AuthResult();
        try {
            WaspCallbackHandler handler = new WaspCallbackHandler(securityName, new String(authData, Constants.UTF_8), Config.getId(), PStore.getInstance((String)"").getKeyStore(), PStore.getInstance((String)"").getUserStore());
            CredentialsImpl creds = null;
            creds = securityName != null && securityName.length() > 0 ? new CredentialsImpl(securityName, "Kerberos", "KrbCredentials", (CallbackHandler)handler) : new CredentialsImpl(securityName, "Kerberos", "CachedKrbCredentials", (CallbackHandler)handler);
            if (creds.getAuthenticationStatus() != 0) {
                retval.resultCode = 1;
            } else {
                retval.creds = creds;
                retval.resultCode = 0;
            }
            return retval;
        }
        catch (RuntimeWrappedException e) {
            retval.resultCode = 1;
            retval.errorReason = e;
            return retval;
        }
        catch (RuntimeException e) {
            retval.resultCode = 1;
            retval.errorReason = new RuntimeWrappedException("cannot authenticate", (Throwable)e);
            return retval;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
        catch (BadPasswordException e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
    }

    public AuthResult continueAuthentication(byte[] responseData, Credentials creds) {
        AuthResult retval = new AuthResult();
        retval.resultCode = 1;
        retval.errorReason = new RuntimeWrappedException("KrbPrincipalAuthenticator cannot perform continueAuthentication action.");
        return retval;
    }
}

