/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.security.kerberos;

import com.idoox.debug.Category;
import org.idoox.config.Configurable;
import org.idoox.transport.client.Endpoint;
import org.idoox.wasp.WaspSecurity;
import org.idoox.wasp.security.kerberos.KerberosConfig;
import org.systinet.wasp.webservice.ServiceClient;
import org.systinet.wasp.webservice.ServiceClientContext;

public class KrbConfiguration {
    public static final String SYSTINET_KRB_PRIVATE_STATE = "SYSTINET_KRB_PRIVATE_STATE";
    public static final String SYSTINET_KRB_QOP_VALUE = "SYSTINET_KRB_QOP_VALUE";
    public static final String SYSTINET_KRB_REQ_MIC = "SYSTINET_KRB_REQ_MIC";
    public static final String SYSTINET_KRB_REQ_MUTUAL_AUTH = "SYSTINET_REQ_MUTUAL_AUTH";
    public static final String SYSTINET_KRB_REQ_CONF = "SYSTINET_REQ_CONF";
    public boolean privateState = true;
    public int qop = 0;
    public boolean reqMic = false;
    public boolean reqMutualAuth = true;
    public boolean reqConf = true;
    KerberosConfig properties = null;
    private static final Category log = Category.getCategory((String)"com.idoox.wasp.security.kerberos.KrbConfiguration");
    static /* synthetic */ Class class$org$idoox$wasp$security$kerberos$KerberosConfig;

    public KrbConfiguration(ServiceClientContext scc) {
        Configurable configurable = WaspSecurity.getProviderProperties((ServiceClient)scc.getServiceClient(), (String)"Kerberos");
        KerberosConfig config = null;
        if (configurable != null) {
            config = (KerberosConfig)configurable.narrow(class$org$idoox$wasp$security$kerberos$KerberosConfig == null ? (class$org$idoox$wasp$security$kerberos$KerberosConfig = KrbConfiguration.class$("org.idoox.wasp.security.kerberos.KerberosConfig")) : class$org$idoox$wasp$security$kerberos$KerberosConfig);
            this.mergeConfig(config);
            this.properties = config;
        }
    }

    public KrbConfiguration() {
    }

    private void mergeConfig(KerberosConfig config) {
        if (config != null) {
            try {
                this.privateState = config.getPrivateState();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getServiceName(Endpoint serviceEndpoint) {
        String ret = null;
        String uri = serviceEndpoint.toExternalForm();
        String location = serviceEndpoint.getLocation();
        if (this.properties != null) {
            KerberosConfig.IdentityPreference[] prefs = null;
            try {
                prefs = this.properties.getServiceIdentities();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (prefs != null && prefs.length != 0) {
                int i = 0;
                while (i < prefs.length) {
                    try {
                        if (prefs[i].getUri().equals(uri)) {
                            ret = prefs[i].getIdentity();
                            break;
                        }
                        if (uri.startsWith(prefs[i].getUri())) {
                            ret = prefs[i].getIdentity();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    ++i;
                }
            }
        }
        if (ret == null) {
            ret = location;
            if (ret.startsWith("/")) {
                ret = ret.substring(1);
            }
            if (ret.endsWith("/")) {
                ret = ret.substring(0, ret.length() - 1);
            }
        }
        String serviceRealm = null;
        try {
            if (this.properties != null) {
                serviceRealm = this.properties.getServiceRealm();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (serviceRealm != null && serviceRealm.length() != 0 && ret.indexOf(64) == -1) {
            ret = ret + "@" + serviceRealm;
        }
        return ret;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

