/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.security.interceptor;

import com.idoox.security.util.GSSHelper;
import com.idoox.wasp.security.interceptor.InterceptorBase;
import com.idoox.wasp.security.interceptor.SecureInputMessage;
import com.idoox.wasp.security.interceptor.SecureOutputMessage;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.idoox.config.Configurable;
import org.idoox.security.Config;
import org.idoox.security.Credentials;
import org.idoox.transport.Connection;
import org.idoox.transport.InputMessage;
import org.idoox.transport.OutputMessage;
import org.idoox.transport.TransportMethod;
import org.idoox.transport.client.ClientConnection;
import org.idoox.transport.client.Endpoint;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.wasp.interceptor.InterceptorChain;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.systinet.wasp.webservice.CallContext;
import org.systinet.wasp.webservice.Current;

public class ClientInterceptor
extends InterceptorBase {
    private static Hashtable contexts = new Hashtable(11, 0.75f);
    private GSSManager gss;
    static /* synthetic */ Class class$org$ietf$jgss$GSSCredential;

    public void intercept(Connection connection, InterceptorChain intChain, int pos) {
        GSSName ourName;
        String uriString = connection.getURI().toExternalForm();
        Map map = Current.getServiceClientContext().getContextData();
        Credentials[] creds = (Credentials[])map.get("Stub.credentials");
        if (creds == null || creds.length == 0) {
            creds = org.idoox.security.client.Current.getInstance().getCredentials();
        }
        if (creds == null || creds.length == 0) {
            throw new RuntimeException("No Credentials found.");
        }
        int i = 0;
        while (i < creds.length) {
            if (creds[i].getProviderName().equals("SPKM")) break;
            ++i;
        }
        if (i == creds.length) {
            throw new RuntimeException("No SPKM credentials found");
        }
        Set gssCreds = creds[i].getSubject().getPrivateCredentials(class$org$ietf$jgss$GSSCredential == null ? (class$org$ietf$jgss$GSSCredential = ClientInterceptor.class$("org.ietf.jgss.GSSCredential")) : class$org$ietf$jgss$GSSCredential);
        if (gssCreds == null || gssCreds.isEmpty()) {
            throw new RuntimeException("Unable to get GSSCredential instance from JAAS Subject");
        }
        GSSCredential cred = (GSSCredential)gssCreds.iterator().next();
        try {
            ourName = cred.getName();
        }
        catch (GSSException e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
        String hashedValue = uriString + ourName;
        GSSContext context = (GSSContext)contexts.get(hashedValue);
        if (context == null) {
            try {
                GSSName peerName = this.gss.createName(uriString, GSSName.NT_USER_NAME);
                Endpoint sManagerURI = new Endpoint(uriString);
                sManagerURI.setParameter("select", "session_manager");
                context = this.gss.createContext(peerName, null, cred, 0);
                context.requestConf(true);
                context.requestSequenceDet(true);
                String sessionID = null;
                InputStream inMsg = null;
                while (!context.isEstablished()) {
                    CallContext callContext = Current.getCallContext();
                    Properties lookupProps = (Properties)callContext.getContextData().get("CallContext.lookupProperties");
                    ClientConnection con = sManagerURI.newConnection(TransportMethod.POST, (Map)lookupProps);
                    OutputMessage outMsg = con.getOutputMessage();
                    if (sessionID != null) {
                        outMsg.setStringHeader("x-idoox-sessionID", sessionID);
                    }
                    outMsg.setContentType("application/octet-stream");
                    context.initSecContext(inMsg, (OutputStream)outMsg);
                    if (inMsg != null) {
                        inMsg.close();
                    }
                    outMsg.flush();
                    outMsg.close();
                    inMsg = con.getInputMessage();
                    if (inMsg.getStatusCode() != 200) {
                        throw new RuntimeException("Unable to establish secure channel to: " + uriString + ", server returned: " + inMsg.getStatusCode());
                    }
                    sessionID = inMsg.getStringHeader("x-idoox-sessionID");
                }
                if (inMsg != null) {
                    inMsg.close();
                }
                contexts.put(hashedValue, context);
            }
            catch (Exception e) {
                throw new RuntimeWrappedException("Cannot establish secure channel to: " + uriString, (Throwable)e);
            }
        }
        if (context == null) {
            throw new RuntimeException("Unable to establish secure connection to: " + uriString);
        }
        OutputMessage outMsg = connection.getOutputMessage();
        outMsg.setStringHeader("x-idoox-content-type", "x-idoox/secured");
        connection.setOutputMessage((OutputMessage)new SecureOutputMessage(outMsg, context));
        BufferedInputStream bufIn = new BufferedInputStream((InputStream)connection.getInputMessage());
        connection.setInputMessage((InputMessage)new SecureInputMessage(connection.getInputMessage(), bufIn, context, this, hashedValue));
    }

    public void load(Configurable config) {
        this.gss = GSSHelper.getManager1((String)Config.getId());
    }

    public void destroy() {
    }

    public void removeClientContext(String uri) {
        GSSContext context = (GSSContext)contexts.get(uri);
        if (context != null) {
            try {
                context.dispose();
            }
            catch (GSSException gSSException) {
                // empty catch block
            }
            contexts.remove(uri);
        }
    }

    public static void resetContexts() {
        Iterator it = contexts.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            GSSContext context = (GSSContext)entry.getValue();
            try {
                context.dispose();
            }
            catch (GSSException gSSException) {
                // empty catch block
            }
        }
        contexts.clear();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

