/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.security.http.digest;

import com.idoox.wasp.security.http.digest.ClientInterceptor;
import java.io.IOException;
import org.idoox.security.ContextExpiredException;
import org.idoox.transport.InputMessage;
import org.idoox.transport.InputMessageWrapper;

public class ClientInputMessage
extends InputMessageWrapper {
    ClientInterceptor.Context context;
    boolean initialized = false;

    ClientInputMessage(InputMessage inputMessage, ClientInterceptor.Context context) {
        super(inputMessage);
        this.context = context;
    }

    public int available() throws IOException {
        return super.available();
    }

    public int getStatusCode() throws IOException {
        int statusCode = super.getStatusCode();
        if (statusCode == 401) {
            ClientInterceptor.resetContext(this.context.uri, this.context.userId);
            throw new ContextExpiredException("Server returned error code 401.\nReason: bad password, security context expired or not available.");
        }
        return statusCode;
    }

    public void mark(int readlimit) {
        super.mark(readlimit);
    }

    public boolean markSupported() {
        return super.markSupported();
    }

    public int read() throws IOException {
        this.init();
        return super.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.init();
        return super.read(b, off, len);
    }

    public int read(byte[] b) throws IOException {
        this.init();
        return super.read(b);
    }

    public void reset() throws IOException {
        throw new IOException("Marks are not supported");
    }

    public long skip(long n) throws IOException {
        this.init();
        return super.skip(n);
    }

    private void init() throws IOException {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        String challenge = this.getStringHeader("WWW-Authenticate");
        String peer = this.getStringHeader("Server");
        if (401 == super.getStatusCode()) {
            throw new RuntimeException("Wrong authentication");
        }
        if (challenge == null || challenge.length() == 0) {
            return;
        }
        this.context.setChallenge(challenge, peer);
    }
}

