/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.security.ca;

import com.idoox.security.asn1.Asn1;
import com.idoox.security.asn1.Asn1Exception;
import com.idoox.security.asn1.BitString;
import com.idoox.security.asn1.Constructed;
import com.idoox.security.asn1.Sequence;
import com.idoox.security.util.OID;
import com.idoox.security.x509.AlgorithmId;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class SignaturePOP
extends Sequence {
    private AlgorithmId algId;
    private byte[] signature;

    public SignaturePOP(String algName, byte[] signature) {
        try {
            this.algId = new AlgorithmId(OID.getAlgOid((String)algName));
        }
        catch (Asn1Exception asn1Exception) {
            // empty catch block
        }
        if (this.algId == null) {
            throw new RuntimeException("Invalid algorithm name");
        }
        this.addComponent((Asn1)this.algId);
        this.signature = signature;
        this.addComponent((Asn1)new BitString(this.signature));
    }

    public SignaturePOP(byte[] encoded) throws Asn1Exception {
        ByteArrayInputStream bin = new ByteArrayInputStream(encoded);
        this.init(bin);
    }

    public SignaturePOP(InputStream encoded) throws Asn1Exception {
        this.init(encoded);
    }

    public void init(InputStream encoded) throws Asn1Exception {
        this.doDecode(encoded);
        this.algId = new AlgorithmId(((Sequence)((Constructed)this).components.get(0)).encode());
        this.signature = ((BitString)((Constructed)this).components.get(1)).getBytes();
    }

    public String getSigAlgName() {
        return OID.getAlgName((String)this.algId.getOid());
    }

    public AlgorithmId getSigAlgId() {
        return this.algId;
    }

    public byte[] getSignature() {
        return this.signature;
    }
}

