/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wsdl.xml;

import com.idoox.util.ElementHelper;
import com.idoox.wsdl.DefinitionImpl;
import com.idoox.wsdl.OperationImpl;
import com.idoox.wsdl.PortTypeImpl;
import com.idoox.wsdl.util.WSDLUtil;
import com.idoox.wsdl.util.XmlUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.idoox.transport.InputMessage;
import org.idoox.transport.TransportMethod;
import org.idoox.transport.client.ClientConnection;
import org.idoox.transport.client.Endpoint;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class WSDLReaderImpl
implements WSDLReader {
    public static final String FEATURE_VERBOSE = "javax.wsdl.verbose";
    public static final String FEATURE_IMPORT_DOCUMENTS = "javax.wsdl.importDocuments";
    public static final String FEATURE_STRICT_SYNTAX = "strictSyntax";
    public static final String FEATURE_WSDL_SYNTAX_CHECKING = "WSDLSyntaxChecking";
    protected ExtensionRegistry extReg = null;
    protected String factoryImplName = null;
    protected boolean verbose = true;
    protected boolean importDocuments = true;
    private boolean strictSyntax = false;
    private boolean WSDLSyntaxChecking = true;
    private WSDLLocator wsdlLocator = null;
    static /* synthetic */ Class class$javax$wsdl$Definition;
    static /* synthetic */ Class class$javax$wsdl$Types;
    static /* synthetic */ Class class$javax$wsdl$Binding;
    static /* synthetic */ Class class$javax$wsdl$BindingOperation;
    static /* synthetic */ Class class$javax$wsdl$BindingInput;
    static /* synthetic */ Class class$javax$wsdl$BindingFault;
    static /* synthetic */ Class class$javax$wsdl$Service;
    static /* synthetic */ Class class$javax$wsdl$Port;

    public WSDLReaderImpl() {
        this(false);
    }

    public WSDLReaderImpl(boolean strictSyntax) {
        this.strictSyntax = strictSyntax;
    }

    public void setFeature(String name, boolean value) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Feature name must not be null.");
        }
        if (FEATURE_VERBOSE.equals(name)) {
            this.verbose = value;
        } else if (FEATURE_IMPORT_DOCUMENTS.equals(name)) {
            this.importDocuments = value;
        } else if (FEATURE_STRICT_SYNTAX.equals(name)) {
            this.strictSyntax = value;
        } else if (FEATURE_WSDL_SYNTAX_CHECKING.equals(name)) {
            this.WSDLSyntaxChecking = value;
        } else {
            throw new IllegalArgumentException("Feature name '" + name + "'" + "not recognized");
        }
    }

    public boolean getFeature(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Feature name must not be null.");
        }
        if (FEATURE_VERBOSE.equals(name)) {
            return this.verbose;
        }
        if (FEATURE_IMPORT_DOCUMENTS.equals(name)) {
            return this.importDocuments;
        }
        if (FEATURE_STRICT_SYNTAX.equals(name)) {
            return this.strictSyntax;
        }
        if (FEATURE_WSDL_SYNTAX_CHECKING.equals(name)) {
            return this.WSDLSyntaxChecking;
        }
        throw new IllegalArgumentException("Feature name '" + name + "'" + "not recognized");
    }

    public void setExtensionRegistry(ExtensionRegistry extReg) {
        this.extReg = extReg;
    }

    public ExtensionRegistry getExtensionRegistry() {
        return this.extReg;
    }

    public void setFactoryImplName(String factoryImplName) throws UnsupportedOperationException {
        this.factoryImplName = factoryImplName;
    }

    public String getFactoryImplName() {
        return this.factoryImplName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Definition readWSDL(String contextURI, String wsdlURI) throws WSDLException {
        Element impEl;
        int statusCode;
        Endpoint endpoint;
        InputStream inputMessage = null;
        try {
            ClientConnection connection;
            try {
                endpoint = XmlUtil.createEndpoint((String)contextURI, (String)wsdlURI);
                connection = endpoint.newConnection(TransportMethod.GET);
            }
            catch (MalformedURLException mue) {
                endpoint = contextURI == null ? XmlUtil.createEndpoint(null, (String)new File(wsdlURI).toURL().toString()) : XmlUtil.createEndpoint((String)new File(contextURI).toURL().toString(), (String)wsdlURI);
                connection = endpoint.newConnection(TransportMethod.GET);
            }
            inputMessage = connection.getInputMessage();
            statusCode = inputMessage.getStatusCode();
        }
        catch (Exception exc) {
            String string;
            if (inputMessage != null) {
                try {
                    inputMessage.close();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
            StringBuffer stringBuffer = new StringBuffer().append("Cannot get WSDL at '").append(wsdlURI);
            if (contextURI != null) {
                string = "' relative to '" + contextURI + "'.";
                throw new WSDLException("INVALID_WSDL", stringBuffer.append(string).append("\nException occured: ").append(exc.toString()).toString());
            }
            string = "'.";
            throw new WSDLException("INVALID_WSDL", stringBuffer.append(string).append("\nException occured: ").append(exc.toString()).toString());
        }
        if (statusCode >= 400) {
            if (inputMessage == null) throw new WSDLException("INVALID_WSDL", "Cannot get WSDL from URL '" + endpoint.toExternalForm() + "' (status code " + statusCode + ")");
            try {
                inputMessage.close();
                throw new WSDLException("INVALID_WSDL", "Cannot get WSDL from URL '" + endpoint.toExternalForm() + "' (status code " + statusCode + ")");
            }
            catch (IOException ignore) {
                // empty catch block
            }
            throw new WSDLException("INVALID_WSDL", "Cannot get WSDL from URL '" + endpoint.toExternalForm() + "' (status code " + statusCode + ")");
        }
        try {
            try {
                DocumentBuilderFactory docBF = DocumentBuilderFactory.newInstance();
                docBF.setNamespaceAware(true);
                docBF.setValidating(false);
                DocumentBuilder docB = docBF.newDocumentBuilder();
                Document doc = docB.parse(inputMessage);
                impEl = doc.getDocumentElement();
            }
            catch (Exception pce) {
                throw new WSDLException("PARSER_ERROR", "Exception when parsing document at " + wsdlURI + ". Check it is well-formatted and valid WSDL document. Mesage: " + pce.getMessage());
            }
            Object var13_15 = null;
            if (inputMessage == null) return this.readWSDL(endpoint.toExternalForm(), impEl);
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            if (inputMessage == null) throw throwable;
            try {
                inputMessage.close();
                throw throwable;
            }
            catch (IOException ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ignore) {}
        inputMessage.close();
        return this.readWSDL(endpoint.toExternalForm(), impEl);
    }

    public Definition readWSDL(String documentBaseURI, Element definitionsElement) throws WSDLException {
        if (this.verbose) {
            // empty if block
        }
        HashMap globalMap = new HashMap();
        globalMap.put("definitions", new HashMap());
        globalMap.put("message", new HashMap());
        globalMap.put("portType", new HashMap());
        globalMap.put("binding", new HashMap());
        Definition definitions = this.parseDefinitions(definitionsElement, documentBaseURI, null, globalMap);
        if (this.WSDLSyntaxChecking) {
            WSDLUtil.checkWSDLSyntax(globalMap);
        }
        return definitions;
    }

    public Definition readWSDL(String documentBaseURI, Document wsdlDocument) throws WSDLException {
        if (wsdlDocument == null) {
            throw new WSDLException("INVALID_WSDL", "Given XML Document can't be null.");
        }
        return this.readWSDL(documentBaseURI, wsdlDocument.getDocumentElement());
    }

    public Definition readWSDL(String documentBaseURI, InputSource inputSource) throws WSDLException {
        return this.readWSDL(documentBaseURI, WSDLReaderImpl.parseDocument(inputSource).getDocumentElement());
    }

    public Definition readWSDL(String wsdlURI) throws WSDLException {
        return this.readWSDL(null, wsdlURI);
    }

    public Definition readWSDL(WSDLLocator wsdllocator) throws WSDLException {
        try {
            InputSource inputsource = wsdllocator.getBaseInputSource();
            String baseURI = wsdllocator.getBaseURI();
            this.wsdlLocator = wsdllocator;
            if (inputsource == null) {
                throw new WSDLException("OTHER_ERROR", "WSDLLocator: Unable to locate document at '" + baseURI);
            }
            if (this.verbose) {
                System.out.println("Retrieving document at '" + baseURI + "'.");
            }
            Definition definition = this.readWSDL(baseURI, inputsource);
            Object var6_5 = null;
            this.wsdlLocator = null;
            return definition;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.wsdlLocator = null;
            throw throwable;
        }
    }

    private static Document parseDocument(InputSource is) throws WSDLException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(is);
            return doc;
        }
        catch (Throwable t) {
            throw new WSDLException("PARSER_ERROR", "Error parsing pregenerated WSDL ", t);
        }
    }

    private void extractNamespaces(Definition def, Element el) {
        NamedNodeMap attrList = el.getAttributes();
        int len = attrList.getLength();
        def.getNamespaces().clear();
        int i = 0;
        while (i < len) {
            Attr attr = (Attr)attrList.item(i);
            if (attr.getName().startsWith("xmlns:")) {
                def.addNamespace(attr.getName().substring(6), attr.getValue());
            } else if ("xmlns".equals(attr.getName())) {
                def.addNamespace("", attr.getValue());
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private Definition parseDefinitions(Element el, String documentBaseURI, Map importedDefs, Map globalMap) throws WSDLException {
        block34: {
            try {
                XmlUtil.checkElementName((Element)el, (QName)XmlUtil.DEFINITIONS_QNAME);
            }
            catch (WSDLException e) {
                throw new WSDLException("PARSER_ERROR", "Cannot parse document " + documentBaseURI + " since it is not valid WSDL definition.\nThe root element '{http://schemas.xmlsoap.org/wsdl/}definitions' MUST be present!\nDetail:" + e.getMessage());
            }
            wsdlFactory = WSDLFactory.newInstance((String)(this.factoryImplName != null ? this.factoryImplName : "com.idoox.wsdl.factory.WSDLFactoryImpl"));
            def = wsdlFactory.newDefinition();
            baseURIQName = new QName(null, documentBaseURI != null ? documentBaseURI : "source:/Definition.wsdl");
            WSDLReaderImpl.putToHashmap(globalMap, "definitions", baseURIQName, def);
            if (this.extReg != null) {
                def.setExtensionRegistry(this.extReg);
            }
            if (documentBaseURI != null) {
                def.setDocumentBaseURI(documentBaseURI);
            }
            this.extractNamespaces(def, el);
            definitionNamespace = XmlUtil.getAttribute((Element)el, (String)"targetNamespace");
            definitionName = XmlUtil.getAttribute((Element)el, (String)"name");
            def.setTargetNamespace(definitionNamespace);
            if (definitionName != null) {
                def.setQName(new QName(definitionNamespace, definitionName));
            } else {
                def.setQName(null);
            }
            el = XmlUtil.getFirstChildElement((Node)el);
            if (!this.strictSyntax) ** GOTO lbl90
            if (XmlUtil.testElementName((Element)el, (QName)XmlUtil.DOCUMENTATION_QNAME)) {
                def.setDocumentationElement(el);
                el = XmlUtil.getNextElementSibling((Node)el);
            }
            while (XmlUtil.testElementName((Element)el, (QName)XmlUtil.IMPORT_QNAME)) {
                if (importedDefs /* !! */  == null) {
                    importedDefs /* !! */  = new HashMap<String, Definition>();
                }
                if (documentBaseURI != null) {
                    importedDefs /* !! */ .put(documentBaseURI, def);
                }
                this.parseImport(el, def, importedDefs /* !! */ , globalMap);
                el = XmlUtil.getNextElementSibling((Node)el);
            }
            if (XmlUtil.testElementName((Element)el, (QName)XmlUtil.TYPES_QNAME)) {
                WSDLReaderImpl.parseTypes(el, def);
                el = XmlUtil.getNextElementSibling((Node)el);
            }
            while (XmlUtil.testElementName((Element)el, (QName)XmlUtil.MESSAGE_QNAME)) {
                WSDLReaderImpl.parseMessage(el, def, globalMap);
                el = XmlUtil.getNextElementSibling((Node)el);
            }
            while (XmlUtil.testElementName((Element)el, (QName)XmlUtil.PORTTYPE_QNAME)) {
                WSDLReaderImpl.parsePortType(el, def, globalMap);
                el = XmlUtil.getNextElementSibling((Node)el);
            }
            while (XmlUtil.testElementName((Element)el, (QName)XmlUtil.BINDING_QNAME)) {
                WSDLReaderImpl.parseBinding(el, def, globalMap);
                el = XmlUtil.getNextElementSibling((Node)el);
            }
            while (XmlUtil.testElementName((Element)el, (QName)XmlUtil.SERVICE_QNAME)) {
                WSDLReaderImpl.parseService(el, def, globalMap);
                el = XmlUtil.getNextElementSibling((Node)el);
            }
            while (el != null) {
                def.addExtensibilityElement(WSDLReaderImpl.parseExtensibilityElement(WSDLReaderImpl.class$javax$wsdl$Definition == null ? WSDLReaderImpl.class$("javax.wsdl.Definition") : WSDLReaderImpl.class$javax$wsdl$Definition, def, el));
                el = XmlUtil.getNextElementSibling((Node)el);
            }
            break block34;
lbl-1000:
            // 1 sources

            {
                if (XmlUtil.testElementName((Element)el, (QName)XmlUtil.DOCUMENTATION_QNAME)) {
                    def.setDocumentationElement(el);
                } else if (XmlUtil.testElementName((Element)el, (QName)XmlUtil.IMPORT_QNAME)) {
                    if (importedDefs /* !! */  == null) {
                        importedDefs /* !! */  = new HashMap<K, V>();
                    }
                    if (documentBaseURI != null) {
                        importedDefs /* !! */ .put(documentBaseURI, def);
                    }
                    this.parseImport(el, def, importedDefs /* !! */ , globalMap);
                } else if (XmlUtil.testElementName((Element)el, (QName)XmlUtil.TYPES_QNAME)) {
                    WSDLReaderImpl.parseTypes(el, def);
                } else if (XmlUtil.testElementName((Element)el, (QName)XmlUtil.MESSAGE_QNAME)) {
                    WSDLReaderImpl.parseMessage(el, def, globalMap);
                } else if (XmlUtil.testElementName((Element)el, (QName)XmlUtil.PORTTYPE_QNAME)) {
                    WSDLReaderImpl.parsePortType(el, def, globalMap);
                } else if (XmlUtil.testElementName((Element)el, (QName)XmlUtil.BINDING_QNAME)) {
                    WSDLReaderImpl.parseBinding(el, def, globalMap);
                } else if (XmlUtil.testElementName((Element)el, (QName)XmlUtil.SERVICE_QNAME)) {
                    WSDLReaderImpl.parseService(el, def, globalMap);
                } else if (el != null) {
                    def.addExtensibilityElement(WSDLReaderImpl.parseExtensibilityElement(WSDLReaderImpl.class$javax$wsdl$Definition == null ? WSDLReaderImpl.class$("javax.wsdl.Definition") : WSDLReaderImpl.class$javax$wsdl$Definition, def, el));
                }
                el = XmlUtil.getNextElementSibling((Node)el);
lbl90:
                // 2 sources

                ** while (el != null)
            }
        }
        return def;
    }

    private void parseImport(Element el, Definition def, Map importedDefs, Map globalMap) throws WSDLException {
        Import imp = def.createImport();
        imp.setNamespaceURI(XmlUtil.checkAttribute((Element)el, (String)"namespace"));
        imp.setLocationURI(XmlUtil.checkAttribute((Element)el, (String)"location"));
        if (this.importDocuments) {
            try {
                String importURL = imp.getLocationURI();
                String documentBaseURI = def.getDocumentBaseURI();
                Endpoint endpoint = XmlUtil.createEndpoint((String)documentBaseURI, (String)importURL);
                Definition importedDef = (Definition)importedDefs.get(endpoint.toExternalForm());
                if (importedDef == null) {
                    Element impEl;
                    InputSource inSrc;
                    DocumentBuilder docB;
                    try {
                        DocumentBuilderFactory docBF = DocumentBuilderFactory.newInstance();
                        docBF.setNamespaceAware(true);
                        docBF.setValidating(false);
                        docB = docBF.newDocumentBuilder();
                    }
                    catch (ParserConfigurationException pce) {
                        throw new WSDLException("PARSER_ERROR", pce.getMessage());
                    }
                    Document doc = null;
                    if (this.wsdlLocator != null && (inSrc = this.wsdlLocator.getImportInputSource(documentBaseURI, importURL)) != null) {
                        doc = docB.parse(inSrc);
                    }
                    if (doc == null) {
                        ClientConnection connection = endpoint.newConnection(TransportMethod.GET);
                        InputMessage inputMessage = connection.getInputMessage();
                        int statusCode = inputMessage.getStatusCode();
                        if (statusCode >= 400) {
                            throw new WSDLException("INVALID_WSDL", "Cannot read WSDL from URL '" + endpoint.toExternalForm() + "' (status code " + statusCode + ")");
                        }
                        doc = docB.parse((InputStream)inputMessage);
                    }
                    if (XmlUtil.testElementName((Element)(impEl = doc.getDocumentElement()), (QName)XmlUtil.DEFINITIONS_QNAME)) {
                        if (this.verbose) {
                            System.out.println("Importing document '" + endpoint.toExternalForm() + "'.");
                        }
                        importedDef = this.parseDefinitions(impEl, endpoint.toExternalForm(), importedDefs, globalMap);
                    }
                }
                if (importedDef != null) {
                    imp.setDefinition(importedDef);
                }
            }
            catch (Throwable t) {
                throw new WSDLException("PARSER_ERROR", "Cannot process import: '" + t.getMessage() + "' (" + t.getClass().getName() + ")");
            }
        }
        Element child = XmlUtil.getFirstChildElement((Node)el);
        while (child != null) {
            if (!XmlUtil.testElementName((Element)child, (QName)XmlUtil.DOCUMENTATION_QNAME)) {
                throw new WSDLException("INVALID_WSDL", "Unexpected element '" + child.getNamespaceURI() + ":" + child.getNodeName() + "' in <import> node");
            }
            imp.setDocumentationElement(child);
            child = XmlUtil.getNextElementSibling((Node)child);
        }
        def.addImport(imp);
    }

    private static void parseTypes(Element el, Definition def) throws WSDLException {
        Types types = def.createTypes();
        Element schemaEl = XmlUtil.getFirstChildElement((Node)el);
        while (schemaEl != null) {
            if (XmlUtil.testElementName((Element)schemaEl, (QName)XmlUtil.DOCUMENTATION_QNAME)) {
                types.setDocumentationElement(schemaEl);
            } else {
                types.addExtensibilityElement(WSDLReaderImpl.parseExtensibilityElement(class$javax$wsdl$Types == null ? WSDLReaderImpl.class$("javax.wsdl.Types") : class$javax$wsdl$Types, def, schemaEl));
            }
            schemaEl = XmlUtil.getNextElementSibling((Node)schemaEl);
        }
        def.setTypes(types);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void parseMessage(Element el, Definition def, Map globalMap) throws WSDLException {
        Message msg = null;
        String name = XmlUtil.checkAttribute((Element)el, (String)"name");
        if (name != null) {
            QName messageName = new QName(def.getTargetNamespace(), name);
            msg = (Message)WSDLReaderImpl.getFromHashmap(globalMap, "message", messageName);
            if (msg != null) {
                if (!msg.isUndefined()) throw new WSDLException("INVALID_WSDL", "Message '" + msg.getQName() + "' is duplicated.");
                WSDLReaderImpl.removeFromHashmap(globalMap, "message", messageName);
            } else {
                msg = def.createMessage();
                msg.setQName(messageName);
            }
        }
        msg.setUndefined(false);
        Element parts = XmlUtil.getFirstChildElement((Node)el);
        while (parts != null) {
            if (XmlUtil.testElementName((Element)parts, (QName)XmlUtil.DOCUMENTATION_QNAME)) {
                msg.setDocumentationElement(parts);
            } else {
                if (!XmlUtil.testElementName((Element)parts, (QName)XmlUtil.PART_QNAME)) throw new WSDLException("INVALID_WSDL", "Unexpected element '" + parts.getNamespaceURI() + ":" + parts.getNodeName() + "' in <message> node");
                WSDLReaderImpl.parsePart(parts, def, msg);
            }
            parts = XmlUtil.getNextElementSibling((Node)parts);
        }
        def.addMessage(msg);
    }

    private static void parsePart(Element el, Definition def, Message msg) throws WSDLException {
        Part part = def.createPart();
        part.setName(XmlUtil.checkAttribute((Element)el, (String)"name"));
        part.setElementName(XmlUtil.expandQName((Element)el, (String)XmlUtil.getAttribute((Element)el, (String)"element")));
        part.setTypeName(XmlUtil.expandQName((Element)el, (String)XmlUtil.getAttribute((Element)el, (String)"type")));
        Element chldEl = XmlUtil.getFirstChildElement((Node)el);
        while (chldEl != null) {
            XmlUtil.checkElementName((Element)chldEl, (QName)XmlUtil.DOCUMENTATION_QNAME);
            part.setDocumentationElement(chldEl);
            chldEl = XmlUtil.getNextElementSibling((Node)chldEl);
        }
        msg.addPart(part);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void parsePortType(Element el, Definition def, Map globalMap) throws WSDLException {
        PortType pType = null;
        String name = XmlUtil.checkAttribute((Element)el, (String)"name");
        if (name != null) {
            QName portTypeName = new QName(def.getTargetNamespace(), name);
            pType = (PortType)WSDLReaderImpl.getFromHashmap(globalMap, "portType", portTypeName);
            if (pType != null) {
                if (!pType.isUndefined()) throw new WSDLException("INVALID_WSDL", "PortType '" + pType.getQName() + "' is duplicated.");
                WSDLReaderImpl.removeFromHashmap(globalMap, "portType", portTypeName);
            } else {
                pType = def.createPortType();
                pType.setQName(portTypeName);
            }
        }
        pType.setUndefined(false);
        Element ops = XmlUtil.getFirstChildElement((Node)el);
        while (ops != null) {
            if (XmlUtil.testElementName((Element)ops, (QName)XmlUtil.DOCUMENTATION_QNAME)) {
                pType.setDocumentationElement(ops);
            } else {
                if (!XmlUtil.testElementName((Element)ops, (QName)XmlUtil.OPERATION_QNAME)) throw new WSDLException("INVALID_WSDL", "Unexpected element '" + ops.getNamespaceURI() + ":" + ops.getNodeName() + "' in <portType> node");
                WSDLReaderImpl.parseOperations(ops, def, pType, globalMap);
            }
            ops = XmlUtil.getNextElementSibling((Node)ops);
        }
        def.addPortType(pType);
    }

    private static void parseOperations(Element el, Definition def, PortType pType, Map globalMap) throws WSDLException {
        Operation op = null;
        String name = XmlUtil.checkAttribute((Element)el, (String)"name");
        op = def.createOperation();
        op.setName(name);
        op.setUndefined(false);
        op.setParameterOrdering(XmlUtil.toList((String)XmlUtil.getAttribute((Element)el, (String)"parameterOrder")));
        int operationType = 0;
        Element opIn = XmlUtil.getFirstChildElement((Node)el);
        while (opIn != null) {
            if (XmlUtil.testElementName((Element)opIn, (QName)XmlUtil.DOCUMENTATION_QNAME)) {
                op.setDocumentationElement(opIn);
            } else if (XmlUtil.testElementName((Element)opIn, (QName)XmlUtil.INPUT_QNAME)) {
                WSDLReaderImpl.parseInput(opIn, def, op, globalMap);
                operationType <<= 2;
                ++operationType;
            } else if (XmlUtil.testElementName((Element)opIn, (QName)XmlUtil.OUTPUT_QNAME)) {
                WSDLReaderImpl.parseOutput(opIn, def, op, globalMap);
                operationType <<= 2;
                operationType += 2;
            } else if (XmlUtil.testElementName((Element)opIn, (QName)XmlUtil.FAULT_QNAME)) {
                WSDLReaderImpl.parseFault(opIn, def, op, globalMap);
            } else {
                throw new WSDLException("INVALID_WSDL", "Unexpected element '" + opIn.getNamespaceURI() + ":" + opIn.getNodeName() + "' in <operations> node");
            }
            opIn = XmlUtil.getNextElementSibling((Node)opIn);
        }
        switch (operationType) {
            case 1: {
                op.setStyle(OperationType.ONE_WAY);
                break;
            }
            case 6: {
                op.setStyle(OperationType.REQUEST_RESPONSE);
                break;
            }
            case 9: {
                op.setStyle(OperationType.SOLICIT_RESPONSE);
                break;
            }
            case 2: {
                op.setStyle(OperationType.NOTIFICATION);
                break;
            }
            default: {
                throw new WSDLException("INVALID_WSDL", "Invalid operationType in portType '" + el.getNamespaceURI() + ":" + el.getNodeName() + "'");
            }
        }
        Input opInput = op.getInput();
        Output opOutput = op.getOutput();
        Operation portOp = ((PortTypeImpl)pType).getOperationAdvanced(op.getName(), opInput != null ? opInput.getName() : null, opOutput != null ? opOutput.getName() : null, opInput != null, opOutput != null, op.getStyle());
        if (portOp != null) {
            if (!portOp.isUndefined()) {
                throw new WSDLException("INVALID_WSDL", "Duplicated operation: '" + op.getName() + "' in PortType: '" + pType.getQName() + "'");
            }
            ((OperationImpl)portOp).redefine(op);
            portOp.setUndefined(false);
        } else {
            pType.addOperation(op);
        }
    }

    private static void parseInput(Element el, Definition def, Operation op, Map globalMap) throws WSDLException {
        Input input = def.createInput();
        String name = XmlUtil.getAttribute((Element)el, (String)"name");
        QName messageName = XmlUtil.expandQName((Element)el, (String)XmlUtil.checkAttribute((Element)el, (String)"message"));
        input.setName(name);
        if (messageName != null) {
            Message message = (Message)WSDLReaderImpl.getFromHashmap(globalMap, "message", messageName);
            if (message == null) {
                message = def.createMessage();
                message.setQName(messageName);
                WSDLReaderImpl.putToHashmap(globalMap, "message", messageName, message);
            }
            input.setMessage(message);
        }
        Element inEl = XmlUtil.getFirstChildElement((Node)el);
        while (inEl != null) {
            if (!XmlUtil.testElementName((Element)inEl, (QName)XmlUtil.DOCUMENTATION_QNAME)) {
                throw new WSDLException("INVALID_WSDL", "Unexpected element '" + inEl.getNamespaceURI() + ":" + inEl.getNodeName() + "' in <input> node");
            }
            input.setDocumentationElement(inEl);
            inEl = XmlUtil.getNextElementSibling((Node)inEl);
        }
        op.setInput(input);
    }

    private static void parseOutput(Element el, Definition def, Operation op, Map globalMap) throws WSDLException {
        Output output = def.createOutput();
        String name = XmlUtil.getAttribute((Element)el, (String)"name");
        QName messageName = XmlUtil.expandQName((Element)el, (String)XmlUtil.checkAttribute((Element)el, (String)"message"));
        output.setName(name);
        if (messageName != null) {
            Message message = (Message)WSDLReaderImpl.getFromHashmap(globalMap, "message", messageName);
            if (message == null) {
                message = def.createMessage();
                message.setQName(messageName);
                WSDLReaderImpl.putToHashmap(globalMap, "message", messageName, message);
            }
            output.setMessage(message);
        }
        Element inEl = XmlUtil.getFirstChildElement((Node)el);
        while (inEl != null) {
            if (!XmlUtil.testElementName((Element)inEl, (QName)XmlUtil.DOCUMENTATION_QNAME)) {
                throw new WSDLException("INVALID_WSDL", "Unexpected element '" + inEl.getNamespaceURI() + ":" + inEl.getNodeName() + "' in <output> node");
            }
            output.setDocumentationElement(inEl);
            inEl = XmlUtil.getNextElementSibling((Node)inEl);
        }
        op.setOutput(output);
    }

    private static void parseFault(Element el, Definition def, Operation op, Map globalMap) throws WSDLException {
        Fault fault = def.createFault();
        String name = XmlUtil.getAttribute((Element)el, (String)"name");
        QName messageName = XmlUtil.expandQName((Element)el, (String)XmlUtil.checkAttribute((Element)el, (String)"message"));
        fault.setName(name);
        if (messageName != null) {
            Message message = (Message)WSDLReaderImpl.getFromHashmap(globalMap, "message", messageName);
            if (message == null) {
                message = def.createMessage();
                message.setQName(messageName);
                WSDLReaderImpl.putToHashmap(globalMap, "message", messageName, message);
            }
            fault.setMessage(message);
        }
        Element inEl = XmlUtil.getFirstChildElement((Node)el);
        while (inEl != null) {
            if (!XmlUtil.testElementName((Element)inEl, (QName)XmlUtil.DOCUMENTATION_QNAME)) {
                throw new WSDLException("INVALID_WSDL", "Unexpected element '" + inEl.getNamespaceURI() + ":" + inEl.getNodeName() + "' in <fault> node");
            }
            fault.setDocumentationElement(inEl);
            inEl = XmlUtil.getNextElementSibling((Node)inEl);
        }
        op.addFault(fault);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void parseBinding(Element el, Definition def, Map globalMap) throws WSDLException {
        Binding bnd = null;
        PortType portType = null;
        String name = XmlUtil.checkAttribute((Element)el, (String)"name");
        QName portTypeName = XmlUtil.expandQName((Element)el, (String)XmlUtil.checkAttribute((Element)el, (String)"type"));
        if (name != null) {
            QName bindingName = new QName(def.getTargetNamespace(), name);
            bnd = (Binding)WSDLReaderImpl.getFromHashmap(globalMap, "binding", bindingName);
            if (bnd != null) {
                if (!bnd.isUndefined()) throw new WSDLException("INVALID_WSDL", "Binding '" + bnd.getQName() + "' is duplicated.");
                WSDLReaderImpl.removeFromHashmap(globalMap, "binding", bindingName);
            } else {
                bnd = def.createBinding();
                bnd.setQName(bindingName);
            }
        } else {
            bnd = def.createBinding();
        }
        bnd.setUndefined(false);
        if (portTypeName != null) {
            portType = (PortType)WSDLReaderImpl.getFromHashmap(globalMap, "portType", portTypeName);
            if (portType == null) {
                portType = def.createPortType();
                portType.setQName(portTypeName);
                WSDLReaderImpl.putToHashmap(globalMap, "portType", portTypeName, portType);
            }
            bnd.setPortType(portType);
        }
        HashMap usedOperations = new HashMap();
        Element ops = XmlUtil.getFirstChildElement((Node)el);
        while (ops != null) {
            if (XmlUtil.testElementName((Element)ops, (QName)XmlUtil.DOCUMENTATION_QNAME)) {
                bnd.setDocumentationElement(ops);
            } else if (XmlUtil.testElementName((Element)ops, (QName)XmlUtil.OPERATION_QNAME)) {
                WSDLReaderImpl.parseBindingOperation(ops, def, portType, bnd, usedOperations);
            } else {
                bnd.addExtensibilityElement(WSDLReaderImpl.parseExtensibilityElement(class$javax$wsdl$Binding == null ? WSDLReaderImpl.class$("javax.wsdl.Binding") : class$javax$wsdl$Binding, def, ops));
            }
            ops = XmlUtil.getNextElementSibling((Node)ops);
        }
        def.addBinding(bnd);
    }

    private static void parseBindingOperation(Element el, Definition def, PortType portType, Binding bnd, Map usedOperations) throws WSDLException {
        BindingOperation bndOperation = def.createBindingOperation();
        String name = XmlUtil.checkAttribute((Element)el, (String)"name");
        bndOperation.setName(name);
        Element bndOpEl = XmlUtil.getFirstChildElement((Node)el);
        while (bndOpEl != null) {
            if (XmlUtil.testElementName((Element)bndOpEl, (QName)XmlUtil.DOCUMENTATION_QNAME)) {
                bndOperation.setDocumentationElement(bndOpEl);
            } else if (XmlUtil.testElementName((Element)bndOpEl, (QName)XmlUtil.INPUT_QNAME)) {
                WSDLReaderImpl.parseBindingInput(bndOpEl, def, bndOperation);
            } else if (XmlUtil.testElementName((Element)bndOpEl, (QName)XmlUtil.OUTPUT_QNAME)) {
                WSDLReaderImpl.parseBindingOutput(bndOpEl, def, bndOperation);
            } else if (XmlUtil.testElementName((Element)bndOpEl, (QName)XmlUtil.FAULT_QNAME)) {
                WSDLReaderImpl.parseBindingFault(bndOpEl, def, bndOperation);
            } else {
                bndOperation.addExtensibilityElement(WSDLReaderImpl.parseExtensibilityElement(class$javax$wsdl$BindingOperation == null ? WSDLReaderImpl.class$("javax.wsdl.BindingOperation") : class$javax$wsdl$BindingOperation, def, bndOpEl));
            }
            bndOpEl = XmlUtil.getNextElementSibling((Node)bndOpEl);
        }
        if (portType != null) {
            Operation usedOperation;
            HashMap<Operation, Operation> usedPortType;
            Operation op;
            BindingInput bndInput = bndOperation.getBindingInput();
            BindingOutput bndOutput = bndOperation.getBindingOutput();
            boolean inputDefined = bndInput != null;
            boolean outputDefined = bndOutput != null;
            OperationType operationType = OperationType.REQUEST_RESPONSE;
            if (!outputDefined) {
                operationType = OperationType.ONE_WAY;
            }
            if (!inputDefined) {
                operationType = OperationType.NOTIFICATION;
            }
            if ((op = ((PortTypeImpl)portType).getOperationAdvanced(name, inputDefined ? bndInput.getName() : null, outputDefined ? bndOutput.getName() : null, inputDefined, outputDefined, operationType)) == null && operationType == OperationType.REQUEST_RESPONSE) {
                op = ((PortTypeImpl)portType).getOperationAdvanced(name, inputDefined ? bndInput.getName() : null, outputDefined ? bndOutput.getName() : null, inputDefined, outputDefined, OperationType.SOLICIT_RESPONSE);
            }
            if (op == null) {
                op = def.createOperation();
                op.setName(name);
                if (inputDefined) {
                    Input opInput = def.createInput();
                    opInput.setName(bndInput.getName());
                    op.setInput(opInput);
                }
                if (outputDefined) {
                    Output opOutput = def.createOutput();
                    opOutput.setName(bndOutput.getName());
                    op.setOutput(opOutput);
                }
                portType.addOperation(op);
            }
            if ((usedPortType = (HashMap<Operation, Operation>)usedOperations.get(portType.getQName())) == null) {
                usedPortType = new HashMap<Operation, Operation>();
                usedOperations.put(portType.getQName(), usedPortType);
            }
            if ((usedOperation = (Operation)usedPortType.get(op)) != null) {
                throw new WSDLException("INVALID_WSDL", "Ambiguous operation reference: '" + op.getName() + "' in Binding: '" + bnd.getQName() + "'");
            }
            usedPortType.put(op, op);
            bndOperation.setOperation(op);
        }
        bnd.addBindingOperation(bndOperation);
    }

    private static void parseBindingInput(Element el, Definition def, BindingOperation bndOperation) throws WSDLException {
        BindingInput bndInput = def.createBindingInput();
        bndInput.setName(XmlUtil.getAttribute((Element)el, (String)"name"));
        Element inEl = XmlUtil.getFirstChildElement((Node)el);
        while (inEl != null) {
            if (XmlUtil.testElementName((Element)inEl, (QName)XmlUtil.DOCUMENTATION_QNAME)) {
                bndInput.setDocumentationElement(inEl);
            } else {
                bndInput.addExtensibilityElement(WSDLReaderImpl.parseExtensibilityElement(class$javax$wsdl$BindingInput == null ? WSDLReaderImpl.class$("javax.wsdl.BindingInput") : class$javax$wsdl$BindingInput, def, inEl));
            }
            inEl = XmlUtil.getNextElementSibling((Node)inEl);
        }
        bndOperation.setBindingInput(bndInput);
    }

    private static void parseBindingOutput(Element el, Definition def, BindingOperation bndOperation) throws WSDLException {
        BindingOutput bndOutput = def.createBindingOutput();
        bndOutput.setName(XmlUtil.getAttribute((Element)el, (String)"name"));
        Element outEl = XmlUtil.getFirstChildElement((Node)el);
        while (outEl != null) {
            if (XmlUtil.testElementName((Element)outEl, (QName)XmlUtil.DOCUMENTATION_QNAME)) {
                bndOutput.setDocumentationElement(outEl);
            } else {
                bndOutput.addExtensibilityElement(WSDLReaderImpl.parseExtensibilityElement(class$javax$wsdl$BindingInput == null ? WSDLReaderImpl.class$("javax.wsdl.BindingInput") : class$javax$wsdl$BindingInput, def, outEl));
            }
            outEl = XmlUtil.getNextElementSibling((Node)outEl);
        }
        bndOperation.setBindingOutput(bndOutput);
    }

    private static void parseBindingFault(Element el, Definition def, BindingOperation bndOperation) throws WSDLException {
        BindingFault bndFault = def.createBindingFault();
        bndFault.setName(XmlUtil.getAttribute((Element)el, (String)"name"));
        Element fltEl = XmlUtil.getFirstChildElement((Node)el);
        while (fltEl != null) {
            if (XmlUtil.testElementName((Element)fltEl, (QName)XmlUtil.DOCUMENTATION_QNAME)) {
                bndFault.setDocumentationElement(fltEl);
            } else {
                bndFault.addExtensibilityElement(WSDLReaderImpl.parseExtensibilityElement(class$javax$wsdl$BindingFault == null ? WSDLReaderImpl.class$("javax.wsdl.BindingFault") : class$javax$wsdl$BindingFault, def, fltEl));
            }
            fltEl = XmlUtil.getNextElementSibling((Node)fltEl);
        }
        String name = bndFault.getName();
        if (name == null) {
            List extensibilityElements = bndFault.getExtensibilityElements();
            if (extensibilityElements.size() == 1) {
                Iterator it = extensibilityElements.iterator();
                ExtensibilityElement ext = (ExtensibilityElement)it.next();
                if (ext instanceof SOAPFault) {
                    name = ((SOAPFault)ext).getName();
                    bndFault.setName(name);
                }
            } else {
                throw new WSDLException("INVALID_WSDL", "Operation '" + bndOperation.getName() + "' contains fault without name!");
            }
        }
        bndOperation.addBindingFault(bndFault);
    }

    private static void parseService(Element el, Definition def, Map globalMap) throws WSDLException {
        Service srv = def.createService();
        srv.setQName(new QName(def.getTargetNamespace(), XmlUtil.checkAttribute((Element)el, (String)"name")));
        Element ports = XmlUtil.getFirstChildElement((Node)el);
        while (ports != null) {
            if (XmlUtil.testElementName((Element)ports, (QName)XmlUtil.DOCUMENTATION_QNAME)) {
                srv.setDocumentationElement(ports);
            } else if (XmlUtil.testElementName((Element)ports, (QName)XmlUtil.PORT_QNAME)) {
                WSDLReaderImpl.parsePort(ports, def, srv, globalMap);
            } else {
                srv.addExtensibilityElement(WSDLReaderImpl.parseExtensibilityElement(class$javax$wsdl$Service == null ? WSDLReaderImpl.class$("javax.wsdl.Service") : class$javax$wsdl$Service, def, ports));
            }
            ports = XmlUtil.getNextElementSibling((Node)ports);
        }
        def.addService(srv);
    }

    private static void parsePort(Element el, Definition def, Service srv, Map globalMap) throws WSDLException {
        Port port = def.createPort();
        port.setName(XmlUtil.checkAttribute((Element)el, (String)"name"));
        QName portBindingName = XmlUtil.expandQName((Element)el, (String)XmlUtil.checkAttribute((Element)el, (String)"binding"));
        if (portBindingName != null) {
            Binding binding = (Binding)WSDLReaderImpl.getFromHashmap(globalMap, "binding", portBindingName);
            if (binding == null) {
                binding = def.createBinding();
                binding.setQName(portBindingName);
                WSDLReaderImpl.putToHashmap(globalMap, "binding", portBindingName, binding);
            }
            port.setBinding(binding);
        }
        Element portEl = XmlUtil.getFirstChildElement((Node)el);
        while (portEl != null) {
            if (XmlUtil.testElementName((Element)portEl, (QName)XmlUtil.DOCUMENTATION_QNAME)) {
                port.setDocumentationElement(portEl);
            } else {
                port.addExtensibilityElement(WSDLReaderImpl.parseExtensibilityElement(class$javax$wsdl$Port == null ? WSDLReaderImpl.class$("javax.wsdl.Port") : class$javax$wsdl$Port, def, portEl));
            }
            portEl = XmlUtil.getNextElementSibling((Node)portEl);
        }
        srv.addPort(port);
    }

    private static ExtensibilityElement parseExtensibilityElement(Class parentType, Definition def, Element el) throws WSDLException {
        QName extQN = ElementHelper.getTagName((Element)el);
        ExtensionRegistry extReg = def.getExtensionRegistry();
        if (extReg == null) {
            throw new WSDLException("CONFIGURATION_ERROR", "Definition has no ExtensionRegistry set.");
        }
        ExtensionDeserializer extDes = extReg.queryDeserializer(parentType, extQN);
        ExtensibilityElement extEl = extDes.unmarshall(parentType, extQN, el, def, extReg);
        return extEl;
    }

    private static void checkWSDLSyntax(Map globalMap) throws WSDLException {
        Map definitions = (Map)globalMap.get("definitions");
        Map messages = (Map)globalMap.get("message");
        Map portTypes = (Map)globalMap.get("portType");
        Map bindings = (Map)globalMap.get("binding");
        if (!messages.isEmpty()) {
            Message message = (Message)messages.values().iterator().next();
            throw new WSDLException("INVALID_WSDL", "Referenced message not found: '" + message.getQName() + "'");
        }
        if (!portTypes.isEmpty()) {
            PortType portType = (PortType)portTypes.values().iterator().next();
            throw new WSDLException("INVALID_WSDL", "Referenced portType not found: '" + portType.getQName() + "'");
        }
        if (!bindings.isEmpty()) {
            Binding binding = (Binding)bindings.values().iterator().next();
            throw new WSDLException("INVALID_WSDL", "Referenced binding not found: '" + binding.getQName() + "'");
        }
        Iterator defIter = definitions.values().iterator();
        while (defIter.hasNext()) {
            Definition def = (Definition)defIter.next();
            Iterator pTypeIter = def.getPortTypes().values().iterator();
            while (pTypeIter.hasNext()) {
                PortType portType = (PortType)pTypeIter.next();
                HashMap<String, Input> inputMap = new HashMap<String, Input>();
                HashMap<String, Output> outputMap = new HashMap<String, Output>();
                Iterator opIter = portType.getOperations().iterator();
                while (opIter.hasNext()) {
                    Operation operation = (Operation)opIter.next();
                    if (operation.isUndefined()) {
                        throw new WSDLException("INVALID_WSDL", "Referenced operation not found: '" + operation.getName() + "' in PortType: '" + portType.getQName() + "'");
                    }
                    OperationType operationType = operation.getStyle();
                    Input input = operation.getInput();
                    Output output = operation.getOutput();
                    if (input != null) {
                        String inputName = input.getName();
                        if (inputName == null || inputName.length() == 0) {
                            inputName = operationType.equals(OperationType.REQUEST_RESPONSE) ? operation.getName() + "Request" : (operationType.equals(OperationType.SOLICIT_RESPONSE) ? operation.getName() + "Response" : operation.getName());
                        }
                        if (inputMap.put(inputName, input) != null) {
                            throw new WSDLException("INVALID_WSDL", "Duplicated input: '" + inputName + "' in operation: '" + operation.getName() + "' in portType: '" + portType.getQName() + "'");
                        }
                    }
                    if (output == null) continue;
                    String outputName = output.getName();
                    if (outputName == null || outputName.length() == 0) {
                        outputName = operationType.equals(OperationType.REQUEST_RESPONSE) ? operation.getName() + "Response" : (operationType.equals(OperationType.SOLICIT_RESPONSE) ? operation.getName() + "Solicit" : operation.getName());
                    }
                    if (outputMap.put(outputName, output) == null) continue;
                    throw new WSDLException("INVALID_WSDL", "Duplicated output: '" + outputName + "' in operation: '" + operation.getName() + "' in portType: '" + portType.getQName() + "'");
                }
            }
        }
    }

    private static Object getFromHashmap(Map globalMap, String gettingType, QName name) {
        Map typeMap = (Map)globalMap.get(gettingType);
        if (typeMap == null) {
            return null;
        }
        Object toRet = typeMap.get(name);
        if (toRet == null) {
            Iterator defIter = ((Map)globalMap.get("definitions")).values().iterator();
            while (defIter.hasNext()) {
                DefinitionImpl defImpl = (DefinitionImpl)defIter.next();
                toRet = defImpl.getLocalDefinition(gettingType, name);
                if (toRet == null) continue;
                return toRet;
            }
        }
        return toRet;
    }

    private static Object putToHashmap(Map globalMap, String puttingType, QName name, Object obj) {
        Map typeMap = (Map)globalMap.get(puttingType);
        if (typeMap == null) {
            return null;
        }
        return typeMap.put(name, obj);
    }

    private static Object removeFromHashmap(Map globalMap, String removingType, QName name) {
        Map typeMap = (Map)globalMap.get(removingType);
        if (typeMap == null) {
            return null;
        }
        return typeMap.remove(name);
    }

    public String toString() {
        return this.getClass().getName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

